/*
 * Decompiled with CFR 0.152.
 */
package movwebclientx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import movwebclientx.SynopticCanvas;
import org.eldos.MsgConnect.IntegerHolder;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCDirectTransport;
import org.eldos.MsgConnect.MCBase.MCErrorProc;
import org.eldos.MsgConnect.MCBase.MCMessage;
import org.eldos.MsgConnect.MCBase.MCMessenger;
import org.eldos.MsgConnect.MCBase.MCNotifyProc;
import org.eldos.MsgConnect.MCBase.MCTimeoutProc;
import org.eldos.MsgConnect.MCCompression.MCZLibCompression;
import org.eldos.MsgConnect.MCEncryption.MCAESEncryption;
import org.eldos.MsgConnect.MCHttpSocket.MCHttpTransport;
import org.eldos.MsgConnect.MCSealing.MCAdlerSealing;
import org.eldos.MsgConnect.MCSealing.MCCRC32Sealing;
import org.eldos.MsgConnect.MCSealing.MCMD5Sealing;
import org.eldos.MsgConnect.MCSocket.MCSocketTransport;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPTransport;

public class Applet1
extends JApplet
implements MCNotifyProc,
MCErrorProc,
MCTimeoutProc,
ImageObserver,
ActionListener {
    public static String sLocalID;
    private MCMessage lastMessageSent = new MCMessage();
    public static final int MMR_NOOP = 1000;
    public static final int MMR_AUTHENTICATE = 1001;
    public static final int MMR_MONITORVARIABLEGET = 1002;
    public static final int MMR_MONITORVARIABLEPOLL = 1003;
    public static final int MMR_MONITORVARIABLESTOP = 1004;
    public static final int MMR_GETLISTVARIABLES = 1005;
    public static final int MMR_CHECKLISTVARIABLES = 1006;
    public static final int MMR_LOGGINGOFF = 1007;
    public static final int MMR_CONNECTIONCLOSED = 1008;
    public static final int MMR_MONITORVARIABLESET = 1009;
    public static final int MMR_MONITORVARIABLECHANGED = 1010;
    public static final int MMR_GETVARIABLETYPE = 1011;
    public static final int MMR_FETCHHISLOGDATA = 1012;
    public static final int MMR_FETCHDLRDATA = 1013;
    public static final int MMR_FETCHTRACEDBDATA = 1014;
    public static final int MMR_MONITORALARMSGET = 1015;
    public static final int MMR_MONITORALARMSPOLL = 1016;
    public static final int MMR_MONITORALARMSSTOP = 1017;
    public static final int MMR_MONITORALARMSACK = 1018;
    public static final int MMR_MONITORALARMSRESET = 1019;
    public static final int MMR_NOTIFYNEWMESSAGESAVAILABLE = 1020;
    public static final int MMR_NOTIFYSCREENCHANGED = 1021;
    public static final int MMR_OPENSCREEN = 1022;
    public static final int MMR_MONITORSCREENPOLL = 1023;
    public static final int MMR_POSTSCREENMOUSEMOVE = 1024;
    public static final int MMR_POSTSCREENMOUSEDOWN = 1025;
    public static final int MMR_POSTSCREENMOUSEUP = 1026;
    public static final int MMR_POSTSCREENKEYDOWN = 1027;
    public static final int MMR_POSTSCREENKEYUP = 1028;
    public static final int MMR_USERDATADEFINITION = 1029;
    public static final int MMR_FETCHUSERMESSAGES = 1030;
    public static final int MMR_ALPHANUMERICENTRY = 1031;
    public static final int MMR_NOTIFYNEWDEBUGPRINTSAVAILABLE = 1032;
    public static final int MMR_FETCHUSERDEBUGPRINTS = 1033;
    public static final int MMR_OK = 1;
    public static final int MMR_NOT_AUTHENTICATED = 2;
    public static final int MMR_NOTFOUND = 3;
    public static final int MMR_NOTCOMPLETE = 4;
    public static final int MMR_PROCESSING = 5;
    public static final int MMR_CHANGED = 6;
    public static final int MMR_COMPLEXTYPE = 7;
    public static final int MMR_STRINGTYPE = 8;
    public static final int MMR_ERROR = 9;
    public static final int MMR_MESSAGEBOX = 10;
    public static final int MMR_ENTEREDITMODE = 11;
    public static final int MMR_DEBUGPRINT = 12;
    public static final int MMR_NOT_AUTHENTICATEDFORLICENSE = 100;
    public static final int MCT_J2SE = 7779;
    private MCMessenger messenger = new MCMessenger();
    private MCZLibCompression MCZlibCompressor;
    private MCAESEncryption MCAESEncryptor;
    private MCAdlerSealing MCAdlerSealer;
    private MCCRC32Sealing MCCRC32Sealer;
    private MCMD5Sealing MCMD5Sealer;
    private MCHttpTransport httpTransport;
    private MCSocketTransport socketTransport;
    private MCUDPTransport udpTransport;
    private MCDirectTransport directTransport;
    private DispatchTask dispatchTimer;
    private boolean interruptTimerThread = false;
    private String destAddr = null;
    private int nx = 0;
    private int ny = 0;
    private int nToken = 0;
    public boolean bConnected = false;
    public boolean bScreenChanged = false;
    public String CurrUserName;
    public String CurrPassword;
    public String CurrVarName;
    public Vector VariableArray;
    private SynopticCanvas synopticCanvas;
    private JLabel statusBar;
    private boolean bKeepPolling;
    private boolean bEnablePollingOnImageObserver;
    private int nMaxListSize = -1;
    private int nDefPollTime = 1;
    private int nErrorCounter = 0;
    private boolean isStandalone = false;
    String ServerName;
    String SynopticName;
    String RequestedScreen;
    int ServerPort;
    String UserName;
    String Password;
    int Protocol;
    boolean Compress;
    boolean Encrypt;
    boolean bShowMenu;
    boolean MouseMotion;
    boolean MouseClicks;
    boolean KeyEvents;
    boolean ShowStatusBar;
    int nNumColors;
    private PasswordChooser dialog = null;
    boolean bSendEventsEnabled = false;
    int Sealing;
    int Timeout;
    JMenuBar jMenuBar1;
    JMenu jMenu1;
    JMenuItem jMenuItem1;
    JMenuItem jMenuItem2;
    JMenuItem jMenuItem3;
    JMenuItem jMenuItem4;
    JMenuItem jMenuItem5;
    JMenuItem jMenuItem6;
    JMenuItem jMenuItem7;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public ImageIcon getImageIcon(String relativePath) {
        URL url = null;
        ImageIcon icon = null;
        ClassLoader loader = this.getClass().getClassLoader();
        url = loader != null ? loader.getResource(relativePath) : ClassLoader.getSystemResource(relativePath);
        if (url != null) {
            icon = new ImageIcon(url);
        } else {
            System.err.println("Warning: Image '" + relativePath + "' not found.");
        }
        return icon;
    }

    @Override
    public void init() {
        try {
            this.ServerName = this.getParameter("ServerName", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.SynopticName = this.getParameter("Synoptic", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.ServerPort = Integer.parseInt(this.getParameter("ServerPort", "12233"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.CurrUserName = this.UserName = this.getParameter("UserName", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.CurrPassword = this.Password = this.getParameter("Password", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.Protocol = Integer.parseInt(this.getParameter("Protocol", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.Compress = Boolean.valueOf(this.getParameter("Compress", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.Encrypt = Boolean.valueOf(this.getParameter("Encrypt", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.Sealing = Integer.parseInt(this.getParameter("Sealing", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.Timeout = Integer.parseInt(this.getParameter("Timeout", "5000"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.bShowMenu = Boolean.valueOf(this.getParameter("ShowMenu", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.MouseMotion = Boolean.valueOf(this.getParameter("MouseMotion", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.MouseClicks = Boolean.valueOf(this.getParameter("MouseClicks", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.KeyEvents = Boolean.valueOf(this.getParameter("KeyEvents", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.ShowStatusBar = Boolean.valueOf(this.getParameter("ShowStatusBar", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.nNumColors = Integer.parseInt(this.getParameter("NumColors", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("ServerName = " + String.valueOf(this.ServerName));
        System.out.println("SynopticName = " + String.valueOf(this.SynopticName));
        System.out.println("ServerPort = " + String.valueOf(this.ServerPort));
        System.out.println("UserName = " + String.valueOf(this.UserName));
        System.out.println("Password = " + String.valueOf(this.Password));
        System.out.println("Protocol = " + String.valueOf(this.Protocol));
        System.out.println("Compress = " + String.valueOf(this.Compress));
        System.out.println("Encrypt = " + String.valueOf(this.Encrypt));
        System.out.println("bShowMenu = " + String.valueOf(this.bShowMenu));
        System.out.println("MouseMotion = " + String.valueOf(this.MouseMotion));
        System.out.println("MouseClicks = " + String.valueOf(this.MouseClicks));
        System.out.println("KeyEvents = " + String.valueOf(this.KeyEvents));
        System.out.println("ShowStatusBar = " + String.valueOf(this.ShowStatusBar));
        System.out.println("NumColors = " + String.valueOf(this.nNumColors));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == this.jMenuItem1.getActionCommand()) {
            boolean bTemp = this.bSendEventsEnabled;
            this.bSendEventsEnabled = false;
            String str = JOptionPane.showInputDialog(null, (Object)"Please, Enter the Screen Name (Leave blank to open the startup)");
            this.bSendEventsEnabled = bTemp;
            if (str == null) {
                return;
            }
            this.getContentPane().removeAll();
            this.getContentPane().add((Component)this.synopticCanvas, "Center");
            if (this.ShowStatusBar) {
                this.getContentPane().add((Component)this.statusBar, "South");
            }
        } else if (e.getActionCommand() == this.jMenuItem7.getActionCommand()) {
            this.PromptForPassword();
        }
    }

    private void jbInit() throws Exception {
        if (this.bShowMenu) {
            this.jMenuBar1 = new JMenuBar();
            this.jMenu1 = new JMenu();
            this.jMenuItem1 = new JMenuItem("Open Screen...", this.getImageIcon("icons\\Service0-8.png"));
            this.jMenuItem2 = new JMenuItem("Get Variable Value...", this.getImageIcon("icons\\Service1-8.png"));
            this.jMenuItem3 = new JMenuItem("Fetch HisLog data...", this.getImageIcon("icons\\Service2-8.png"));
            this.jMenuItem4 = new JMenuItem("Fetch DataLogger/Recipe data...", this.getImageIcon("icons\\Service3-8.png"));
            this.jMenuItem5 = new JMenuItem("Fetch Trace DB data...", this.getImageIcon("icons\\Service4-8.png"));
            this.jMenuItem6 = new JMenuItem("Get Current Alarm List...", this.getImageIcon("icons\\Service5-8.png"));
            this.jMenuItem7 = new JMenuItem("Log in as a different User...", this.getImageIcon("icons\\Service6-8.png"));
            this.jMenu1.setText("Services");
            this.jMenuBar1.add(this.jMenu1);
            this.jMenu1.add(this.jMenuItem1);
            this.jMenu1.add(this.jMenuItem2);
            this.jMenu1.add(this.jMenuItem3);
            this.jMenu1.add(this.jMenuItem4);
            this.jMenu1.add(this.jMenuItem5);
            this.jMenu1.add(this.jMenuItem6);
            this.jMenu1.add(this.jMenuItem7);
            this.setJMenuBar(this.jMenuBar1);
            this.jMenuItem1.addActionListener(this);
            this.jMenuItem2.addActionListener(this);
            this.jMenuItem3.addActionListener(this);
            this.jMenuItem4.addActionListener(this);
            this.jMenuItem5.addActionListener(this);
            this.jMenuItem6.addActionListener(this);
            this.jMenuItem7.addActionListener(this);
        }
        this.synopticCanvas = new SynopticCanvas(this);
        this.getContentPane().add((Component)this.synopticCanvas, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Ready");
        if (this.ShowStatusBar) {
            this.getContentPane().add((Component)this.statusBar, "South");
        }
        try {
            block5 : switch (this.Protocol) {
                case 1: {
                    this.httpTransport = new MCHttpTransport();
                    this.httpTransport.setTransportMode((byte)2);
                    this.httpTransport.setMaxTimeout(5000L);
                    this.httpTransport.setInactivityTime(300000L);
                    this.httpTransport.setMessenger(this.messenger);
                    this.httpTransport.setFailOnInactive(true);
                    if (this.Compress) {
                        this.MCZlibCompressor = new MCZLibCompression();
                        this.MCZlibCompressor.setCompressionLevel(6);
                        this.httpTransport.setCompressor(this.MCZlibCompressor);
                    }
                    if (this.Encrypt) {
                        this.MCAESEncryptor = new MCAESEncryption();
                        String s = new String("D4999F7E-FEC0-4c32-B86A-6506B6B1C375");
                        byte[] key = new byte[16];
                        for (int i = 0; i < key.length; i = (int)((byte)(i + 1))) {
                            key[i] = (byte)s.charAt(i);
                        }
                        try {
                            this.MCAESEncryptor.setKey(null, key);
                        }
                        catch (EMCError ex) {
                            // empty catch block
                        }
                        this.httpTransport.setEncryptor(this.MCAESEncryptor);
                    }
                    switch (this.Sealing) {
                        case 1: {
                            this.MCAdlerSealer = new MCAdlerSealing();
                            this.httpTransport.setSealer(this.MCAdlerSealer);
                            break block5;
                        }
                        case 2: {
                            this.MCCRC32Sealer = new MCCRC32Sealing();
                            this.httpTransport.setSealer(this.MCCRC32Sealer);
                            break block5;
                        }
                        case 3: {
                            this.MCMD5Sealer = new MCMD5Sealing();
                            this.httpTransport.setSealer(this.MCMD5Sealer);
                        }
                    }
                    break;
                }
                case 2: {
                    this.udpTransport = new MCUDPTransport();
                    this.udpTransport.setTransportMode((byte)2);
                    this.udpTransport.setMaxTimeout(5000L);
                    this.udpTransport.setMessenger(this.messenger);
                    this.udpTransport.setFailOnInactive(true);
                    if (this.Compress) {
                        this.MCZlibCompressor = new MCZLibCompression();
                        this.MCZlibCompressor.setCompressionLevel(6);
                        this.udpTransport.setCompressor(this.MCZlibCompressor);
                    }
                    if (this.Encrypt) {
                        this.MCAESEncryptor = new MCAESEncryption();
                        String s = new String("D4999F7E-FEC0-4c32-B86A-6506B6B1C375");
                        byte[] key = new byte[16];
                        for (int i = 0; i < key.length; i = (int)((byte)(i + 1))) {
                            key[i] = (byte)s.charAt(i);
                        }
                        try {
                            this.MCAESEncryptor.setKey(null, key);
                        }
                        catch (EMCError ex) {
                            // empty catch block
                        }
                        this.udpTransport.setEncryptor(this.MCAESEncryptor);
                    }
                    switch (this.Sealing) {
                        case 1: {
                            this.MCAdlerSealer = new MCAdlerSealing();
                            this.udpTransport.setSealer(this.MCAdlerSealer);
                            break block5;
                        }
                        case 2: {
                            this.MCCRC32Sealer = new MCCRC32Sealing();
                            this.udpTransport.setSealer(this.MCCRC32Sealer);
                            break block5;
                        }
                        case 3: {
                            this.MCMD5Sealer = new MCMD5Sealing();
                            this.udpTransport.setSealer(this.MCMD5Sealer);
                        }
                    }
                    break;
                }
                case 3: {
                    this.directTransport = new MCDirectTransport();
                    this.directTransport.setMaxTimeout(5000L);
                    this.directTransport.setMessenger(this.messenger);
                    if (this.Compress) {
                        this.MCZlibCompressor = new MCZLibCompression();
                        this.MCZlibCompressor.setCompressionLevel(6);
                        this.directTransport.setCompressor(this.MCZlibCompressor);
                    }
                    if (this.Encrypt) {
                        this.MCAESEncryptor = new MCAESEncryption();
                        String s = new String("D4999F7E-FEC0-4c32-B86A-6506B6B1C375");
                        byte[] key = new byte[16];
                        for (int i = 0; i < key.length; i = (int)((byte)(i + 1))) {
                            key[i] = (byte)s.charAt(i);
                        }
                        try {
                            this.MCAESEncryptor.setKey(null, key);
                        }
                        catch (EMCError ex) {
                            // empty catch block
                        }
                        this.directTransport.setEncryptor(this.MCAESEncryptor);
                    }
                    switch (this.Sealing) {
                        case 1: {
                            this.MCAdlerSealer = new MCAdlerSealing();
                            this.directTransport.setSealer(this.MCAdlerSealer);
                            break block5;
                        }
                        case 2: {
                            this.MCCRC32Sealer = new MCCRC32Sealing();
                            this.directTransport.setSealer(this.MCCRC32Sealer);
                            break block5;
                        }
                        case 3: {
                            this.MCMD5Sealer = new MCMD5Sealing();
                            this.directTransport.setSealer(this.MCMD5Sealer);
                        }
                    }
                    break;
                }
                default: {
                    this.socketTransport = new MCSocketTransport();
                    this.socketTransport.setTransportMode((byte)2);
                    this.socketTransport.setMaxTimeout(5000L);
                    this.socketTransport.setInactivityTime(300000L);
                    this.socketTransport.setMessenger(this.messenger);
                    this.socketTransport.setAttemptsToConnect(3);
                    this.socketTransport.setFailOnInactive(true);
                    if (this.Compress) {
                        this.MCZlibCompressor = new MCZLibCompression();
                        this.MCZlibCompressor.setCompressionLevel(6);
                        this.socketTransport.setCompressor(this.MCZlibCompressor);
                    }
                    if (this.Encrypt) {
                        this.MCAESEncryptor = new MCAESEncryption();
                        String s = new String("D4999F7E-FEC0-4c32-B86A-6506B6B1C375");
                        byte[] key = new byte[16];
                        for (int i = 0; i < key.length; i = (int)((byte)(i + 1))) {
                            key[i] = (byte)s.charAt(i);
                        }
                        try {
                            this.MCAESEncryptor.setKey(null, key);
                        }
                        catch (EMCError eMCError) {
                            // empty catch block
                        }
                        this.socketTransport.setEncryptor(this.MCAESEncryptor);
                    }
                    switch (this.Sealing) {
                        case 1: {
                            this.MCAdlerSealer = new MCAdlerSealing();
                            this.socketTransport.setSealer(this.MCAdlerSealer);
                            break block5;
                        }
                        case 2: {
                            this.MCCRC32Sealer = new MCCRC32Sealing();
                            this.socketTransport.setSealer(this.MCCRC32Sealer);
                            break block5;
                        }
                        case 3: {
                            this.MCMD5Sealer = new MCMD5Sealing();
                            this.socketTransport.setSealer(this.MCMD5Sealer);
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void errorProc(Object userData, MCMessage message, int ErrorCode) {
        if (this.dispatchTimer == null) {
            return;
        }
        this.statusBar.setText("Error sending the message " + String.valueOf(message.getMsgCode()) + ". Error numer = " + String.valueOf(ErrorCode));
        this.synopticCanvas.setPaintInError(true);
        this.ResendLastMessage();
    }

    @Override
    public void timeoutProc(Object userData, MCMessage message) {
        if (this.dispatchTimer == null) {
            return;
        }
        this.statusBar.setText("Timeout sending the message " + String.valueOf(message.getMsgCode()));
        this.synopticCanvas.setPaintInError(true);
        this.ResendLastMessage();
    }

    public void PromptForPassword() {
        if (this.dialog == null) {
            this.dialog = new PasswordChooser();
        }
        this.dialog.setUser(new User("", null));
        boolean bTemp = this.bSendEventsEnabled;
        this.bSendEventsEnabled = false;
        if (this.dialog.showDialog(this, "Login")) {
            User u = this.dialog.getUser();
            MCMessage msg = new MCMessage();
            msg.setMsgCode(1001);
            msg.setParam1(7779);
            msg.setDataType((byte)1);
            String UserAndPassword = u.getName();
            UserAndPassword = UserAndPassword + "\t";
            char[] password = u.getPassword();
            for (int i = 0; i < password.length; ++i) {
                UserAndPassword = UserAndPassword + password[i];
            }
            UserAndPassword = UserAndPassword + "\t";
            UserAndPassword = UserAndPassword + String.valueOf(this.synopticCanvas.getWidth());
            UserAndPassword = UserAndPassword + "\t";
            UserAndPassword = UserAndPassword + String.valueOf(this.synopticCanvas.getHeight());
            UserAndPassword = UserAndPassword + "\t0\t";
            try {
                UserAndPassword = UserAndPassword + System.getProperty("user.language");
            }
            catch (Exception ex) {
                // empty catch block
            }
            UserAndPassword = UserAndPassword + "\t";
            try {
                UserAndPassword = UserAndPassword + String.valueOf(TimeZone.getDefault().getRawOffset() / 60000);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            UserAndPassword = UserAndPassword + "\t0";
            msg.setData(UserAndPassword.getBytes());
            this.dialog = null;
            this.doSendMessage(msg);
        } else {
            this.dialog = null;
        }
        this.bSendEventsEnabled = bTemp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifyProc(Object userData, MCMessage msg) {
        block43: {
            int i;
            StringBuffer sby;
            StringBuffer sbx;
            int size;
            byte[] data;
            block42: {
                this.nErrorCounter = 0;
                switch (msg.getMsgCode()) {
                    case 1001: {
                        if (msg.getResult() == 1) {
                            this.synopticCanvas.setPaintInError(false);
                            this.bConnected = true;
                            this.nToken = 0;
                            try {
                                if (msg.getData() == null) {
                                    this.PromptForPassword();
                                    return;
                                }
                                byte[] data2 = msg.getData();
                                String sTemp = new String(data2);
                                this.nToken = Integer.parseInt(sTemp);
                                this.bKeepPolling = true;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            if (!this.bKeepPolling) return;
                            this.RequestedScreen = this.SynopticName;
                            this.SendOpenScreen(this.RequestedScreen);
                            this.statusBar.setText("Requested Screen to the server");
                            return;
                        }
                        this.synopticCanvas.setPaintInError(true);
                        if (msg.getResult() == 100) {
                            JOptionPane.showMessageDialog(null, "No more licenses available on the server ! Please try later or contact you server administrator");
                        }
                        this.bConnected = false;
                        this.PromptForPassword();
                        return;
                    }
                    case 1022: {
                        if (msg.getResult() == 5) {
                            if (!this.bKeepPolling) return;
                            this.SendOpenScreen(this.RequestedScreen);
                            return;
                        }
                        if (msg.getResult() == 1) {
                            this.synopticCanvas.setPaintInError(false);
                            this.bEnablePollingOnImageObserver = true;
                            this.bKeepPolling = true;
                            this.bScreenChanged = true;
                            this.SendMonitorScreenData();
                            return;
                        }
                        this.synopticCanvas.setPaintInError(true);
                        boolean bTemp = this.bSendEventsEnabled;
                        this.bSendEventsEnabled = false;
                        int response = JOptionPane.showConfirmDialog(null, "Server could not find or open the Screen " + this.SynopticName + ". Retry ? ", "Error !", 0);
                        if (response == 0) {
                            this.bSendEventsEnabled = false;
                            this.RequestedScreen = JOptionPane.showInputDialog(null, "Please, Enter the Screen to open", this.RequestedScreen);
                            if (this.RequestedScreen != null) {
                                this.SendOpenScreen(this.RequestedScreen);
                            }
                        }
                        this.bSendEventsEnabled = bTemp;
                        return;
                    }
                    case 1031: {
                        if (msg.getResult() != 1) {
                            boolean bTemp = this.bSendEventsEnabled;
                            this.bSendEventsEnabled = false;
                            JOptionPane.showMessageDialog(null, "Server did not accept the value entered");
                            this.bSendEventsEnabled = bTemp;
                        }
                        if (!this.bKeepPolling) return;
                        this.SendMonitorScreenData();
                        return;
                    }
                    case 1023: {
                        switch (msg.getResult()) {
                            case 11: {
                                this.synopticCanvas.setPaintInError(false);
                                String sTemp = new String("");
                                if (msg.getData() != null) {
                                    byte[] data3 = msg.getData();
                                    int size2 = data3.length;
                                    sTemp = new String(data3);
                                }
                                boolean bTemp = this.bSendEventsEnabled;
                                this.bSendEventsEnabled = false;
                                String value = JOptionPane.showInputDialog(null, "Please, Enter the value for ", sTemp);
                                this.bSendEventsEnabled = bTemp;
                                if (value != null) {
                                    this.SendNumericEntry(value);
                                    return;
                                }
                                if (!this.bKeepPolling) return;
                                this.SendMonitorScreenData();
                                return;
                            }
                            case 10: {
                                this.synopticCanvas.setPaintInError(false);
                                if (msg.getData() != null) {
                                    byte[] data4 = msg.getData();
                                    int size3 = data4.length;
                                    String sTemp = new String(data4);
                                    boolean bTemp = this.bSendEventsEnabled;
                                    this.bSendEventsEnabled = false;
                                    JOptionPane.showMessageDialog(null, "Server Message : " + sTemp);
                                    this.bSendEventsEnabled = bTemp;
                                }
                                if (!this.bKeepPolling) return;
                                this.SendMonitorScreenData();
                                return;
                            }
                            case 12: {
                                this.synopticCanvas.setPaintInError(false);
                                if (msg.getData() != null) {
                                    byte[] data5 = msg.getData();
                                    int size4 = data5.length;
                                    String sTemp = new String(data5);
                                    this.statusBar.setText(sTemp);
                                }
                                if (!this.bKeepPolling) return;
                                this.SendMonitorScreenData();
                                return;
                            }
                            case 6: {
                                this.synopticCanvas.setPaintInError(false);
                                if (msg.getData() != null) {
                                    String sTemp;
                                    byte[] data6 = msg.getData();
                                    int size5 = data6.length;
                                    this.RequestedScreen = sTemp = new String(data6);
                                    this.SendOpenScreen(this.RequestedScreen);
                                    this.bEnablePollingOnImageObserver = false;
                                    this.statusBar.setText("Opening Screen " + sTemp);
                                    this.bScreenChanged = false;
                                    return;
                                }
                                if (!this.bKeepPolling) return;
                                this.SendMonitorScreenData();
                                return;
                            }
                            case 5: {
                                this.synopticCanvas.setPaintInError(false);
                                if (this.bKeepPolling) {
                                    this.SendMonitorScreenData();
                                }
                                if (!this.bScreenChanged) return;
                                this.statusBar.setText("Server is still processing...");
                                return;
                            }
                            case 1: {
                                this.synopticCanvas.setPaintInError(false);
                                try {
                                    if (msg.getData() != null) {
                                        data = msg.getData();
                                        size = data.length;
                                        sbx = new StringBuffer();
                                        sby = new StringBuffer();
                                        break block42;
                                    }
                                    if (this.bKeepPolling) {
                                        this.SendMonitorScreenData();
                                    }
                                    break block43;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    if (this.bKeepPolling) {
                                        this.SendMonitorScreenData();
                                    }
                                    break block43;
                                }
                            }
                            default: {
                                this.synopticCanvas.setPaintInError(true);
                                this.statusBar.setText("Server could not accept the Poll Screen command " + msg.getResult());
                                this.nErrorCounter = 4;
                                this.ResendLastMessage();
                                return;
                            }
                        }
                    }
                }
                return;
            }
            for (i = 0; i < size && (char)data[i] != ','; ++i) {
                sbx.append((char)data[i]);
            }
            ++i;
            while (i < size && (char)data[i] != '\t') {
                sby.append((char)data[i]);
                ++i;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(data, ++i, size - i);
            String sx = sbx.toString();
            String sy = sby.toString();
            try {
                this.nx = Integer.parseInt(sx);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            try {
                this.ny = Integer.parseInt(sy);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            Graphics g = this.synopticCanvas.ImageDoubleBuffer.getGraphics();
            g.drawImage(image, this.nx, this.ny, this);
            g.dispose();
        }
        if (this.bScreenChanged) {
            this.statusBar.setText("Ready");
            this.bScreenChanged = false;
        }
        this.bSendEventsEnabled = this.bKeepPolling;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            Graphics g = this.synopticCanvas.ImageDoubleBuffer.getGraphics();
            g.drawImage(img, this.nx, this.ny, null);
            g.dispose();
            this.synopticCanvas.repaint(this.nx, this.ny, width, height);
            if (this.bEnablePollingOnImageObserver) {
                this.SendMonitorScreenData();
            }
        }
        return true;
    }

    public String PrepareAddress() {
        StringBuffer sb = new StringBuffer();
        switch (this.Protocol) {
            case 1: {
                sb.append("HTTP:");
                sb.append(this.ServerName);
                sb.append(":");
                sb.append(String.valueOf(this.ServerPort));
                sb.append("|MSQ");
                break;
            }
            case 2: {
                sb.append("UDP:");
                sb.append(this.ServerName);
                sb.append(":");
                sb.append(String.valueOf(this.ServerPort));
                sb.append("|MSQ");
                break;
            }
            case 3: {
                sb.append("MMF:MOVICONMMF|MSQ");
                break;
            }
            default: {
                sb.append("SOCKET:");
                sb.append(this.ServerName);
                sb.append(":");
                sb.append(String.valueOf(this.ServerPort));
                sb.append("|MSQ");
            }
        }
        return sb.toString();
    }

    void connect() {
        String addr;
        if (this.httpTransport != null && !this.httpTransport.getActive()) {
            this.httpTransport.setActive(true);
        }
        if (this.udpTransport != null && !this.udpTransport.getActive()) {
            this.udpTransport.setActive(true);
        }
        if (this.directTransport != null && !this.directTransport.getActive()) {
            this.directTransport.setActive(true);
        }
        if (this.socketTransport != null && !this.socketTransport.getActive()) {
            this.socketTransport.setActive(true);
        }
        if (this.dispatchTimer == null) {
            this.dispatchTimer = new DispatchTask();
            this.dispatchTimer.start();
        }
        MCMessage msg = new MCMessage();
        System.out.println("ServerName is " + this.ServerName);
        if (this.ServerName.length() < 1 && !this.isStandalone) {
            URL url = this.getCodeBase();
            this.ServerName = url.getHost();
        }
        if (this.ServerName.length() < 1) {
            boolean bTemp = this.bSendEventsEnabled;
            this.bSendEventsEnabled = false;
            this.ServerName = JOptionPane.showInputDialog(null, (Object)"Please, Enter the Server Name");
            this.bSendEventsEnabled = bTemp;
            if (this.ServerName == null) {
                return;
            }
        }
        if ((addr = this.ServerName).length() < 1) {
            return;
        }
        msg.setMsgCode(1001);
        msg.setParam1(7779);
        msg.setDataType((byte)1);
        String UserAndPassword = this.CurrUserName;
        UserAndPassword = UserAndPassword + "\t";
        UserAndPassword = UserAndPassword + this.CurrPassword;
        UserAndPassword = UserAndPassword + "\t";
        UserAndPassword = UserAndPassword + String.valueOf(this.synopticCanvas.getWidth());
        UserAndPassword = UserAndPassword + "\t";
        UserAndPassword = UserAndPassword + String.valueOf(this.synopticCanvas.getHeight());
        UserAndPassword = UserAndPassword + "\t";
        UserAndPassword = UserAndPassword + String.valueOf(this.nNumColors);
        UserAndPassword = UserAndPassword + "\t";
        try {
            UserAndPassword = UserAndPassword + System.getProperty("user.language");
        }
        catch (Exception ex) {
            // empty catch block
        }
        UserAndPassword = UserAndPassword + "\t";
        try {
            Date now = new Date();
            long nowLong = now.getTime();
            UserAndPassword = UserAndPassword + String.valueOf(TimeZone.getDefault().getOffset(nowLong) / 60000);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        UserAndPassword = UserAndPassword + "\t0";
        msg.setData(UserAndPassword.getBytes());
        this.destAddr = this.PrepareAddress();
        this.doSendMessage(msg);
        this.statusBar.setText("Connecting to the server " + addr);
    }

    public void ResendLastMessage() {
        if (++this.nErrorCounter >= 3) {
            this.xdisconnect();
            this.connect();
            System.gc();
        } else {
            this.doSendMessage(this.lastMessageSent);
        }
    }

    public void doSendMessage(MCMessage msg) {
        msg.setParam2(this.nToken);
        try {
            msg.copy(this.lastMessageSent);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        try {
            this.messenger.sendMessageTimeoutCallback(this.destAddr, msg, this.Timeout, this, this, this, null, null);
        }
        catch (EMCError ex) {
            this.statusBar.setText("Cannot connect to the server " + this.destAddr + " : " + ex.getMessage());
            this.ResendLastMessage();
            return;
        }
    }

    public void SendMonitorVariableText(int nType) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(nType);
        msg.setDataType((byte)1);
        msg.setData(this.CurrVarName.getBytes());
        this.doSendMessage(msg);
    }

    public void SendFetchHisLogEntries(int nType, int nMaxEntries) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1012);
        msg.setParam1(nMaxEntries);
        msg.setDataType((byte)1);
        String sType = String.valueOf(nType);
        msg.setData(sType.getBytes());
        this.doSendMessage(msg);
    }

    public void SendFetchDLREntries(String DLR, int nMaxEntries) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1013);
        msg.setParam1(nMaxEntries);
        msg.setDataType((byte)1);
        msg.setData(DLR.getBytes());
        this.doSendMessage(msg);
    }

    public void SendFetchTraceDBEntries(String Variable, int nMaxEntries) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1014);
        msg.setParam1(nMaxEntries);
        msg.setDataType((byte)1);
        msg.setData(Variable.getBytes());
        this.doSendMessage(msg);
    }

    public void SendGetAlarmListEntries(int wFilter, String strAlarmArea, String strAlarmText) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1015);
        msg.setParam1(wFilter);
        msg.setDataType((byte)1);
        String data = strAlarmArea + "\t" + strAlarmText;
        msg.setData(data.getBytes());
        this.doSendMessage(msg);
    }

    public void SendPollAlarmListEntries(int nIndex, int nMaxCount) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1016);
        msg.setParam1(nIndex);
        msg.setDataType((byte)1);
        String data = String.valueOf(nMaxCount);
        msg.setData(data.getBytes());
        this.doSendMessage(msg);
    }

    public void SendSizeChanged(int nWidth, int nHeight) {
        if (!this.bConnected) {
            return;
        }
        String data = String.valueOf(nWidth);
        data = data + "\t";
        data = data + String.valueOf(nHeight);
        data = data + "\t0\t\t\t0";
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1029);
        msg.setData(data.getBytes());
        this.doSendMessage(msg);
    }

    public void SendOpenScreen(String Screen) {
        if (!this.bConnected) {
            return;
        }
        this.bSendEventsEnabled = false;
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1022);
        msg.setData(Screen.getBytes());
        this.doSendMessage(msg);
    }

    public void SendMonitorScreenData() {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1023);
        msg.setDataType((byte)1);
        this.doSendMessage(msg);
    }

    public void SendNumericEntry(String Value) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1031);
        msg.setData(Value.getBytes());
        this.doSendMessage(msg);
    }

    public void SendMouseMove(int nPos) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1024);
        msg.setParam1(nPos);
        this.doSendMessage(msg);
    }

    public void SendMouseDown(int nPos) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1025);
        msg.setParam1(nPos);
        this.doSendMessage(msg);
    }

    public void SendMouseUp(int nPos) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1026);
        msg.setParam1(nPos);
        this.doSendMessage(msg);
    }

    public void SendKeyDown(int nKey) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1027);
        msg.setParam1(nKey);
        this.doSendMessage(msg);
    }

    public void SendKeyUp(int nKey) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1028);
        msg.setParam1(nKey);
        this.doSendMessage(msg);
    }

    public void SendAckAlarmListEntries(int nIndex) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1018);
        msg.setParam1(nIndex);
        this.doSendMessage(msg);
    }

    public void SendResetAlarmListEntries(int nIndex) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1019);
        msg.setParam1(nIndex);
        this.doSendMessage(msg);
    }

    public void SendStopAlarmListEntries() {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1017);
        this.doSendMessage(msg);
    }

    public void SendGetVariableList(String str) {
        if (!this.bConnected) {
            return;
        }
        MCMessage msg = new MCMessage();
        msg.setMsgCode(1005);
        msg.setParam1(this.nMaxListSize);
        msg.setDataType((byte)1);
        if (str != null) {
            msg.setData(str.getBytes());
        }
        this.doSendMessage(msg);
    }

    void xdisconnect() {
        this.bKeepPolling = false;
        this.bSendEventsEnabled = false;
        if (this.bConnected) {
            MCMessage msg = new MCMessage();
            msg.setMsgCode(1007);
            msg.setParam2(this.nToken);
            try {
                IntegerHolder i = new IntegerHolder();
                this.messenger.sendMessageTimeout(this.destAddr, msg, this.Timeout, true, null, i);
            }
            catch (Exception ex) {
                this.statusBar.setText("Error " + ex.getMessage() + " Sending messages to " + this.destAddr);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bConnected = false;
        }
    }

    @Override
    public void start() {
        this.bKeepPolling = true;
        this.bEnablePollingOnImageObserver = false;
        this.connect();
        if (this.dispatchTimer == null) {
            this.dispatchTimer = new DispatchTask();
            this.dispatchTimer.start();
        }
        if (this.synopticCanvas != null) {
            this.synopticCanvas.requestFocus();
        }
    }

    @Override
    public void stop() {
        this.bKeepPolling = false;
        this.bEnablePollingOnImageObserver = false;
        this.xdisconnect();
        this.dispatchTimer = null;
    }

    @Override
    public void destroy() {
        this.xdisconnect();
        this.httpTransport = null;
        this.socketTransport = null;
        this.udpTransport = null;
        this.directTransport = null;
        this.messenger.destroy();
        this.messenger = null;
        this.interruptTimerThread = true;
        this.dispatchTimer = null;
    }

    @Override
    public String getAppletInfo() {
        return "Movicon Web Client X Applet";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"ServerName", "String", "ServerName url"}, {"ServerPort", "int", "Server Port"}, {"UserName", "String", "UserName"}, {"Password", "String", "Password"}, {"Protocol", "int", "Protocol"}, {"Compress", "boolean", "Compress"}, {"Encrypt", "boolean", "Encrypt"}, {"Sealing", "int", "Sealing"}, {"Timeout", "int", "Timeout"}, {"ShowMenu", "boolean", "ShowMenu"}, {"Synoptic", "String", "Synoptic"}, {"MouseMotion", "boolean", "MouseMotion"}, {"MouseClicks", "boolean", "MouseClicks"}, {"KeyEvents", "boolean", "KeyEvents"}, {"ShowStatusBar", "boolean", "ShowStatusBar"}, {"NumColors", "int", "NumColors"}};
        return pinfo;
    }

    public static void main(String[] args) {
        final Applet1 applet = new Applet1();
        applet.isStandalone = true;
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (applet != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            applet.bKeepPolling = false;
                            applet.bEnablePollingOnImageObserver = false;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            applet.stop();
                            applet.destroy();
                            System.exit(0);
                        }
                    });
                } else {
                    System.exit(0);
                }
            }
        });
        frame.setTitle("Web Client");
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        if (args.length > 0) {
            applet.ServerName = args[0];
        }
        if (args.length > 1) {
            applet.SynopticName = args[1];
        }
        int nWidth = 400;
        int nHeight = 320;
        if (args.length > 2) {
            nWidth = Integer.parseInt(args[2]);
        }
        if (args.length > 3) {
            nHeight = Integer.parseInt(args[3]);
        }
        frame.setSize(nWidth, nHeight);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
        applet.start();
    }

    class DispatchTask
    extends Thread {
        DispatchTask() {
        }

        @Override
        public void run() {
            do {
                try {
                    Applet1.this.messenger.dispatchMessages();
                    DispatchTask.sleep(Applet1.this.nDefPollTime);
                }
                catch (Exception e) {
                    break;
                }
            } while (!Applet1.this.interruptTimerThread);
        }
    }

    class User {
        private String name;
        private char[] password;

        public User(String aName, char[] aPassword) {
            this.name = aName;
            this.password = aPassword;
        }

        public String getName() {
            return this.name;
        }

        public char[] getPassword() {
            return this.password;
        }

        public void setName(String aName) {
            this.name = aName;
        }

        public void setPassword(char[] aPassword) {
            this.password = aPassword;
        }
    }

    class PasswordChooser
    extends JPanel {
        private JTextField username;
        private JPasswordField password;
        private boolean ok;
        private JDialog dialog;

        public PasswordChooser() {
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(2, 2));
            panel.add(new JLabel("User name :", 4));
            this.username = new JTextField("", 24);
            panel.add(this.username);
            panel.add(new JLabel("Password :", 4));
            this.password = new JPasswordField("", 24);
            panel.add(this.password);
            this.add((Component)panel, "Center");
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PasswordChooser.this.ok = true;
                    PasswordChooser.this.dialog.setVisible(false);
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PasswordChooser.this.dialog.setVisible(false);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            this.add((Component)buttonPanel, "South");
        }

        public void setUser(User u) {
            this.username.setText(u.getName());
        }

        public User getUser() {
            return new User(this.username.getText(), this.password.getPassword());
        }

        public boolean showDialog(Component parent, String title) {
            this.ok = false;
            Frame owner = null;
            owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
            if (this.dialog == null || this.dialog.getOwner() != owner) {
                owner = null;
                this.dialog = new JDialog(owner, true);
                this.dialog.getContentPane().add(this);
                this.dialog.pack();
            }
            this.dialog.setTitle(title);
            this.dialog.show();
            return this.ok;
        }
    }
}

