/*
 * Decompiled with CFR 0.152.
 */
package movwebclientx;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import movwebclientx.Applet1;

public class SynopticCanvas
extends JPanel
implements MouseListener,
KeyListener,
ComponentListener,
MouseMotionListener {
    private int xCursorPos;
    private int yCursorPos;
    private int nWidth = 0;
    private int nHeight = 0;
    private Applet1 instance;
    public Image ImageDoubleBuffer;
    private boolean bInError = true;

    public SynopticCanvas(Applet1 Instance) {
        this.instance = Instance;
        this.nWidth = this.getWidth();
        this.nHeight = this.getHeight();
        if (this.instance.MouseClicks) {
            this.addMouseListener(this);
        }
        if (this.instance.KeyEvents) {
            this.addKeyListener(this);
        }
        this.addComponentListener(this);
        if (this.instance.MouseMotion) {
            this.addMouseMotionListener(this);
        }
        if (this.nWidth > 0 && this.nHeight > 0) {
            this.ImageDoubleBuffer = this.createImage(this.nWidth, this.nHeight);
            Graphics g = this.ImageDoubleBuffer.getGraphics();
            g.drawString("Please, wait while the server sends the data...", 0, 0);
            g.dispose();
        }
    }

    public void setPaintInError(boolean bSet) {
        if (bSet ^ this.bInError) {
            this.bInError = bSet;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.ImageDoubleBuffer != null) {
            g.drawImage(this.ImageDoubleBuffer, 0, 0, this);
        } else {
            g.drawString("Please, wait while the server sends the data...", 0, 0);
        }
        if (this.bInError) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new Color(92, 92, 92, 128));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.instance.bSendEventsEnabled) {
            return;
        }
        int nPos = e.getX() | e.getY() << 16;
        if (!this.instance.MouseMotion) {
            this.instance.SendMouseMove(nPos);
        }
        this.instance.SendMouseDown(nPos);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.instance.bSendEventsEnabled) {
            return;
        }
        int nPos = e.getX() | e.getY() << 16;
        if (!this.instance.MouseMotion) {
            this.instance.SendMouseMove(nPos);
        }
        this.instance.SendMouseUp(nPos);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.instance.bSendEventsEnabled) {
            return;
        }
        this.instance.SendKeyDown(e.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.instance.bSendEventsEnabled) {
            return;
        }
        this.instance.SendKeyUp(e.getKeyCode());
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.nWidth = this.getWidth();
        this.nHeight = this.getHeight();
        this.ImageDoubleBuffer = null;
        if (this.nWidth > 0 && this.nHeight > 0) {
            this.ImageDoubleBuffer = this.createImage(this.nWidth, this.nHeight);
            Graphics g = this.ImageDoubleBuffer.getGraphics();
            g.drawString("Please, wait while the server sends the data...", 0, 0);
            g.dispose();
        }
        this.instance.SendSizeChanged(this.nWidth, this.nHeight);
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.instance.bSendEventsEnabled) {
            return;
        }
        int nPos = e.getX() | e.getY() << 16;
        this.instance.SendMouseMove(nPos);
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.instance.bSendEventsEnabled) {
            return;
        }
        int nPos = e.getX() | e.getY() << 16;
        this.instance.SendMouseMove(nPos);
    }
}

