/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

public class EMCError
extends Exception {
    public static final int WrongReceiverThread = 1;
    public static final int WrongSenderThread = 2;
    public static final int NoQueueName = 3;
    public static final int BadTransport = 4;
    public static final int BadDestinationName = 5;
    public static final int SecurityInitFailed = 6;
    public static final int GenTransportFailure = 8;
    public static final int NoDecryptor = 9;
    public static final int NoDecompressor = 10;
    public static final int NoSignatureHandler = 11;
    public static final int InvalidSignature = 12;
    public static final int TransportTimeout = 13;
    public static final int InvalidEncryptionKey = 14;
    public static final int NotEnoughMemory = 15;
    public static final int WrongCredentials = 16;
    public static final int MessageTimeExpired = 17;
    public static final int NoTransformer = 26;
    public static final int RoutingNotAllowed = 27;
    public static final int TransportInactive = 28;
    public static final int Cancelled = 50;
    public static final int Shutdown = 51;
    public static final int PacketTooLarge = 52;
    public static final int NotASocket = 201;
    public static final int WrongSocketState = 202;
    public static final int SockInitFailed = 203;
    public static final int InvalidAddress = 204;
    public static final int ConnectionFailed = 205;
    public static final int ConnectionLost = 206;
    public static final int WrongSocketResult = 207;
    public static final int WrongSocketType = 208;
    public static final int InvalidHTTP = 301;
    public static final int SocksNoAcceptableAuthMethods = 501;
    public static final int SocksAuthFailure = 502;
    public static final int SocksGenFailure = 503;
    public static final int SocksNotAllowed = 504;
    public static final int SocksNetUnreachable = 505;
    public static final int SocksHostUnreachable = 506;
    public static final int SocksConnectionRefused = 507;
    public static final int SocksTTLExpired = 508;
    public static final int SocksCmdNotSupported = 509;
    public static final int SocksAddrTypeNotSupported = 510;
    public static final int WebTunnelConnectionFailed = 550;
    public static final int WebTunnelAuthRequired = 551;
    public static final int WebTunnelFailure = 552;
    protected int errorCode = -1;

    public EMCError(int errorCode) {
        super(EMCError.getMessageFromErrorCode(errorCode));
        this.errorCode = errorCode;
    }

    public EMCError(String errorMsg) {
        super(errorMsg);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    protected static String getMessageFromErrorCode(int errorCode) {
        String result = null;
        switch (errorCode) {
            case 4: {
                result = "No suitable transport found.";
                break;
            }
            case 28: {
                result = "Transport is inactive";
                break;
            }
            case 5: {
                result = "Bad destination address format";
                break;
            }
            case 2: {
                result = "Use destination messenger''s thread context.";
                break;
            }
            case 1: {
                result = "This method should be called within Messenger creator thread.";
                break;
            }
            case 3: {
                result = "Messenger Queue name must be specified.";
                break;
            }
            case 6: {
                result = "Security descriptor initialization failed.";
                break;
            }
            case 14: {
                result = "Invalid key specified for encryption component.";
                break;
            }
            case 15: {
                result = "Not enough memory to perform operation.";
                break;
            }
            case 9: {
                result = "Decryptor is not found";
                break;
            }
            case 10: {
                result = "Decompressor is not found";
                break;
            }
            case 16: {
                result = "Sender presented invalid credentials.";
                break;
            }
            case 12: {
                result = "Invalid signature in data stream";
                break;
            }
            case 8: {
                result = "Transport failure due to unexpected error";
                break;
            }
            case 13: {
                result = "Transport timeout.";
                break;
            }
            case 201: {
                result = "Operation called on invalid socket.";
                break;
            }
            case 202: {
                result = "Socket is in state that is not acceptable for current operation.";
                break;
            }
            case 203: {
                result = "Failed to initialize socket.";
                break;
            }
            case 204: {
                result = "Invalid address specified.";
                break;
            }
            case 205: {
                result = "Connection failed.";
                break;
            }
            case 206: {
                result = "Connection to remote host was lost.";
                break;
            }
            case 208: {
                result = "Wrong socket type.";
                break;
            }
            default: {
                result = "Unspecified error - " + errorCode;
            }
        }
        return result;
    }
}

