/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCBaseCompression;
import org.eldos.MsgConnect.MCBase.MCBaseEncryption;
import org.eldos.MsgConnect.MCBase.MCBaseSealing;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCBase.MCMessenger;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMutex;

public abstract class MCBaseTransport
extends Beans
implements Serializable {
    protected String defaultTransportName = null;
    private String name = null;
    private boolean active = true;
    private MCBaseCompression compressor = null;
    private MCBaseEncryption encryptor = null;
    private MCBaseSealing sealer = null;
    protected MCMessenger messenger = null;
    protected long messageExpiresAfter = 100000L;
    protected MCMutex criticalSection = new MCMutex();
    protected boolean ignoreIncomingPriorities = false;
    protected boolean discardUnsentMessages = false;
    protected MCMutex linkCriticalSection = new MCMutex();
    private int maxMsgSize = Integer.MAX_VALUE;
    private long maxTimeout = Long.MAX_VALUE;
    private long msgTimeout = Long.MAX_VALUE;

    public boolean equals(Object o) {
        return this == o;
    }

    public MCMessenger getMessenger() {
        return this.messenger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessenger(MCMessenger messenger) {
        if (this.messenger != messenger) {
            boolean b = this.getActive();
            this.setActive(false);
            this.linkCriticalSection.enter();
            try {
                if (this.messenger != null) {
                    this.messenger.removeTransport(this);
                }
                this.messenger = messenger;
                if (messenger != null) {
                    messenger.addTransport(this);
                }
            }
            finally {
                this.linkCriticalSection.leave();
            }
            this.setActive(b);
        }
    }

    public MCMutex getLinkCriticalSection() {
        return this.linkCriticalSection;
    }

    public String getName() {
        if (this.name == null) {
            return this.defaultTransportName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? this.defaultTransportName : name;
    }

    public MCBaseCompression getCompressor() {
        return this.compressor;
    }

    public void setCompressor(MCBaseCompression compressor) {
        if (this.compressor != compressor) {
            this.linkCriticalSection.enter();
            this.compressor = compressor;
            this.linkCriticalSection.leave();
        }
    }

    public MCBaseEncryption getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(MCBaseEncryption encryptor) {
        if (this.encryptor != encryptor) {
            this.linkCriticalSection.enter();
            this.encryptor = encryptor;
            this.linkCriticalSection.leave();
        }
    }

    public MCBaseSealing getSealer() {
        return this.sealer;
    }

    public void setSealer(MCBaseSealing sealer) {
        if (this.sealer != sealer) {
            this.linkCriticalSection.enter();
            this.sealer = sealer;
            this.linkCriticalSection.leave();
        }
    }

    protected boolean addressValid(String address) {
        String s = null;
        s = this.getName() == null ? this.defaultTransportName : this.getName();
        return address.regionMatches(true, 0, s + ":", 0, s.length() + 1);
    }

    protected abstract void cancelMessage(List var1, MCMessageInfo var2);

    protected abstract boolean deliverMessage(String var1, MCMessageInfo var2) throws EMCError;

    protected void doSetActive() throws Exception {
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.getMessenger() != null) {
            try {
                this.doSetActive();
            }
            catch (Exception e) {
                MCGlobals.DEBUG_STACKTRACE(e);
                this.active = false;
                throw new RuntimeException();
            }
        }
    }

    public void setMaxMsgSize(int size) {
        this.maxMsgSize = size;
    }

    public int getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public void setMaxTimeout(long timeout) {
        this.maxTimeout = timeout;
    }

    public long getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMsgTimeout(long timeout) {
        this.msgTimeout = timeout;
    }

    public long getMsgTimeout() {
        return this.msgTimeout;
    }

    public void setIgnoreIncomingPriorities(boolean value) {
        this.ignoreIncomingPriorities = value;
    }

    public boolean getIgnoreIncomingPriorities() {
        return this.ignoreIncomingPriorities;
    }

    public boolean getDiscardUnsentMessages() {
        return this.discardUnsentMessages;
    }

    public void shutdown(boolean discardUnsentMessages) {
        if (this.getActive()) {
            this.discardUnsentMessages = discardUnsentMessages;
            this.setActive(false);
            this.discardUnsentMessages = false;
        } else if (discardUnsentMessages) {
            this.cleanOutgoingQueue();
        }
    }

    protected abstract void messageProcessed(MCMessageInfo var1) throws Exception;

    public synchronized void routeMessage(MCMessageInfo Info) throws EMCError {
        if (this.getMessenger() != null) {
            String S = Info.getRouteTo();
            Info.setRouteTo("");
            this.getMessenger().doSendMessage(S + "|" + Info.getDQueue(), Info);
        }
    }

    public void prepareDataBlock(String remote, MCMessageDataHolder data) {
        boolean b = false;
        this.linkCriticalSection.enter();
        if (data.getCompressID() > 0) {
            if (this.compressor != null && this.compressor.getID() == data.getCompressID()) {
                b = this.compressor.compress(remote, data);
                if (!b) {
                    data.setCompressID(0);
                }
            } else {
                data.setCompressID(0);
            }
        } else {
            data.setCompressID(0);
        }
        if (data.getSealID() > 0) {
            if (this.sealer != null && this.sealer.getID() == data.getSealID()) {
                b = this.sealer.seal(remote, data);
                if (!b) {
                    data.setSealID(0);
                }
            } else {
                data.setSealID(0);
            }
        } else {
            data.setSealID(0);
        }
        if (data.getEncryptID() > 0) {
            if (this.encryptor != null && this.encryptor.getID() == data.getEncryptID()) {
                b = this.encryptor.encrypt(remote, data);
                if (!b) {
                    data.setEncryptID(0);
                }
            } else {
                data.setEncryptID(0);
            }
        } else {
            data.setEncryptID(0);
        }
        this.linkCriticalSection.leave();
    }

    public boolean unprepareDataBlock(String remote, MCMessageDataHolder data) {
        boolean b = true;
        this.linkCriticalSection.enter();
        if (data.getEncryptID() != 0 && this.encryptor != null && this.encryptor.getID() == data.getEncryptID()) {
            b = this.encryptor.decrypt(remote, data);
        }
        if (b && data.getSealID() != 0 && this.sealer != null && this.sealer.getID() == data.getSealID()) {
            b = this.sealer.unseal(remote, data);
        }
        if (b && data.getCompressID() != 0 && this.compressor != null && this.compressor.getID() == data.getCompressID()) {
            b = this.compressor.decompress(remote, data);
        }
        this.linkCriticalSection.leave();
        return b;
    }

    protected abstract void cleanOutgoingQueue();

    protected abstract void cleanupMessages();

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    protected boolean cancelMessageByID(long MsgID) {
        return this.cancelMessageByID(MsgID, 50, false);
    }

    protected boolean cancelMessageByID(long MsgID, boolean Discard) {
        return this.cancelMessageByID(MsgID, 50, Discard);
    }

    protected boolean cancelMessageByID(long MsgID, int ErrorCode) {
        return this.cancelMessageByID(MsgID, ErrorCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelMessageByID(long MsgID, int ErrorCode, boolean Discard) {
        boolean res;
        block10: {
            res = false;
            this.criticalSection.enter();
            try {
                MCMessageInfo Info = this.getMessageByID(MsgID);
                if (Info == null) break block10;
                this.cancelMessage(null, Info);
                Info.setState((byte)5);
                Info.setMCError(ErrorCode);
                res = true;
                if (Discard || this.getMessenger() == null) break block10;
                this.linkCriticalSection.enter();
                try {
                    if (this.messenger == null) break block10;
                    this.messenger.completeCriticalSection.enter();
                    try {
                        this.messenger.completeQueue.add(Info);
                        this.messenger.completeEvent.signal();
                        if (Info.getReplyFlag() != null) {
                            Info.getReplyFlag().signal();
                        }
                    }
                    finally {
                        this.messenger.completeCriticalSection.leave();
                    }
                }
                finally {
                    this.linkCriticalSection.leave();
                }
            }
            finally {
                this.criticalSection.leave();
            }
        }
        return res;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    protected String getMessageSource(MCMessageInfo info) {
        StringBuffer s = new StringBuffer();
        if (this.getName() == null) {
            s.append(this.defaultTransportName);
        } else {
            s.append(this.getName());
        }
        try {
            s.append(':');
            s.append(info.getSMessenger());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    public abstract int getOutgoingMessagesCount();

    public static final void insertInfoIntoQueueWithPriorities(Vector Queue, MCMessageInfo Info, boolean IgnoreMode) {
        int Cnt = Queue.size();
        for (int j = Cnt - 1; j >= -1; --j) {
            if (j == -1) {
                Queue.insertElementAt(Info, 0);
                continue;
            }
            MCMessageInfo TmpInfo = (MCMessageInfo)Queue.elementAt(j);
            if (TmpInfo == null || (!TmpInfo.isSendMsg() || Info.isSendMsg()) && (TmpInfo.isSendMsg() != Info.isSendMsg() || !IgnoreMode && TmpInfo.getMessage().getPriority() < Info.getMessage().getPriority())) continue;
            Queue.insertElementAt(Info, j + 1);
            break;
        }
    }

    public String realTransportName() {
        if (this.name.length() > 0) {
            return this.name;
        }
        return this.defaultTransportName;
    }

    protected MCMessageInfo getMessageByID(long MsgID) {
        return null;
    }

    public void destroy() {
        this.setActive(false);
    }

    public void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public void enterCriticalSection() {
        this.criticalSection.enter();
    }

    public void leaveCriticalSection() {
        this.criticalSection.leave();
    }
}

