/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.util.List;
import java.util.Vector;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCBaseTransport;
import org.eldos.MsgConnect.MCBase.MCMessage;
import org.eldos.MsgConnect.MCBase.MCMessageCredentials;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCMutex;

public class MCDirectTransport
extends MCBaseTransport {
    private static Vector directTransports = new Vector();
    private static MCMutex directTransportCS = new MCMutex();
    protected String FTransportID;
    protected Vector outgoingQueue;

    public MCDirectTransport() {
        this.defaultTransportName = "LOCAL";
        this.FTransportID = Long.toString(MCMessage.getUniqueID());
        this.outgoingQueue = new Vector();
    }

    @Override
    protected void doSetActive() throws Exception {
        super.doSetActive();
        if (this.getActive()) {
            directTransportCS.enter();
            directTransports.addElement(this);
            directTransportCS.leave();
        } else {
            directTransportCS.enter();
            directTransports.removeElement(this);
            directTransportCS.leave();
            this.criticalSection.enter();
            while (this.outgoingQueue.size() > 0) {
                this.cancelMessageByID(((MCMessageInfo)this.outgoingQueue.elementAt(0)).getMessage().getMsgID(), 51);
            }
            this.criticalSection.leave();
        }
    }

    @Override
    public void finalize() throws Throwable {
        this.setActive(false);
        super.finalize();
    }

    public static MCDirectTransport findTransportByID(String ID) {
        MCDirectTransport result = null;
        directTransportCS.enter();
        for (int i = 0; i < directTransports.size(); ++i) {
            String lID = ((MCDirectTransport)directTransports.elementAt(i)).getTransportID();
            if (lID.compareTo(ID) != 0) continue;
            result = (MCDirectTransport)directTransports.elementAt(i);
            break;
        }
        directTransportCS.leave();
        return result;
    }

    public String getTransportID() {
        return this.FTransportID;
    }

    @Override
    protected void cancelMessage(List Queue, MCMessageInfo info) {
        this.criticalSection.enter();
        this.outgoingQueue.removeElement(info);
        this.criticalSection.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void cleanOutgoingQueue() {
        this.criticalSection.enter();
        try {
            while (this.outgoingQueue.size() > 0) {
                this.cancelMessageByID(((MCMessageInfo)this.outgoingQueue.elementAt(0)).getMessage().getMsgID(), 51);
            }
        }
        finally {
            this.criticalSection.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanupMessages() {
        int i = 0;
        int TC = (int)System.currentTimeMillis();
        this.criticalSection.enter();
        while (i < this.outgoingQueue.size()) {
            boolean me;
            MCMessageInfo info = (MCMessageInfo)this.outgoingQueue.elementAt(i);
            if (info.getTimeout() == 0) {
                ++i;
                continue;
            }
            boolean bl = me = (long)TC - info.getStartTime() >= (long)info.getTimeout();
            if (me) {
                this.cancelMessage(null, info);
                info.setState((byte)8);
                if (this.getMessenger() == null) continue;
                this.linkCriticalSection.enter();
                try {
                    if (this.messenger == null) continue;
                    this.messenger.completeCriticalSection.enter();
                    this.messenger.completeQueue.add(info);
                    this.messenger.completeEvent.signal();
                    if (info.getReplyFlag() != null) {
                        info.getReplyFlag().signal();
                    }
                    this.messenger.completeCriticalSection.leave();
                    continue;
                }
                finally {
                    this.linkCriticalSection.leave();
                    continue;
                }
            }
            ++i;
        }
        this.criticalSection.leave();
    }

    @Override
    protected MCMessageInfo getMessageByID(long MsgID) {
        MCMessageInfo res = null;
        this.criticalSection.enter();
        for (int i = 0; i < this.outgoingQueue.size(); ++i) {
            MCMessageInfo Info = (MCMessageInfo)this.outgoingQueue.elementAt(i);
            if (Info.getMessage().getMsgID() != MsgID) continue;
            res = Info;
            break;
        }
        this.criticalSection.leave();
        return res;
    }

    @Override
    protected boolean deliverMessage(String destAddress, MCMessageInfo info) throws EMCError {
        MCMessageInfo NewInfo = null;
        String dm = this.FTransportID.toString();
        MCDirectTransport destTransport = null;
        if (destAddress.length() > 0 && this.addressValid(destAddress)) {
            info.setState((byte)2);
            int sp = destAddress.indexOf(124);
            if (sp >= 0) {
                dm = destAddress.substring(destAddress.indexOf(58) + 1, sp);
                destTransport = MCDirectTransport.findTransportByID(dm);
                if (destTransport == null) {
                    throw new EMCError(5);
                }
            } else {
                destTransport = this;
            }
            long saveID = info.getMessage().getMsgID();
            NewInfo = new MCMessageInfo();
            NewInfo.setMessage(info.getMessage());
            info.getMessage().setMsgID(saveID);
            info.setTransport(this);
            NewInfo.setOrigID(info.getOrigID());
            NewInfo.setDMessenger(dm);
            NewInfo.setDQueue(destAddress.substring(sp + 1, destAddress.length()));
            NewInfo.setSMessenger(new String(this.FTransportID));
            NewInfo.setSendMsg(info.isSendMsg());
            if (info.getCredentials() != null) {
                NewInfo.setCredentials((MCMessageCredentials)info.getCredentials().clone());
            }
            if (info.isSendMsg()) {
                this.criticalSection.enter();
                this.outgoingQueue.addElement(info);
                destTransport.messageReceived(NewInfo);
                this.criticalSection.leave();
            } else {
                info = null;
                destTransport.messageReceived(NewInfo);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived(MCMessageInfo info) {
        info.setTransport(this);
        info.setState((byte)2);
        this.messenger.incomingCriticalSection.enter();
        try {
            MCDirectTransport.insertInfoIntoQueueWithPriorities(this.messenger.incomingQueue, info, false);
            this.messenger.incomingEvent.signal();
        }
        finally {
            this.messenger.incomingCriticalSection.leave();
        }
    }

    protected void doMessageProcessed(MCMessageInfo info) {
        this.messenger.incomingCriticalSection.enter();
        this.messenger.completeQueue.addElement(info);
        this.messenger.completeEvent.signal();
        if (info.getReplyFlag() != null) {
            info.getReplyFlag().signal();
        }
        this.messenger.incomingCriticalSection.leave();
    }

    @Override
    protected void messageProcessed(MCMessageInfo info) {
        MCDirectTransport DestTransport = MCDirectTransport.findTransportByID(info.getSMessenger());
        if (DestTransport != null) {
            DestTransport.replyReceived(info);
            info = null;
        }
    }

    protected void replyReceived(MCMessageInfo info) {
        MCMessageInfo CurInfo = null;
        this.criticalSection.enter();
        for (int i = 0; i < this.outgoingQueue.size(); ++i) {
            if (((MCMessageInfo)this.outgoingQueue.elementAt(i)).getOrigID() != info.getOrigID()) continue;
            CurInfo = (MCMessageInfo)this.outgoingQueue.elementAt(i);
            this.outgoingQueue.removeElementAt(i);
            break;
        }
        this.criticalSection.leave();
        if (CurInfo != null) {
            CurInfo.setMessage(info.getMessage());
            info.getMessage().setData(null);
            CurInfo.setMCError(info.getMCError());
            CurInfo.setState(info.getState());
            this.doMessageProcessed(CurInfo);
        }
    }

    @Override
    public int getOutgoingMessagesCount() {
        return this.outgoingQueue.size();
    }
}

