/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.io.IOException;
import java.io.Serializable;
import org.eldos.MsgConnect.MCBase.UnknownDataTypeException;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCStream;

public class MCMessage
implements Serializable,
Cloneable {
    public static final byte itcNormal = 0;
    public static final byte itcTransactionPart = 1;
    public static final byte itcTransactionStart = 2;
    public static final byte itcTransactionCommit = 3;
    public static final byte itcTransactionRollback = 4;
    public static final byte bdtConst = 0;
    public static final byte bdtVar = 1;
    private static int uniqueLong = 1;
    private long msgID = MCMessage.getUniqueID();
    private int msgCode = 0;
    private byte transactCmd = 0;
    private short transactID = 0;
    private byte priority = 0;
    private int result = 0;
    private int param1 = 0;
    private int param2 = 0;
    private byte dataType = 0;
    private byte[] data = null;

    public void writeToStream(MCStream outStream) throws IOException {
        outStream.writeLong(this.msgID);
        outStream.write(this.msgCode);
        outStream.write(this.result);
        outStream.write(this.param1);
        outStream.write(this.param2);
        outStream.write((int)this.dataType);
        if (this.data == null) {
            outStream.write(0);
        } else {
            outStream.write(this.data.length);
            outStream.write(this.data, 0, this.data.length);
        }
    }

    public static void writeNullToStream(MCStream outStream) throws IOException {
        byte[] b = new byte[32];
        outStream.write(b, 0, b.length);
    }

    public int readFromStream(MCStream inStream, int maxDataSize) {
        int dataSize = 0;
        try {
            this.msgID = inStream.readLong();
            this.msgCode = inStream.readInt();
            this.result = inStream.readInt();
            this.param1 = inStream.readInt();
            this.param2 = inStream.readInt();
            this.dataType = (byte)inStream.readInt();
            dataSize = inStream.readInt();
        }
        catch (IOException e) {
            return 2;
        }
        try {
            if (dataSize == 0) {
                this.data = null;
                return 0;
            }
            if (dataSize > maxDataSize || dataSize < 0) {
                return 1;
            }
            this.data = new byte[dataSize];
            int wasRead = inStream.read(this.data, 0, dataSize);
            if (wasRead < dataSize) {
                MCGlobals.DEBUG_PRINTLN("Message's data wasn't read.");
            }
        }
        catch (IOException e) {
            return 1;
        }
        return 0;
    }

    public Object clone() {
        MCMessage cl = null;
        try {
            cl = (MCMessage)super.clone();
            if (this.data != null) {
                cl.data = new byte[this.data.length];
                System.arraycopy(this.data, 0, cl.data, 0, this.data.length);
            }
            return cl;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getDataSize() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public static int getUniqueID() {
        return uniqueLong++;
    }

    public void setDataType(byte dataType) throws UnknownDataTypeException {
        if (dataType != 0 && dataType != 1) {
            throw new UnknownDataTypeException();
        }
        this.dataType = dataType;
    }

    public byte getDataType() {
        return this.dataType;
    }

    public void setUniqMsgID() {
        this.msgID = MCMessage.getUniqueID();
    }

    public void setMsgID(long msgID) {
        this.msgID = msgID;
    }

    public long getMsgID() {
        return this.msgID;
    }

    public void setMsgCode(int msgCode) {
        this.msgCode = msgCode;
    }

    public int getMsgCode() {
        return this.msgCode;
    }

    public void setTransactCmd(byte transactCmd) {
        this.transactCmd = transactCmd;
    }

    public byte getTransactCmd() {
        return this.transactCmd;
    }

    public void setTransactID(short transactID) {
        this.transactID = transactID;
    }

    public short getTransactID() {
        return this.transactID;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public int getResult() {
        return this.result;
    }

    public void setParam1(int param) {
        this.param1 = param;
    }

    public int getParam1() {
        return this.param1;
    }

    public void setParam2(int param) {
        this.param2 = param;
    }

    public int getParam2() {
        return this.param2;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public void copy(MCMessage dest) {
        dest.setMsgID(this.msgID);
        dest.setMsgCode(this.msgCode);
        dest.setTransactCmd(this.transactCmd);
        dest.setTransactID(this.transactID);
        dest.setPriority(this.priority);
        dest.setResult(this.result);
        dest.setParam1(this.param1);
        dest.setParam2(this.param2);
        dest.setDataType(this.dataType);
        dest.setData(this.data);
    }
}

