/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.io.IOException;
import java.io.Serializable;
import org.eldos.MsgConnect.MCStream;

public class MCMessageCredentials
implements Serializable,
Cloneable {
    private String userName = null;
    private String password = null;

    public MCMessageCredentials(String userName, String password) throws NullPointerException {
        this.setUserName(userName);
        this.setPassword(password);
    }

    public static void writeNullToStream(MCStream outStream) throws IOException {
        byte[] b = new byte[32];
        outStream.write(b, 0, b.length);
    }

    public void writeToStream(MCStream outStream) throws IOException {
        int i;
        byte[] buf = new byte[16];
        byte[] b = this.userName.getBytes();
        for (i = 0; i < b.length && i <= 15; ++i) {
            buf[i] = b[i];
        }
        outStream.write(buf, 0, 16);
        b = this.password.getBytes();
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        for (i = 0; i < b.length && i <= 15; ++i) {
            buf[i] = b[i];
        }
        outStream.write(buf, 0, 16);
    }

    public void readFromStream(MCStream inStream) throws IOException {
        byte[] buf = new byte[16];
        inStream.read(buf, 0, 16);
        int i = 0;
        while (buf[i] != 0) {
            ++i;
        }
        this.userName = new String(buf, 0, i--);
        inStream.read(buf, 0, 16);
        i = 0;
        while (buf[i] != 0) {
            ++i;
        }
        this.password = new String(buf, 0, i--);
    }

    public void setUserName(String userName) throws NullPointerException {
        if (userName == null) {
            userName = "";
        }
        if (userName.length() > 15) {
            throw new ArrayIndexOutOfBoundsException("Too big user name.");
        }
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) throws NullPointerException {
        if (password == null) {
            password = "";
        }
        if (password.length() > 15) {
            throw new ArrayIndexOutOfBoundsException("Too big password.");
        }
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public Object clone() {
        MCMessageCredentials cred = null;
        try {
            cred = (MCMessageCredentials)super.clone();
            cred.setUserName(this.userName);
            cred.setPassword(this.password);
            return cred;
        }
        catch (Exception e) {
            return null;
        }
    }
}

