/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.io.IOException;
import java.io.Serializable;
import org.eldos.MsgConnect.MCBase.MCBaseTransport;
import org.eldos.MsgConnect.MCBase.MCErrorProc;
import org.eldos.MsgConnect.MCBase.MCMessage;
import org.eldos.MsgConnect.MCBase.MCMessageCredentials;
import org.eldos.MsgConnect.MCBase.MCNotifyProc;
import org.eldos.MsgConnect.MCBase.MCTimeoutProc;
import org.eldos.MsgConnect.MCBase.UnknownDataTypeException;
import org.eldos.MsgConnect.MCEvent;
import org.eldos.MsgConnect.MCStream;
import org.eldos.MsgConnect.TDateTime;

public class MCMessageInfo
implements Serializable,
Cloneable {
    public static final byte imsQueued = 0;
    public static final byte imsDispatching = 1;
    public static final byte imsWaiting = 2;
    public static final byte imsProcessing = 3;
    public static final byte imsComplete = 4;
    public static final byte imsFailed = 5;
    public static final byte imsEmptyRequest = 6;
    public static final byte imsEmptyReply = 7;
    public static final byte imsExpired = 8;
    public static final byte imsNone = 9;
    private TDateTime time = null;
    private long origID = 0L;
    private boolean isSendMsg = false;
    private String dQueue = null;
    private MCMessageCredentials credentials = null;
    private int mcError = 0;
    private byte state = (byte)5;
    private MCMessage message = null;
    private MCEvent replyFlag = null;
    private MCBaseTransport transport = null;
    private Object userData = null;
    private MCNotifyProc notifyProc = null;
    private MCTimeoutProc timeoutProc = null;
    private MCErrorProc errorProc = null;
    private String sMessenger = null;
    private String dMessenger = null;
    private String urlPart = null;
    private long startTime = 0L;
    private int timeout = 0;
    private Object track = null;
    private boolean sent = false;
    private byte oldState = (byte)9;
    private long connID = 0L;
    private long clientID = 0L;
    private byte transactCmd = 0;
    private int transactID = 0;
    private String recvPath = "";
    private String routeTo = "";
    private boolean intermed = false;
    private byte[] encodedMsg = null;
    private int encodedLen = 0;
    private int encryptID = 0;
    private int compressID = 0;
    private int sealID = 0;

    public MCMessageInfo() {
        this.time = new TDateTime();
    }

    public void writeToStream(MCStream outStream) throws IOException {
        outStream.writeDouble(this.time.getDateTimeVal());
        outStream.writeLong(this.origID);
        outStream.write(this.isSendMsg ? -1 : 0);
        byte[] buf = new byte[32];
        if (this.dQueue != null) {
            byte[] b = this.dQueue.getBytes();
            for (int i = 0; i < b.length && i <= 31; ++i) {
                buf[i] = b[i];
            }
        }
        outStream.write(buf, 0, 32);
        if (this.credentials != null) {
            this.credentials.writeToStream(outStream);
        } else {
            MCMessageCredentials.writeNullToStream(outStream);
        }
        outStream.write(this.getMCError());
        outStream.write((int)this.getState());
        if (null != this.message) {
            outStream.write(this.message.getTransactCmd());
            outStream.write(this.message.getTransactID());
            outStream.write(this.message.getPriority());
        } else {
            outStream.write((byte)0);
            outStream.write((short)0);
            outStream.write((byte)0);
        }
        if (this.message == null) {
            MCMessage.writeNullToStream(outStream);
        } else {
            this.message.writeToStream(outStream);
        }
    }

    public int readFromStream(MCStream inStream, int maxDataSize) {
        try {
            int i;
            this.time.setDateTimeVal(inStream.readDouble());
            this.origID = inStream.readLong();
            this.isSendMsg = inStream.readInt() != 0;
            byte[] buf = new byte[32];
            inStream.read(buf, 0, 32);
            for (i = 0; i < buf.length && buf[i] != 0; ++i) {
            }
            this.dQueue = new String(buf, 0, i);
            this.credentials = new MCMessageCredentials(null, null);
            this.credentials.readFromStream(inStream);
            this.setMCError(inStream.readInt());
            this.setState((byte)inStream.readInt());
            this.message.setTransactCmd(inStream.readByte());
            this.message.setTransactID(inStream.readShort());
            this.message.setPriority(inStream.readByte());
        }
        catch (IOException e) {
            return 2;
        }
        return this.message.readFromStream(inStream, maxDataSize);
    }

    public void setMessage(MCMessage message) {
        this.message = (MCMessage)message.clone();
    }

    public MCMessage getMessage() {
        return this.message;
    }

    public void setMsgID() {
        this.message.setUniqMsgID();
    }

    public void setState(byte state) throws UnknownDataTypeException {
        this.state = state;
    }

    public byte getState() {
        return this.state;
    }

    public MCEvent getReplyFlag() {
        return this.replyFlag;
    }

    public void setReplyFlag(MCEvent flag) {
        this.replyFlag = flag;
    }

    public MCNotifyProc getNotifyProc() {
        return this.notifyProc;
    }

    public void setNotifyProc(MCNotifyProc proc) {
        this.notifyProc = proc;
    }

    public MCTimeoutProc getTimeoutProc() {
        return this.timeoutProc;
    }

    public void setTimeoutProc(MCTimeoutProc proc) {
        this.timeoutProc = proc;
    }

    public MCErrorProc getErrorProc() {
        return this.errorProc;
    }

    public void setErrorProc(MCErrorProc proc) {
        this.errorProc = proc;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public MCMessageCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(MCMessageCredentials cred) {
        this.credentials = cred;
    }

    public boolean isSendMsg() {
        return this.isSendMsg;
    }

    public void setSendMsg(boolean b) {
        this.isSendMsg = b;
    }

    public void setTransport(MCBaseTransport transport) {
        this.transport = transport;
    }

    public MCBaseTransport getTransport() {
        return this.transport;
    }

    public void setDQueue(String str) {
        this.dQueue = str;
    }

    public String getDQueue() {
        return this.dQueue;
    }

    public void setMCError(int err) {
        this.mcError = err;
    }

    public int getMCError() {
        return this.mcError;
    }

    public long getOrigID() {
        return this.origID;
    }

    public void setOrigID(long origID) {
        this.origID = origID;
    }

    public String getSMessenger() {
        return this.sMessenger;
    }

    public void setSMessenger(String s) {
        this.sMessenger = s;
    }

    public String getDMessenger() {
        return this.dMessenger;
    }

    public void setDMessenger(String s) {
        this.dMessenger = s;
    }

    public TDateTime getTime() {
        return (TDateTime)this.time.clone();
    }

    public boolean equals(Object other) {
        if (other instanceof MCMessageInfo) {
            return this.origID == ((MCMessageInfo)other).getOrigID() && this.time.equals(((MCMessageInfo)other).getTime());
        }
        return false;
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    public void setUrlPart(String urlPart) {
        this.urlPart = urlPart;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long value) {
        this.startTime = value;
    }

    public Object getTrack() {
        return this.track;
    }

    public void setTrack(Object v) {
        this.track = v;
    }

    public boolean getSent() {
        return this.sent;
    }

    public void setSent(boolean x) {
        this.sent = x;
    }

    public byte getOldState() {
        return this.oldState;
    }

    public void setOldState(byte state) {
        this.oldState = state;
    }

    public long getClientID() {
        return this.clientID;
    }

    public void setClientID(long id) {
        this.clientID = id;
    }

    public long getConnID() {
        return this.connID;
    }

    public void setConnID(long id) {
        this.connID = id;
    }

    public byte getTransactCmd() {
        return this.transactCmd;
    }

    public void setTransactCmd(byte value) {
        this.transactCmd = value;
    }

    public String getRecvPath() {
        return this.recvPath;
    }

    public void setRecvPath(String value) {
        this.recvPath = value;
    }

    public String getRouteTo() {
        return this.routeTo;
    }

    public void setRouteTo(String value) {
        this.routeTo = value;
    }

    public boolean getIntermed() {
        return this.intermed;
    }

    public void setIntermed(boolean value) {
        this.intermed = value;
    }

    public byte[] getEncodedMsg() {
        return this.encodedMsg;
    }

    public void setEncodedMsg(byte[] value) {
        this.encodedMsg = value;
    }

    public int getEncodedLen() {
        return this.encodedLen;
    }

    public void setEncodedLen(int value) {
        this.encodedLen = value;
    }

    public int getEncryptID() {
        return this.encryptID;
    }

    public void setEncryptID(int value) {
        this.encryptID = value;
    }

    public int getCompressID() {
        return this.compressID;
    }

    public void setCompressID(int value) {
        this.compressID = value;
    }

    public int getSealID() {
        return this.sealID;
    }

    public void setSealID(int value) {
        this.sealID = value;
    }
}

