/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.beans.Beans;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.eldos.MsgConnect.IntegerHolder;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCBaseRouter;
import org.eldos.MsgConnect.MCBase.MCBaseTransport;
import org.eldos.MsgConnect.MCBase.MCErrorProc;
import org.eldos.MsgConnect.MCBase.MCMessage;
import org.eldos.MsgConnect.MCBase.MCMessageCredentials;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCBase.MCNotifyProc;
import org.eldos.MsgConnect.MCBase.MCQueue;
import org.eldos.MsgConnect.MCBase.MCTimeoutProc;
import org.eldos.MsgConnect.MCBase.UnknownDataTypeException;
import org.eldos.MsgConnect.MCBase.ValidateCredentialsEvent;
import org.eldos.MsgConnect.MCBase.ValidateCredentialsListener;
import org.eldos.MsgConnect.MCEvent;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMutex;
import org.eldos.MsgConnect.MCThreadPool;
import org.eldos.MsgConnect.MCWaitForMultipleObjects;

public class MCMessenger
extends Beans
implements Serializable,
Cloneable {
    public static final long INFINITE = Long.MAX_VALUE;
    private boolean isDestroy = false;
    private long fThreadID = 0L;
    private MCThreadPool pool = new MCThreadPool();
    public MCEvent completeEvent = new MCEvent();
    public MCEvent incomingEvent = new MCEvent();
    private int fMaxTimeout = Integer.MAX_VALUE;
    private int fCleanupInterval = 10000;
    private long fLastCleanup = 0L;
    protected Vector fQueues = new Vector();
    private Vector fTransportList = new Vector();
    public Vector completeQueue = new Vector();
    public Vector incomingQueue = new Vector();
    public MCMutex completeCriticalSection = new MCMutex();
    public MCMutex incomingCriticalSection = new MCMutex();
    public Vector forwardQueue = new Vector();
    public MCMutex forwardCriticalSection = new MCMutex();
    private Vector validateCredentialsListeners;
    private MCBaseRouter fRouter;
    private static int Checksum = 250;

    public MCMessenger() {
        this.fThreadID = Thread.currentThread().hashCode();
    }

    public void destroy() {
        this.isDestroy = true;
        this.dispatchCompleteMessages();
        if (this.incomingQueue != null) {
            this.incomingCriticalSection.enter();
            while (this.incomingQueue.size() > 0) {
                MCMessageInfo info = (MCMessageInfo)this.incomingQueue.get(0);
                this.incomingQueue.remove(0);
                info.setState((byte)5);
                if (info.isSendMsg() && this.fTransportList.indexOf(info.getTransport()) != -1) {
                    try {
                        info.getTransport().messageProcessed(info);
                    }
                    catch (Exception e) {
                        MCGlobals.DEBUG_STACKTRACE(e);
                    }
                    continue;
                }
                info = null;
            }
            this.incomingCriticalSection.leave();
        }
        if (this.fThreadID != (long)Thread.currentThread().hashCode()) {
            this.completeEvent.signal();
            this.incomingEvent.signal();
        }
        for (int i = 0; i < this.fTransportList.size(); ++i) {
            ((MCBaseTransport)this.fTransportList.elementAt(i)).destroy();
        }
        this.pool.clear();
        this.completeCriticalSection = null;
        this.incomingCriticalSection = null;
        this.incomingQueue = null;
        this.incomingEvent = null;
        this.completeQueue = null;
        this.completeEvent = null;
        this.fTransportList = null;
        this.fQueues = null;
    }

    public void finalize() throws Throwable {
        if (!this.isDestroy) {
            this.destroy();
        }
        super.finalize();
    }

    public static boolean setLicenseKey(String Key2) {
        return true;
    }

    public long getThreadID() {
        return this.fThreadID;
    }

    protected void addQueue(MCQueue queue) {
        if (this.fQueues.indexOf(queue) == -1) {
            this.fQueues.add(queue);
        }
    }

    protected void removeQueue(MCQueue queue) {
        int i = this.fQueues.indexOf(queue);
        if (i != -1) {
            this.fQueues.remove(i);
        }
    }

    protected void addTransport(MCBaseTransport transport) {
        if (this.fTransportList.indexOf(transport) == -1) {
            this.fTransportList.add(transport);
            return;
        }
    }

    protected void removeTransport(MCBaseTransport transport) {
        int i = this.fTransportList.indexOf(transport);
        if (i != -1) {
            this.fTransportList.remove(i);
        }
    }

    protected static void setMessageID(MCMessageInfo messageInfo) {
        messageInfo.setMsgID();
    }

    protected void doSendMessage(String destination, MCMessageInfo info) throws EMCError {
        int i;
        String RouteTo;
        boolean b = false;
        if (this.fRouter != null && (RouteTo = this.fRouter.TranslateAddress(destination.substring(0, i = destination.indexOf(124)))).length() > 0) {
            destination = RouteTo + "|" + destination;
        }
        MCBaseTransport bt = null;
        for (int i2 = 0; i2 < this.fTransportList.size(); ++i2) {
            bt = (MCBaseTransport)this.fTransportList.elementAt(i2);
            if (!bt.addressValid(destination)) continue;
            if (bt.getActive()) {
                if (!bt.deliverMessage(destination, info)) continue;
                info.setTransport(bt);
                b = true;
                break;
            }
            throw new EMCError(28);
        }
        if (!b) {
            throw new EMCError(4);
        }
    }

    protected void dispatchCompleteMessages() {
        MCMessageInfo info = null;
        MCMessageInfo localInfo = null;
        int i = 0;
        int i2 = 0;
        if (this.fCleanupInterval > 0) {
            this.cleanupQueues();
        }
        this.completeCriticalSection.enter();
        while (i < this.completeQueue.size()) {
            info = (MCMessageInfo)this.completeQueue.elementAt(i);
            boolean ProcessInfo = false;
            this.completeQueue.removeElementAt(i);
            if (info.getReplyFlag() == null) {
                ProcessInfo = true;
            }
            localInfo = null;
            this.forwardCriticalSection.enter();
            i2 = MCMessenger.findMessageInQueue(info.getOrigID(), this.forwardQueue);
            if (i2 != -1) {
                localInfo = (MCMessageInfo)this.forwardQueue.elementAt(i2);
            }
            if (localInfo != null) {
                this.forwardQueue.removeElement(localInfo);
                this.forwardCriticalSection.leave();
                localInfo.setMCError(info.getMCError());
                localInfo.setMessage(info.getMessage());
                info.getMessage().setData(null);
                this.doMessageProcessed(localInfo);
                continue;
            }
            this.forwardCriticalSection.leave();
            if (info.getState() == 4) {
                if (info.getNotifyProc() != null) {
                    this.completeCriticalSection.leave();
                    info.getNotifyProc().notifyProc(info.getUserData(), info.getMessage());
                    this.completeCriticalSection.enter();
                }
            } else if (info.getState() == 8) {
                if (info.getTimeoutProc() != null) {
                    this.completeCriticalSection.leave();
                    info.getTimeoutProc().timeoutProc(info.getUserData(), info.getMessage());
                    this.completeCriticalSection.enter();
                }
            } else if (info.getState() == 5 && info.getErrorProc() != null) {
                this.completeCriticalSection.leave();
                info.getErrorProc().errorProc(info.getUserData(), info.getMessage(), info.getMCError());
                this.completeCriticalSection.enter();
            }
            if (!ProcessInfo) continue;
            info = null;
        }
        this.completeEvent.reset();
        this.completeCriticalSection.leave();
    }

    protected static int findMessageInQueue(long msgID, Vector queue) {
        for (int i = 0; i < queue.size(); ++i) {
            MCMessageInfo info = (MCMessageInfo)queue.elementAt(i);
            MCMessage msg = info.getMessage();
            if (msg.getMsgID() != msgID) continue;
            return i;
        }
        return -1;
    }

    protected MCQueue findQueue(String queueName) {
        Enumeration e = this.fQueues.elements();
        while (e.hasMoreElements()) {
            MCQueue queue = (MCQueue)e.nextElement();
            if (!queue.getQueueName().equalsIgnoreCase(queueName)) continue;
            return queue;
        }
        return null;
    }

    protected int hasPendingMessages(Vector queue) {
        MCMessageInfo info = null;
        for (int i = 0; i < queue.size(); ++i) {
            info = (MCMessageInfo)queue.get(i);
            if (info.getState() != 2) continue;
            return i;
        }
        return -1;
    }

    public void setMaxTimeout(long value) {
        int iVal = value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
        if (this.fMaxTimeout != iVal) {
            this.fMaxTimeout = iVal;
            for (int i = 0; i < this.fTransportList.size() - 1; ++i) {
                ((MCBaseTransport)this.fTransportList.get(i)).setMsgTimeout(value);
            }
        }
    }

    public long getMaxTimeout() {
        return this.fMaxTimeout;
    }

    public void setCleanupInterval(int value) {
        if (this.fCleanupInterval == 0 && value > 0) {
            this.fLastCleanup = System.currentTimeMillis();
        }
        this.fCleanupInterval = value;
    }

    public int getCleanupInterval() {
        return this.fCleanupInterval;
    }

    public synchronized void dispatchMessages() throws EMCError {
        MCMessageInfo info = null;
        MCQueue aQueue = null;
        this.dispatchCompleteMessages();
        this.incomingCriticalSection.enter();
        int i = 0;
        while (i < this.incomingQueue.size()) {
            info = (MCMessageInfo)this.incomingQueue.get(i);
            if (info.getState() == 3) {
                MCGlobals.DEBUG_PRINTLN("DispatchMessages - Message " + info.getMessage().getMsgID() + " is already being processed");
                ++i;
                continue;
            }
            try {
                info.setState((byte)3);
            }
            catch (UnknownDataTypeException e) {
                // empty catch block
            }
            aQueue = this.findQueue(info.getDQueue());
            MCGlobals.DEBUG_PRINTLN("DispatchMessages - Message " + info.getMessage().getMsgID() + " to be processed");
            if (aQueue != null) {
                MCGlobals.DEBUG_PRINTLN("DispatchMessages - Message " + info.getMessage().getMsgID() + " queue found");
                this.incomingCriticalSection.leave();
                aQueue.processMessage(info);
                this.incomingCriticalSection.enter();
                continue;
            }
            MCGlobals.DEBUG_PRINTLN("DispatchMessages - Message " + info.getMessage().getMsgID() + " bad destination queue");
            info.setMCError(5);
            this.incomingCriticalSection.leave();
            this.messageProcessed(info.getMessage());
            this.incomingCriticalSection.enter();
        }
        this.incomingCriticalSection.leave();
    }

    public synchronized void getMessage(MCMessage message) throws EMCError, InterruptedException {
        MCWaitForMultipleObjects w = null;
        boolean canBreak = false;
        this.dispatchCompleteMessages();
        while (!canBreak) {
            this.incomingCriticalSection.enter();
            int i = this.hasPendingMessages(this.incomingQueue);
            if (i == -1) {
                MCEvent evt2;
                this.incomingCriticalSection.leave();
                MCEvent[] buf = new MCEvent[]{this.incomingEvent, this.completeEvent};
                w = new MCWaitForMultipleObjects(this.pool, buf);
                while ((evt2 = w.waitAny()) != null && evt2 != this.incomingEvent && evt2 == this.completeEvent) {
                    this.dispatchCompleteMessages();
                }
                this.dispatchCompleteMessages();
                this.incomingCriticalSection.enter();
            }
            if (i == -1) {
                i = this.hasPendingMessages(this.incomingQueue);
            }
            if (i != -1) {
                MCMessageInfo mi = (MCMessageInfo)this.incomingQueue.elementAt(i);
                mi.setState((byte)1);
                this.incomingEvent.waitFor(0L);
                mi.getMessage().copy(message);
                canBreak = true;
            }
            this.incomingCriticalSection.leave();
            if (null == w) continue;
            w.close();
        }
    }

    protected synchronized void doMessageProcessed(MCMessageInfo info) {
        if (info.getMCError() == 0) {
            info.setState((byte)4);
        } else {
            info.setState((byte)5);
        }
        info.setDQueue("intREPLY");
        if (info.getMessage().getDataType() == 0) {
            info.getMessage().setData(null);
        }
        if (info.isSendMsg() && this.fTransportList.indexOf(info.getTransport()) != -1) {
            try {
                info.setRouteTo(info.getRecvPath());
                info.setRecvPath("");
                info.getTransport().messageProcessed(info);
            }
            catch (Exception e) {
                MCGlobals.DEBUG_STACKTRACE(e);
            }
        } else {
            info = null;
        }
    }

    public synchronized void messageProcessed(MCMessage message) throws EMCError {
        this.incomingCriticalSection.enter();
        int i = MCMessenger.findMessageInQueue(message.getMsgID(), this.incomingQueue);
        if (i != -1) {
            MCMessageInfo info = (MCMessageInfo)this.incomingQueue.elementAt(i);
            info.setMessage(message);
            MCGlobals.DEBUG_PRINTLN("MessageProcessed - Message " + message.getMsgID() + " taken from message queue.");
            this.incomingQueue.remove(i);
            if (this.incomingQueue.size() == 0) {
                this.incomingEvent.reset();
            }
            this.incomingCriticalSection.leave();
            this.doMessageProcessed(info);
        } else {
            this.incomingCriticalSection.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean peekMessage(MCMessage message) throws EMCError {
        boolean rez;
        block5: {
            rez = false;
            this.dispatchCompleteMessages();
            this.incomingCriticalSection.enter();
            try {
                int i = this.hasPendingMessages(this.incomingQueue);
                if (i == -1) break block5;
                MCMessage msg = ((MCMessageInfo)this.incomingQueue.elementAt(i)).getMessage();
                msg.copy(message);
                try {
                    this.incomingEvent.waitFor(0L);
                }
                catch (Exception x) {
                    // empty catch block
                }
                rez = true;
            }
            finally {
                this.incomingCriticalSection.leave();
            }
        }
        return rez;
    }

    public synchronized void sendMessageTimeoutCallback(String destination, MCMessage message, int timeout, MCNotifyProc completionProc, MCTimeoutProc timeoutProc, MCErrorProc errorProc, Object userData, MCMessageCredentials credentials) throws EMCError {
        MCMessageInfo info = new MCMessageInfo();
        info.setMessage(message);
        info.setOrigID(MCMessage.getUniqueID());
        info.setNotifyProc(completionProc);
        info.setTimeoutProc(timeoutProc);
        info.setTimeout(timeout);
        info.setErrorProc(errorProc);
        info.setUserData(userData);
        info.setReplyFlag(null);
        info.setStartTime(System.currentTimeMillis());
        info.setSendMsg(completionProc != null);
        if (credentials != null) {
            info.setCredentials((MCMessageCredentials)credentials.clone());
        }
        try {
            this.doSendMessage(destination, info);
        }
        catch (EMCError e) {
            info = null;
            throw e;
        }
    }

    public synchronized void postMessage(String destination, MCMessage message, MCMessageCredentials credentials) throws EMCError {
        this.sendMessageTimeoutCallback(destination, message, this.fMaxTimeout, null, null, null, null, credentials);
    }

    public synchronized void sendMessageCallback(String destination, MCMessage message, MCNotifyProc completionProc, Object userData, MCMessageCredentials credentials) throws EMCError {
        this.sendMessageTimeoutCallback(destination, message, this.fMaxTimeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.fMaxTimeout, completionProc, null, null, userData, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized boolean sendMessageTimeout(String destination, MCMessage message, long timeout, boolean block, MCMessageCredentials credentials, IntegerHolder msgResult) throws EMCError {
        stTime = 0L;
        elapsed = 0L;
        handleArray = new MCEvent[3];
        result = false;
        w = null;
        info = new MCMessageInfo();
        info.setMessage(message);
        info.setOrigID(MCMessage.getUniqueID());
        info.setReplyFlag(new MCEvent());
        info.setSendMsg(true);
        if (credentials != null) {
            info.setCredentials((MCMessageCredentials)credentials.clone());
        }
        try {
            this.doSendMessage(destination, info);
        }
        catch (EMCError e) {
            info = null;
            throw e;
        }
        handleArray[0] = info.getReplyFlag();
        handleArray[1] = this.incomingEvent;
        handleArray[2] = this.completeEvent;
        do {
            stTime = System.currentTimeMillis();
            w = new MCWaitForMultipleObjects(this.pool, handleArray);
            if (timeout > 0x7FFFFFFFL) {
                timeout = 0x7FFFFFFFL;
            }
            evt = null;
            try {
                evt = w.waitAny((int)timeout);
            }
            catch (InterruptedException ex1) {
                break;
            }
            if (evt != null && evt == info.getReplyFlag()) {
                result = true;
                timeout = -1L;
            }
            this.dispatchCompleteMessages();
            elapsed = System.currentTimeMillis();
            timeout -= (long)((int)(elapsed -= stTime));
            if (block) continue;
            stTime = System.currentTimeMillis();
            this.dispatchMessages();
            elapsed = System.currentTimeMillis();
            elapsed = stTime > elapsed ? 0x7FFFFFFFFFFFFFFFL - stTime + elapsed : (elapsed -= stTime);
            timeout -= (long)((int)elapsed);
        } while (timeout > 0L);
        if (result) {
            try {
                this.completeCriticalSection.enter();
                if (info.getState() == 5) {
                    throw new EMCError(info.getMCError());
                }
                msgResult.i = info.getMessage().getResult();
                message.setResult(info.getMessage().getResult());
                if (message.getDataType() != 1) ** GOTO lbl61
                message.setData(info.getMessage().getData());
            }
            finally {
                info = null;
                this.completeCriticalSection.leave();
            }
        } else {
            info.getTransport().cancelMessage(null, info);
        }
lbl61:
        // 3 sources

        if (null != w) {
            w.close();
        }
        return result;
    }

    public int sendMessage(String destination, MCMessage message, MCMessageCredentials credentials) throws EMCError, InterruptedException {
        IntegerHolder i = new IntegerHolder();
        if (this.sendMessageTimeout(destination, message, this.fMaxTimeout, false, credentials, i)) {
            return i.i;
        }
        throw new EMCError(13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean forwardMessage(String destination, MCMessage message, long timeout, MCMessageCredentials credentials) throws EMCError {
        this.incomingCriticalSection.enter();
        MCMessageInfo info = null;
        this.forwardCriticalSection.enter();
        try {
            int i = MCMessenger.findMessageInQueue(message.getMsgID(), this.forwardQueue);
            if (i != -1) {
                info = (MCMessageInfo)this.forwardQueue.elementAt(i);
            }
            this.forwardCriticalSection.leave();
            if (info == null) {
                i = MCMessenger.findMessageInQueue(message.getMsgID(), this.incomingQueue);
                if (i != -1) {
                    info = (MCMessageInfo)this.incomingQueue.elementAt(i);
                }
                if (info != null) {
                    MCMessageInfo NewInfo = new MCMessageInfo();
                    NewInfo.setMessage(message);
                    NewInfo.setOrigID(message.getMsgID());
                    NewInfo.getMessage().setMsgID(message.getMsgID());
                    NewInfo.setTimeout((int)timeout);
                    NewInfo.setStartTime(System.currentTimeMillis());
                    NewInfo.setNotifyProc(null);
                    NewInfo.setTimeoutProc(null);
                    NewInfo.setErrorProc(null);
                    NewInfo.setUserData(null);
                    NewInfo.setReplyFlag(null);
                    NewInfo.setSendMsg(true);
                    if (credentials != null) {
                        info.setCredentials((MCMessageCredentials)credentials.clone());
                    }
                    this.doSendMessage(destination, NewInfo);
                    this.incomingQueue.remove(info);
                    if (this.incomingQueue.size() == 0) {
                        this.incomingEvent.reset();
                    }
                    this.forwardCriticalSection.enter();
                    this.forwardQueue.add(info);
                    this.forwardCriticalSection.leave();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.incomingCriticalSection.leave();
        }
    }

    public synchronized boolean waitMessageEx(long timeout) throws EMCError, InterruptedException {
        MCEvent[] handleArray = new MCEvent[2];
        MCWaitForMultipleObjects w = null;
        long startTime = System.currentTimeMillis();
        this.dispatchCompleteMessages();
        this.incomingCriticalSection.enter();
        int i = this.hasPendingMessages(this.incomingQueue);
        if (i == -1) {
            this.incomingCriticalSection.leave();
            handleArray[0] = this.incomingEvent;
            handleArray[1] = this.completeEvent;
            long currentTime = System.currentTimeMillis();
            if (timeout != Long.MAX_VALUE && timeout < currentTime - startTime) {
                return false;
            }
            w = new MCWaitForMultipleObjects(this.pool, handleArray);
            while (true) {
                MCEvent evt2 = null;
                if (timeout != Long.MAX_VALUE) {
                    evt2 = w.waitAny((int)(timeout - (currentTime - startTime)));
                    if (evt2 == null) {
                        return false;
                    }
                } else {
                    evt2 = w.waitAny();
                }
                if (evt2 != null && evt2 != this.incomingEvent && evt2 == this.completeEvent) {
                    this.dispatchCompleteMessages();
                    continue;
                }
                break;
            }
        } else {
            this.incomingCriticalSection.leave();
        }
        if (null != w) {
            w.close();
        }
        this.dispatchCompleteMessages();
        return true;
    }

    public synchronized void waitMessage() throws EMCError, InterruptedException {
        this.waitMessageEx(Long.MAX_VALUE);
    }

    protected synchronized void cleanupForwardQueue() {
        int i = 0;
        int TC = (int)System.currentTimeMillis();
        this.forwardCriticalSection.enter();
        while (i < this.forwardQueue.size()) {
            boolean me;
            MCMessageInfo info = (MCMessageInfo)this.forwardQueue.elementAt(i);
            if (info.getTimeout() == 0) {
                ++i;
                continue;
            }
            if ((long)TC < info.getStartTime()) {
                me = -1L - info.getStartTime() + (long)TC >= (long)info.getTimeout();
            } else {
                boolean bl = me = (long)TC - info.getStartTime() >= (long)info.getTimeout();
            }
            if (me) {
                this.forwardQueue.removeElement(info);
                continue;
            }
            ++i;
        }
        this.forwardCriticalSection.leave();
    }

    public synchronized void cleanupQueues() {
        boolean dc;
        long TC = System.currentTimeMillis();
        if (TC < this.fLastCleanup) {
            dc = -1L - this.fLastCleanup + TC >= (long)this.fCleanupInterval;
        } else {
            boolean bl = dc = TC - this.fLastCleanup >= (long)this.fCleanupInterval;
        }
        if (dc) {
            this.fLastCleanup = TC;
            for (int i = 0; i < this.fTransportList.size(); ++i) {
                ((MCBaseTransport)this.fTransportList.get(i)).cleanupMessages();
            }
            this.cleanupForwardQueue();
        }
    }

    public synchronized boolean cancelMessage(long MsgID) {
        for (int i = 0; i < this.fTransportList.size(); ++i) {
            if (!((MCBaseTransport)this.fTransportList.get(i)).cancelMessageByID(MsgID, true)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cancelMessageEx(long MsgID, boolean CancelComplete) {
        int i;
        for (i = 0; i < this.fTransportList.size(); ++i) {
            if (!((MCBaseTransport)this.fTransportList.get(i)).cancelMessageByID(MsgID, true)) continue;
            return true;
        }
        if (CancelComplete) {
            this.completeCriticalSection.enter();
            try {
                for (i = 0; i < this.completeQueue.size(); ++i) {
                    MCMessageInfo Info = (MCMessageInfo)this.completeQueue.elementAt(i);
                    if (Info.getMessage().getMsgID() != MsgID) continue;
                    this.completeQueue.removeElementAt(i);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.completeCriticalSection.leave();
            }
        }
        return false;
    }

    public synchronized void removeValidateCredentialsListener(ValidateCredentialsListener l) {
        if (this.validateCredentialsListeners != null && this.validateCredentialsListeners.contains(l)) {
            Vector v = (Vector)this.validateCredentialsListeners.clone();
            v.removeElement(l);
            this.validateCredentialsListeners = v;
        }
    }

    public synchronized void addValidateCredentialsListener(ValidateCredentialsListener l) {
        Vector v;
        Vector vector = v = this.validateCredentialsListeners == null ? new Vector(2) : (Vector)this.validateCredentialsListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.validateCredentialsListeners = v;
        }
    }

    public boolean fireValidateCredentials(ValidateCredentialsEvent e) {
        boolean res = false;
        if (this.validateCredentialsListeners == null || this.validateCredentialsListeners.size() == 0) {
            return true;
        }
        Vector listeners = this.validateCredentialsListeners;
        int count = listeners.size();
        for (int i = 0; i < count && !(res = ((ValidateCredentialsListener)listeners.elementAt(i)).ValidateCredentials(e)); ++i) {
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getMessageSource(MCMessage message) {
        String ret = "";
        this.incomingCriticalSection.enter();
        try {
            MCMessageInfo info;
            int i = MCMessenger.findMessageInQueue(message.getMsgID(), this.incomingQueue);
            if (i != -1 && (info = (MCMessageInfo)this.incomingQueue.elementAt(i)) != null && this.fTransportList.indexOf(info.getTransport()) != -1) {
                ret = info.getTransport().getMessageSource(info);
            }
        }
        finally {
            this.incomingCriticalSection.leave();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetQueueStatus(String QueueName, int MsgCodeLow, int MsgCodeHigh, IntegerHolder MsgCount, IntegerHolder MsgTotalSize, IntegerHolder MsgMaxSize) {
        int msgCount = 0;
        int msgMaxSize = 0;
        int msgTotalSize = 0;
        MsgCount.setI(0);
        MsgMaxSize.setI(0);
        MsgTotalSize.setI(0);
        String q = QueueName;
        if (q != null && q.length() == 0) {
            q = null;
        }
        if (q != null) {
            q = q.toLowerCase();
        }
        this.incomingCriticalSection.enter();
        try {
            for (int i = 0; i < this.incomingQueue.size(); ++i) {
                MCMessageInfo Info = (MCMessageInfo)this.incomingQueue.elementAt(i);
                if (q != null && Info.getDQueue().toLowerCase().compareTo(q) == 0 || (MsgCodeLow != 0 || MsgCodeHigh != 0) && (Info.getMessage().getMsgCode() < MsgCodeLow || Info.getMessage().getMsgCode() > MsgCodeHigh)) continue;
                int MS = Info.getMessage().getDataSize();
                msgTotalSize += MS;
                if (MS > msgMaxSize) {
                    msgMaxSize = MS;
                }
                ++msgCount;
            }
        }
        finally {
            this.incomingCriticalSection.leave();
        }
        MsgMaxSize.setI(msgMaxSize);
        MsgTotalSize.setI(msgTotalSize);
        MsgCount.setI(msgCount);
    }

    protected MCBaseRouter getRouter() {
        return this.fRouter;
    }

    protected synchronized void setRouter(MCBaseRouter aRouter) {
        this.fRouter = aRouter;
    }

    boolean getMessageSent(long MsgID) {
        boolean res = true;
        for (int i = 0; i < this.fTransportList.size(); ++i) {
            MCMessageInfo Info = ((MCBaseTransport)this.fTransportList.elementAt(i)).getMessageByID(MsgID);
            if (Info != null) {
                res = Info.getState() == 2;
                break;
            }
            res = true;
        }
        return res;
    }

    public static MCMessage createMessageSimple(int msgCode, int param1, int param2) {
        MCMessage result = new MCMessage();
        result.setMsgCode(msgCode);
        result.setParam1(param1);
        result.setParam2(param2);
        return result;
    }

    public static MCMessage createMessageFromBinary(int msgCode, int param1, int param2, byte[] binary, boolean isVarData) {
        MCMessage result = new MCMessage();
        result.setMsgCode(msgCode);
        result.setParam1(param1);
        result.setParam2(param2);
        result.setData((byte[])binary.clone());
        result.setDataType(isVarData ? (byte)1 : 0);
        return result;
    }

    public static MCMessage createMessageFromText(int msgCode, int param1, int param2, String text, CharsetEncoder encoder, boolean isVarData) {
        byte[] binary;
        MCMessage result = new MCMessage();
        result.setMsgCode(msgCode);
        result.setParam1(param1);
        result.setParam2(param2);
        if (encoder != null) {
            ByteBuffer bytebuf;
            CharBuffer buf = CharBuffer.allocate(text.length());
            buf = buf.put(text);
            encoder.reset();
            try {
                bytebuf = encoder.encode(buf);
            }
            catch (CharacterCodingException e) {
                bytebuf = ByteBuffer.allocate(0);
            }
            binary = bytebuf.array();
        } else {
            binary = text.getBytes();
        }
        result.setData(binary);
        result.setDataType(isVarData ? (byte)1 : 0);
        return result;
    }
}

