/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.beans.Beans;
import java.io.Serializable;
import java.util.Vector;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCHandleMessageEvent;
import org.eldos.MsgConnect.MCBase.MCHandleMessageListener;
import org.eldos.MsgConnect.MCBase.MCMessageHandler;
import org.eldos.MsgConnect.MCBase.MCMessageHandlers;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCBase.MCMessenger;
import org.eldos.MsgConnect.MCGlobals;

public class MCQueue
extends Beans
implements Serializable,
Cloneable {
    private MCMessageHandlers handlers = new MCMessageHandlers(this);
    private MCMessenger messenger = null;
    private String queueName = null;
    private Vector MCHandleMessageListeners;

    public MCQueue() {
        this.queueName = "";
    }

    public MCQueue(String queueName) {
        this.queueName = queueName;
    }

    public void setHandlers(MCMessageHandlers handlers) {
        this.handlers.assign(handlers);
    }

    public MCMessageHandlers getHandlers() {
        return this.handlers;
    }

    public void setMessenger(MCMessenger value) {
        if (this.messenger == value) {
            return;
        }
        if (this.messenger != null && this.messenger != value) {
            this.messenger.removeQueue(this);
        }
        this.messenger = value;
        if (this.messenger != null) {
            this.messenger.addQueue(this);
        }
    }

    public MCMessenger getMessenger() {
        return this.messenger;
    }

    public void setQueueName(String name) {
        this.queueName = name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    protected void processMessage(MCMessageInfo info) {
        boolean handled = false;
        if (this.messenger == null) {
            MCGlobals.DEBUG_PRINTLN("Error in MCQueue.processMessage. Queue does not belong to any messenger.");
            throw new NullPointerException("Queue does not belong to any messenger.");
        }
        for (int i = 0; i < this.handlers.size(); ++i) {
            MCMessageHandler mh = this.handlers.getItems(i);
            if (mh.getMsgCodeHigh() >= info.getMessage().getMsgCode() && mh.getMsgCodeLow() <= info.getMessage().getMsgCode() && mh.getEnabled()) {
                handled = mh.fireMessage(new MCHandleMessageEvent(this, info.getMessage()));
            }
            if (handled) break;
        }
        if (!handled) {
            MCGlobals.DEBUG_PRINTLN("MCQueue.processMessage. Message " + info.getMessage().getMsgCode() + " -- calling unhandled filter.");
            handled = this.fireUnhandledMessage(new MCHandleMessageEvent(this, info.getMessage()));
            if (!handled) {
                info.getMessage().setResult(0);
            }
        }
        try {
            this.messenger.messageProcessed(info.getMessage());
        }
        catch (EMCError e) {
            MCGlobals.DEBUG_STACKTRACE(e);
        }
    }

    public synchronized void removeUnhandledMessageListener(MCHandleMessageListener l) {
        if (this.MCHandleMessageListeners != null && this.MCHandleMessageListeners.contains(l)) {
            Vector v = (Vector)this.MCHandleMessageListeners.clone();
            v.removeElement(l);
            this.MCHandleMessageListeners = v;
        }
    }

    public synchronized void addUnhandledMessageListener(MCHandleMessageListener l) {
        Vector v;
        Vector vector = v = this.MCHandleMessageListeners == null ? new Vector(2) : (Vector)this.MCHandleMessageListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.MCHandleMessageListeners = v;
        }
    }

    protected boolean fireUnhandledMessage(MCHandleMessageEvent e) {
        boolean res = false;
        if (this.MCHandleMessageListeners != null) {
            Vector listeners = this.MCHandleMessageListeners;
            int count = listeners.size();
            for (int i = 0; i < count && !(res = ((MCHandleMessageListener)listeners.elementAt(i)).handleMessage(e)); ++i) {
            }
        }
        return res;
    }
}

