/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCBase;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.eldos.MsgConnect.MCBase.MCBaseTransport;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCBase.ValidateCredentialsEvent;

public class MCSimpleTransport
extends MCBaseTransport
implements Serializable {
    protected Vector outgoingQueue = new Vector();

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    protected Vector getOutgoingQueue() {
        return this.outgoingQueue;
    }

    @Override
    protected boolean deliverMessage(String destAddress, MCMessageInfo info) {
        return false;
    }

    protected void cancelMessageInSender(MCMessageInfo info) {
    }

    @Override
    protected void cancelMessage(List Queue, MCMessageInfo info) {
        this.criticalSection.enter();
        this.cancelMessageInSender(info);
        this.outgoingQueue.remove(info);
        this.criticalSection.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void cleanOutgoingQueue() {
        this.criticalSection.enter();
        try {
            while (this.outgoingQueue.size() > 0) {
                this.cancelMessageByID(((MCMessageInfo)this.outgoingQueue.elementAt(0)).getMessage().getMsgID(), 51);
            }
        }
        finally {
            this.criticalSection.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void cleanupMessages() {
        long TC = System.currentTimeMillis();
        int i = 0;
        this.criticalSection.enter();
        while (i < this.outgoingQueue.size()) {
            boolean me;
            MCMessageInfo Info = (MCMessageInfo)this.outgoingQueue.get(i);
            if (Info.getTimeout() == 0) {
                ++i;
                continue;
            }
            boolean bl = me = TC - Info.getStartTime() >= (long)Info.getTimeout();
            if (me) {
                this.cancelMessage(null, Info);
                Info.setState((byte)8);
                if (this.getMessenger() == null) continue;
                this.linkCriticalSection.enter();
                try {
                    if (this.messenger == null) continue;
                    this.messenger.completeCriticalSection.enter();
                    this.messenger.completeQueue.add(Info);
                    this.messenger.completeEvent.signal();
                    if (Info.getReplyFlag() != null) {
                        Info.getReplyFlag().signal();
                    }
                    this.messenger.completeCriticalSection.leave();
                    continue;
                }
                finally {
                    this.linkCriticalSection.leave();
                    continue;
                }
            }
            ++i;
        }
        this.criticalSection.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cancelMessageByID(long MsgID, int ErrorCode, boolean Discard) {
        boolean res = false;
        this.criticalSection.enter();
        for (int i = 0; i < this.outgoingQueue.size(); ++i) {
            MCMessageInfo Info = (MCMessageInfo)this.outgoingQueue.get(i);
            if (Info.getMessage().getMsgID() != MsgID) continue;
            this.cancelMessage(null, Info);
            Info.setState((byte)5);
            Info.setMCError(ErrorCode);
            res = true;
            if (Discard || this.getMessenger() == null) break;
            this.linkCriticalSection.enter();
            try {
                if (this.messenger == null) break;
                this.messenger.completeCriticalSection.enter();
                try {
                    this.messenger.completeQueue.add(Info);
                    this.messenger.completeEvent.signal();
                    if (Info.getReplyFlag() != null) {
                        Info.getReplyFlag().signal();
                    }
                    break;
                }
                finally {
                    this.messenger.completeCriticalSection.leave();
                }
            }
            finally {
                this.linkCriticalSection.leave();
            }
        }
        this.criticalSection.leave();
        return res;
    }

    protected void setInfoSMessenger(MCMessageInfo info) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageProcessed(MCMessageInfo info) {
        info.setDMessenger(info.getSMessenger());
        this.setInfoSMessenger(info);
        this.criticalSection.enter();
        try {
            MCSimpleTransport.insertInfoIntoQueueWithPriorities(this.outgoingQueue, info, this.ignoreIncomingPriorities);
            this.kickSender();
        }
        finally {
            this.criticalSection.leave();
        }
    }

    protected void messageReceived(MCMessageInfo info) {
        this.linkCriticalSection.enter();
        if (this.messenger != null) {
            if (!this.messenger.fireValidateCredentials(new ValidateCredentialsEvent(this, info.getMessage(), info.getCredentials()))) {
                info.setMCError(16);
                info.setState((byte)5);
                if (info.isSendMsg()) {
                    this.linkCriticalSection.leave();
                    this.messageProcessed(info);
                    this.linkCriticalSection.enter();
                } else {
                    info = null;
                }
            } else {
                info.setMCError(0);
                info.setTransport(this);
                info.setState((byte)2);
                this.messenger.incomingCriticalSection.enter();
                this.messenger.incomingQueue.add(info);
                this.messenger.incomingEvent.signal();
                this.messenger.incomingCriticalSection.leave();
            }
        } else {
            info = null;
        }
        this.linkCriticalSection.leave();
    }

    protected void replyReceived(MCMessageInfo info) {
        this.linkCriticalSection.enter();
        if (this.messenger != null) {
            this.messenger.completeCriticalSection.enter();
            this.messenger.completeQueue.add(info);
            this.messenger.completeEvent.signal();
            if (info.getReplyFlag() != null) {
                info.getReplyFlag().signal();
            }
            this.messenger.completeCriticalSection.leave();
        } else {
            info = null;
        }
        this.linkCriticalSection.leave();
    }

    @Override
    public int getOutgoingMessagesCount() {
        return this.outgoingQueue.size();
    }

    protected void kickSender() {
    }
}

