/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCCompression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCBaseCompression;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;

public class MCZLibCompression
extends MCBaseCompression {
    private static final boolean DEBUG = true;
    private int compressionLevel = 0;

    public MCZLibCompression() {
    }

    public MCZLibCompression(int compressionLevel) throws EMCError {
        this.setCompressionLevel(compressionLevel);
    }

    @Override
    public int getID() {
        return 1;
    }

    public void setCompressionLevel(int compressionLevel) throws EMCError {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new EMCError("Compression level must be in range 0..9.");
        }
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    @Override
    protected boolean compress(String remote, MCMessageDataHolder data) {
        if (data.getDataSize() == 0) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dflos = new DeflaterOutputStream((OutputStream)baos, new Deflater(this.compressionLevel));
        try {
            dflos.write(data.getData(), 0, data.getData().length);
            dflos.finish();
            data.setData(baos.toByteArray());
        }
        catch (Exception e) {
            try {
                dflos.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return false;
        }
        try {
            dflos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean decompress(String remote, MCMessageDataHolder data) {
        boolean ok = false;
        if (data.getDataSize() == 0) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getData());
        InflaterInputStream infis = new InflaterInputStream(bais);
        try {
            int r;
            if (infis.available() == 0) {
                throw new Exception();
            }
            while ((r = infis.read()) != -1) {
                baos.write(r);
            }
            data.setData(baos.toByteArray());
            ok = true;
        }
        catch (ZipException e) {
            data.setData(baos.toByteArray());
            ok = true;
        }
        catch (Exception e) {
        }
        finally {
            try {
                baos.close();
                infis.close();
                bais.close();
            }
            catch (Exception ex) {}
        }
        return ok;
    }
}

