/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCDataTree;

import java.beans.Beans;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.eldos.MsgConnect.MCDataTree.MCTreeItem;

public class MCDataTree
extends Beans
implements Serializable {
    private String comment = ";";
    private MCTreeItem curEntry;
    private String currentKey;
    private char delimiter;
    private char divChar;
    private boolean lazyWrite = true;
    private boolean modified = false;
    private String path = "";
    private MCTreeItem root = new MCTreeItem();
    private boolean simple = false;
    private boolean binaryMode = false;
    public String warningMessage = "Automatically generated file. DO NOT MODIFY!!!";

    public MCDataTree() {
        this.delimiter = (char)92;
        this.currentKey = "" + this.delimiter;
        this.curEntry = this.root;
        this.divChar = (char)61;
    }

    int turn_int(int l) {
        return ((l & 0xFF) << 24) + ((l >>> 8 & 0xFF) << 16) + ((l >>> 16 & 0xFF) << 8) + (l >>> 24 & 0xFF);
    }

    double turn_double(double d) {
        long j = Double.doubleToRawLongBits(d);
        j = ((j & 0xFFL) << 56) + ((j >>> 8 & 0xFFL) << 48) + ((j >>> 16 & 0xFFL) << 40) + ((j >>> 24 & 0xFFL) << 32) + ((j >>> 32 & 0xFFL) << 24) + ((j >>> 40 & 0xFFL) << 16) + ((j >>> 48 & 0xFFL) << 8) + (j >>> 56 & 0xFFL);
        d = Double.longBitsToDouble(j);
        return d;
    }

    byte[] Str2Data(String src) {
        if (src == null) {
            return null;
        }
        byte[] b = new byte[(src.length() - 4) / 2];
        int ix = 0;
        for (int x = 4; x < src.length(); x += 2) {
            try {
                b[ix] = (byte)Integer.valueOf(src.substring(x, x + 2), 16).intValue();
            }
            catch (NumberFormatException e) {
                return null;
            }
            ++ix;
        }
        return b;
    }

    String To2Chars(String s) {
        if (s.length() > 2) {
            s = s.substring(s.length() - 2, s.length());
        } else if (s.length() < 1) {
            s = "00";
        } else if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    String Data2Str(byte[] b) {
        String s = "454C";
        if (b == null || b.length < 1) {
            return null;
        }
        for (int x = 0; x < b.length; ++x) {
            s = s + this.To2Chars(Integer.toHexString(b[x]));
        }
        return s;
    }

    void LoadListFromStream(Vector l, DataInputStream f) throws IOException {
        if (l == null || f == null) {
            return;
        }
        while (f.available() > 0) {
            String s = f.readLine();
            if (s == null || s.length() <= 0) continue;
            l.add(s);
        }
    }

    byte[] ReadAnsiString(DataInputStream f, int i) throws IOException {
        if (i == 0) {
            return null;
        }
        if (i < 0) {
            i = f.readInt();
            i = this.turn_int(i);
        }
        if (i <= 0) {
            return null;
        }
        byte[] r = new byte[i];
        f.read(r, 0, i);
        return r;
    }

    void WriteAnsiString(DataOutputStream f, byte[] s, boolean write_len) throws IOException {
        if (write_len) {
            int i = 0;
            if (s != null) {
                i = s.length;
            }
            i = this.turn_int(i);
            f.writeInt(i);
        }
        if (s != null && s.length > 0) {
            f.write(s, 0, s.length);
        }
    }

    String ReadWideString(DataInputStream f, int i) throws IOException {
        String r = "";
        if (i == 0) {
            return "";
        }
        if (i < 0) {
            i = f.readInt();
            i = this.turn_int(i);
        }
        if (i <= 0) {
            return "";
        }
        i /= 2;
        while (i > 0) {
            byte b = f.readByte();
            byte b1 = f.readByte();
            r = r + (char)(((b1 & 0xFF) << 8) + (b & 0xFF));
            --i;
        }
        return r;
    }

    void WriteWideString(DataOutputStream f, String s, boolean write_len) throws IOException {
        int i;
        int j = s.length();
        if (write_len) {
            i = j * 2;
            i = this.turn_int(i);
            f.writeInt(i);
        }
        if (j > 0) {
            for (i = 0; i < j; ++i) {
                char c = s.charAt(i);
                f.writeByte((byte)(c & 0xFF));
                f.writeByte((byte)(c >> 8 & 0xFF));
            }
        }
    }

    String EncodeAnsiString(byte[] s) {
        String r = "";
        if (s == null || s.length < 1) {
            return r;
        }
        for (int i = 1; i <= s.length; ++i) {
            r = r + (char)s[i - 1];
        }
        return r;
    }

    byte[] DecodeAnsiString(String s) {
        if (s == null) {
            return null;
        }
        byte[] r = new byte[s.length()];
        for (int i = 1; i <= s.length(); ++i) {
            r[i - 1] = (byte)(s.charAt(i - 1) & 0xFF);
        }
        return r;
    }

    String EncodeUTF8string(String w) {
        String r = "\u00ef\u00bb\u00bf";
        if (w == null) {
            return "";
        }
        int wl = w.length();
        for (int i = 0; i < wl; ++i) {
            char c = w.charAt(i);
            if (c <= '\u007f') {
                r = r + (char)c;
                continue;
            }
            if (c > '\u07ff') {
                r = r + (char)(0xE0 | c >> 12);
                r = r + (char)(0x80 | c >> 6 & 0x3F);
                r = r + (char)(0x80 | c & 0x3F);
                continue;
            }
            r = r + (char)(0xC0 | c >> 6);
            r = r + (char)(0x80 | c & 0x3F);
        }
        return r;
    }

    String DecodeUTF8string(String s) {
        String r = "";
        if (s == null) {
            return "";
        }
        if (s.length() < 4) {
            return "";
        }
        int ss = s.length();
        int i = 3;
        while (i < ss) {
            int wc = s.charAt(i) & 0xFF;
            ++i;
            if ((wc & 0x80) != 0) {
                char c;
                wc &= 0x3F;
                if (i > ss) break;
                if ((wc & 0x20) != 0) {
                    c = s.charAt(i);
                    ++i;
                    if ((c & 0xC0) != 128) {
                        return null;
                    }
                    if (i > ss) break;
                    wc = wc << 6 | c & 0x3F;
                }
                c = s.charAt(i);
                ++i;
                if ((c & 0xCC0) != 128) {
                    return null;
                }
                r = r + (char)(wc << 6 | c & 0x3F);
                continue;
            }
            r = r + (char)wc;
        }
        return r;
    }

    private void IntLoadKey(Vector SL, int CurLine, String LoadInto) {
        String S = null;
        String KEN = String.valueOf(this.delimiter);
        String ValueName = null;
        String Value = null;
        MCTreeItem KE = this.root;
        int j = 0;
        boolean eos = false;
        boolean SkipValues = false;
        if (LoadInto.equals("")) {
            LoadInto = "" + this.delimiter;
        }
        if (LoadInto.charAt(LoadInto.length() - 1) != this.delimiter) {
            LoadInto = LoadInto + this.delimiter;
        }
        while (!eos) {
            MCTreeItem E;
            ++j;
            ValueName = null;
            Value = null;
            if (SL.size() <= CurLine) {
                return;
            }
            if ((S = (String)SL.elementAt(CurLine++)) == null || this.comment != null && S.substring(0, this.comment.length()).equals(this.comment)) continue;
            if (S.charAt(0) == '[') {
                SkipValues = false;
                if ((S = S.charAt(S.length() - 1) == ']' ? LoadInto + S.substring(1, S.length() - 1) : this.delimiter + S.substring(1)) != this.currentKey && !this.OpenKey(S, true)) {
                    SkipValues = true;
                    continue;
                }
                KEN = S;
                S = null;
                KE = this.curEntry;
                String z = String.valueOf(this.delimiter);
                this.OpenKey(z, false);
                continue;
            }
            if (SkipValues) continue;
            Boolean b = new Boolean(false);
            Vector ss = new Vector();
            if (!this.ParseLine(S, ss)) {
                Value = ValueName;
                ValueName = String.valueOf(j);
            } else {
                ValueName = (String)ss.get(0);
                Value = (String)ss.get(1);
            }
            if (Value == null) {
                Value = "";
            }
            if (ValueName == null) {
                ValueName = "";
            }
            int i = -1;
            if (ValueName.charAt(ValueName.length() - 1) == ']') {
                int l = -1;
                for (int x = 0; x < ValueName.length(); ++x) {
                    if (ValueName.charAt(x) != '[') continue;
                    l = x;
                    break;
                }
                int l1 = -1;
                for (int x1 = l + 1; x1 < ValueName.length(); ++x1) {
                    if (ValueName.charAt(x1) != ']') continue;
                    l1 = x1;
                    break;
                }
                if (l == -1 || l1 == -1) {
                    i = -1;
                    ValueName = null;
                } else {
                    String S1 = ValueName.substring(l + 1, ValueName.length() - 1);
                    ValueName = ValueName.substring(0, l);
                    try {
                        i = Integer.parseInt(S1.trim());
                    }
                    catch (NumberFormatException e) {
                        i = -1;
                        ValueName = null;
                    }
                }
            }
            if ((E = this.GetValueEntry(KEN, ValueName)) != null) {
                if (i == -1) {
                    E.Invalidate();
                }
                if (i >= 0 && E.FValueData.ValueType != 4 && E.FValueData.ValueType != 8) {
                    E.Invalidate();
                    E.FValueData.ValueType = (byte)4;
                    E.FValueData.MStrValue = new Vector();
                }
            } else {
                if (ValueName == null) continue;
                E = new MCTreeItem();
                E.FValueName = ValueName;
                ValueName = null;
                E.SetParent(KE);
            }
            if (ValueName != null) {
                ValueName = null;
            }
            if (i != -1) {
                boolean bf;
                boolean bw = Value != null && Value.length() > 3 && Value.substring(0, 3).equals("\u00ef\u00bb\u00bf");
                boolean bl = bf = 0 == i;
                if (bf) {
                    if (!bw && E.FValueData.ValueType != 4) {
                        E.Invalidate();
                        E.FValueData.ValueType = (byte)4;
                        E.FValueData.MStrValue = new Vector();
                    } else if (bw & E.FValueData.ValueType != 8) {
                        E.Invalidate();
                        E.FValueData.ValueType = (byte)8;
                        E.FValueData.MWideStrValue = new Vector();
                    }
                }
                if (E.FValueData.ValueType == 4) {
                    E.FValueData.MStrValue.add(this.DecodeAnsiString(Value));
                    continue;
                }
                if (bw) {
                    E.FValueData.MWideStrValue.add(this.DecodeUTF8string(Value));
                    continue;
                }
                E.FValueData.MWideStrValue.add(this.DecodeAnsiString(Value));
                continue;
            }
            String tt = Value.toLowerCase().trim();
            if (tt.equals("false") || tt.equals("true")) {
                E.FValueData.ValueType = 1;
                if (tt.equals("true")) {
                    E.FValueData.BoolValue = true;
                    continue;
                }
                E.FValueData.BoolValue = false;
                continue;
            }
            try {
                i = Integer.parseInt(Value.trim());
                E.FValueData.ValueType = (byte)2;
                E.FValueData.IntValue = i;
            }
            catch (NumberFormatException e) {
                try {
                    double d = Double.valueOf(Value.trim());
                    if (!Value.trim().equals(String.valueOf(d))) {
                        throw new NumberFormatException();
                    }
                    E.FValueData.ValueType = (byte)6;
                    E.FValueData.DoubleValue = d;
                }
                catch (NumberFormatException e2) {
                    if (Value != null && Value.length() > 3 && Value.trim().toLowerCase().substring(0, 4).equals("454c")) {
                        E.FValueData.ValueType = (byte)5;
                        E.FValueData.DataValue = this.Str2Data(Value);
                        continue;
                    }
                    if (Value != null && Value.length() > 3 && Value.substring(0, 3).equals("\u00ef\u00bb\u00bf")) {
                        E.FValueData.ValueType = (byte)7;
                        E.FValueData.WideStrValue = this.DecodeUTF8string(Value);
                        continue;
                    }
                    E.FValueData.ValueType = (byte)3;
                    E.FValueData.StrValue = this.DecodeAnsiString(Value);
                }
            }
        }
    }

    private void IntLoadBinKey(DataInputStream F, String LoadInto) throws IOException {
        MCTreeItem KE = this.root;
        String S = null;
        String KEN = null;
        boolean SkipValues = false;
        if (LoadInto.equals("")) {
            LoadInto = "" + this.delimiter;
        }
        if (LoadInto.charAt(LoadInto.length() - 1) != this.delimiter) {
            LoadInto = LoadInto + this.delimiter;
        }
        S = this.currentKey;
        this.OpenKey(LoadInto, true);
        KE = this.curEntry;
        this.OpenKey(S, false);
        while (F.available() > 0) {
            boolean b = F.readBoolean();
            S = this.EncodeAnsiString(this.ReadAnsiString(F, -1));
            if (b) {
                if (S != null && S.length() > 0 && S.charAt(0) != this.delimiter) {
                    S = LoadInto + S;
                }
                if (!this.OpenKey(S, true)) {
                    SkipValues = true;
                    continue;
                }
                KEN = S;
                S = null;
                KE = this.curEntry;
                String z = String.valueOf(this.delimiter);
                this.OpenKey(z, false);
                continue;
            }
            MCTreeItem E = this.GetValueEntry(KEN, S);
            byte VT = (byte)F.read();
            int i = F.readInt();
            i = this.turn_int(i);
            if (SkipValues) {
                F.skip(i);
                continue;
            }
            if (E != null) {
                if (VT == 4 ^ E.FValueData.ValueType == 4) {
                    if (VT == 8) {
                        E.FValueData.ValueType = (byte)8;
                        E.FValueData.MWideStrValue = new Vector();
                    } else if (VT == 4) {
                        E.FValueData.ValueType = (byte)4;
                        E.FValueData.MStrValue = new Vector();
                    } else {
                        E.Invalidate();
                    }
                }
            } else {
                E = new MCTreeItem();
                E.FValueName = S;
                E.SetParent(KE);
            }
            E.FValueData.ValueType = VT;
            switch (VT) {
                case 1: {
                    E.FValueData.BoolValue = F.readBoolean();
                    break;
                }
                case 6: {
                    double d = F.readDouble();
                    E.FValueData.DoubleValue = this.turn_double(d);
                    break;
                }
                case 2: {
                    int d = F.readInt();
                    E.FValueData.IntValue = this.turn_int(d);
                    break;
                }
                case 3: {
                    E.FValueData.StrValue = this.ReadAnsiString(F, i);
                    break;
                }
                case 7: {
                    E.FValueData.WideStrValue = this.ReadWideString(F, i);
                    break;
                }
                case 4: {
                    Object S1;
                    if (E.FValueData.MStrValue != null) {
                        E.FValueData.MStrValue = new Vector();
                    }
                    while (i > 0) {
                        S1 = this.ReadAnsiString(F, -1);
                        E.FValueData.MStrValue.add(S1);
                        i -= 4 + ((byte[])S1).length;
                    }
                    break;
                }
                case 8: {
                    Object S1;
                    if (E.FValueData.MWideStrValue != null) {
                        E.FValueData.MWideStrValue = new Vector();
                    }
                    while (i > 0) {
                        S1 = this.ReadWideString(F, -1);
                        E.FValueData.MWideStrValue.add(S1);
                        i -= 4 + ((String)S1).length() * 2;
                    }
                    break;
                }
                case 5: {
                    int lz = i;
                    E.FValueData.DataValue = new byte[lz];
                    F.read(E.FValueData.DataValue, 0, lz);
                }
            }
        }
    }

    private void IntSaveKey(DataOutputStream F, String KeyName, MCTreeItem KeyEntry) throws IOException {
        MCTreeItem E;
        int i;
        if (KeyName != null) {
            F.writeBytes("\n[" + KeyName + "]\n");
        }
        block11: for (i = 1; i <= KeyEntry.FChildren.size(); ++i) {
            E = (MCTreeItem)KeyEntry.FChildren.elementAt(i - 1);
            String S = E.FValueName != null && E.FValueName.charAt(0) != '#' ? E.FValueName + this.divChar : null;
            switch (E.FValueData.ValueType) {
                case 0: {
                    continue block11;
                }
                case 6: {
                    S = S + Double.toString(E.FValueData.DoubleValue);
                    F.writeBytes(S + "\n");
                    continue block11;
                }
                case 2: {
                    S = S + Integer.toString(E.FValueData.IntValue);
                    F.writeBytes(S + "\n");
                    continue block11;
                }
                case 1: {
                    S = this.simple ? S + (E.FValueData.BoolValue ? 1 : 0) : S + new Boolean(E.FValueData.BoolValue).toString();
                    F.writeBytes(S + "\n");
                    continue block11;
                }
                case 3: {
                    S = S + this.EncodeAnsiString(E.FValueData.StrValue);
                    F.writeBytes(S + "\n");
                    continue block11;
                }
                case 7: {
                    S = S + this.EncodeUTF8string(E.FValueData.WideStrValue);
                    F.writeBytes(S + "\n");
                    continue block11;
                }
                case 4: {
                    int j;
                    for (j = 1; j <= E.FValueData.MStrValue.size(); ++j) {
                        F.writeBytes(E.FValueName + "[" + (j - 1) + "]" + this.divChar + this.EncodeAnsiString((byte[])E.FValueData.MStrValue.elementAt(j - 1)) + "\n");
                    }
                    continue block11;
                }
                case 8: {
                    int j;
                    for (j = 1; j <= E.FValueData.MWideStrValue.size(); ++j) {
                        F.writeBytes(E.FValueName + "[" + (j - 1) + "]" + this.divChar + this.EncodeUTF8string((String)E.FValueData.MWideStrValue.elementAt(j - 1)) + "\n");
                    }
                    continue block11;
                }
                case 5: {
                    S = S + this.Data2Str(E.FValueData.DataValue);
                    F.writeBytes(S + "\n");
                }
            }
        }
        for (i = 1; i <= KeyEntry.FChildren.size(); ++i) {
            E = (MCTreeItem)KeyEntry.FChildren.elementAt(i - 1);
            if (!E.FIsKey) continue;
            if (KeyName != null) {
                this.IntSaveKey(F, KeyName + this.delimiter + E.FValueName, E);
                continue;
            }
            this.IntSaveKey(F, E.FValueName, E);
        }
    }

    private void IntSaveBinKey(DataOutputStream F, String KeyName, MCTreeItem KeyEntry) throws IOException {
        MCTreeItem E;
        int i;
        boolean b = true;
        F.writeBoolean(b);
        this.WriteAnsiString(F, this.DecodeAnsiString(KeyName), true);
        block20: for (i = 1; i <= KeyEntry.FChildren.size(); ++i) {
            int k;
            E = (MCTreeItem)KeyEntry.FChildren.elementAt(i - 1);
            if (E.FValueData.ValueType == 0) continue;
            b = false;
            F.writeBoolean(b);
            this.WriteAnsiString(F, this.DecodeAnsiString(E.FValueName), true);
            F.write(E.FValueData.ValueType);
            int j = 0;
            switch (E.FValueData.ValueType) {
                case 1: {
                    j = 1;
                    break;
                }
                case 6: {
                    j = 8;
                    break;
                }
                case 2: {
                    j = 4;
                    break;
                }
                case 3: {
                    if (E.FValueData.StrValue != null) {
                        j = E.FValueData.StrValue.length;
                        break;
                    }
                    j = 0;
                    break;
                }
                case 7: {
                    if (E.FValueData.WideStrValue != null) {
                        j = E.FValueData.WideStrValue.length() * 2;
                        break;
                    }
                    j = 0;
                    break;
                }
                case 4: {
                    j = 0;
                    for (k = 1; k <= E.FValueData.MStrValue.size(); ++k) {
                        j += 4 + ((byte[])E.FValueData.MStrValue.elementAt(k - 1)).length;
                    }
                    break;
                }
                case 8: {
                    j = 0;
                    for (k = 1; k <= E.FValueData.MWideStrValue.size(); ++k) {
                        j += 4 + ((String)E.FValueData.MWideStrValue.elementAt(k - 1)).length() * 2;
                    }
                    break;
                }
                case 5: {
                    j = E.FValueData.DataValue != null ? E.FValueData.DataValue.length : 0;
                }
            }
            int j1 = this.turn_int(j);
            F.writeInt(j1);
            switch (E.FValueData.ValueType) {
                case 1: {
                    F.writeBoolean(E.FValueData.BoolValue);
                    continue block20;
                }
                case 6: {
                    double d = this.turn_double(E.FValueData.DoubleValue);
                    F.writeDouble(d);
                    continue block20;
                }
                case 2: {
                    int d1 = this.turn_int(E.FValueData.IntValue);
                    F.writeInt(d1);
                    continue block20;
                }
                case 3: {
                    this.WriteAnsiString(F, E.FValueData.StrValue, false);
                    continue block20;
                }
                case 7: {
                    this.WriteWideString(F, E.FValueData.WideStrValue, false);
                    continue block20;
                }
                case 4: {
                    for (k = 1; k <= E.FValueData.MStrValue.size(); ++k) {
                        this.WriteAnsiString(F, (byte[])E.FValueData.MStrValue.elementAt(k - 1), true);
                    }
                    continue block20;
                }
                case 8: {
                    for (k = 1; k <= E.FValueData.MWideStrValue.size(); ++k) {
                        this.WriteWideString(F, (String)E.FValueData.MWideStrValue.elementAt(k - 1), true);
                    }
                    continue block20;
                }
                case 5: {
                    F.write(E.FValueData.DataValue);
                }
            }
        }
        for (i = 1; i <= KeyEntry.FChildren.size(); ++i) {
            E = (MCTreeItem)KeyEntry.FChildren.elementAt(i - 1);
            if (!E.FIsKey) continue;
            if (KeyName != null) {
                this.IntSaveBinKey(F, KeyName + this.delimiter + E.FValueName, E);
                continue;
            }
            this.IntSaveBinKey(F, E.FValueName, E);
        }
    }

    protected MCTreeItem GetValueEntry(String Key2, String ValueName) {
        String S = this.currentKey;
        MCTreeItem r = null;
        if (this.OpenKey(Key2, false)) {
            if (ValueName != null) {
                r = this.curEntry.GetValue(ValueName);
            } else if (this.curEntry != this.root) {
                r = this.curEntry;
            }
        }
        this.OpenKey(S, false);
        return r;
    }

    protected boolean ParseLine(String S, Vector ss) {
        boolean b = false;
        boolean iv = false;
        boolean vx = false;
        boolean nx = false;
        String n = "";
        String v = "";
        for (int i = 0; i < S.length(); ++i) {
            if (b) {
                if (S.charAt(i) == '\"') {
                    b = false;
                }
                if (iv) {
                    v = v + S.charAt(i);
                    continue;
                }
                n = n + S.charAt(i);
                continue;
            }
            if (S.charAt(i) == '\"') {
                b = true;
            }
            if (this.comment != null && this.comment.equals(S.substring(i, i + this.comment.length() - 1))) break;
            if (S.charAt(i) == this.divChar && !iv) {
                iv = true;
                continue;
            }
            if (iv) {
                v = v + S.charAt(i);
                continue;
            }
            n = n + S.charAt(i);
        }
        ss.clear();
        ss.add(n);
        ss.add(v);
        return iv;
    }

    public boolean Clear() {
        this.root.FChildren.clear();
        this.currentKey = "" + this.delimiter;
        this.curEntry = this.root;
        this.modified = true;
        return true;
    }

    public boolean ClearKey(String Key2) throws IOException {
        MCTreeItem E = this.GetValueEntry(Key2, null);
        if (E != null && E.FIsKey) {
            E.FChildren.clear();
            if (!this.lazyWrite) {
                this.Save();
            }
            this.modified = true;
            return true;
        }
        return false;
    }

    public MCTreeItem CreateValue(String Key2, String ValueName) {
        String S = this.currentKey;
        if (this.OpenKey(Key2, true)) {
            MCTreeItem E = this.GetValueEntry(Key2, ValueName);
            if (E == null) {
                E = new MCTreeItem();
                E.FValueName = ValueName;
                E.SetParent(this.curEntry);
            } else {
                E.Invalidate();
            }
            this.modified = true;
            E.FValueData.ValueType = 0;
            return E;
        }
        this.OpenKey(S, false);
        return null;
    }

    public boolean Delete(String Key2, String ValueName) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null && E != this.root) {
            if (this.curEntry == E) {
                this.curEntry = E.GetParent();
                for (int l = this.currentKey.length() - 1; l >= 0; --l) {
                    if (this.currentKey.charAt(l) != this.delimiter) continue;
                    this.currentKey = this.currentKey.substring(0, l);
                    break;
                }
            }
            E.FParent.FChildren.remove(E);
            this.modified = true;
            return true;
        }
        return false;
    }

    public boolean EnumSubKeys(String Key2, Vector Strings) {
        String S = this.currentKey;
        if (this.OpenKey(Key2, true)) {
            Enumeration e = this.curEntry.FChildren.elements();
            while (e.hasMoreElements()) {
                if (!((MCTreeItem)e.nextElement()).FIsKey) continue;
                Strings.add(((MCTreeItem)e.nextElement()).FValueName);
            }
            return true;
        }
        this.OpenKey(S, false);
        return false;
    }

    public boolean EnumValues(String Key2, Vector Strings) {
        String S = this.currentKey;
        if (this.OpenKey(Key2, true)) {
            Enumeration e = this.curEntry.FChildren.elements();
            while (e.hasMoreElements()) {
                if (((MCTreeItem)e.nextElement()).FIsKey) continue;
                Strings.add(((MCTreeItem)e.nextElement()).FValueName);
            }
            return true;
        }
        this.OpenKey(S, false);
        return false;
    }

    public String FullKey(String Key2) {
        String z = null;
        if (Key2 != null || Key2.charAt(0) != this.delimiter) {
            z = this.currentKey.equals("" + this.delimiter) ? this.delimiter + Key2 : this.currentKey + this.delimiter + Key2;
        }
        if (z.charAt(z.length() - 1) == this.delimiter) {
            z = z.substring(1, z.length());
        }
        return z;
    }

    public int GetValueType(String Key2, String ValueName) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null) {
            return E.FValueData.ValueType;
        }
        return 0;
    }

    public boolean KeyExists(String Key2) {
        String S = this.currentKey;
        boolean r = this.OpenKey(Key2, false);
        this.OpenKey(S, false);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LoadFromStream(DataInputStream Stream2) throws IOException {
        this.BeforeLoad();
        try {
            this.root.FChildren.clear();
            this.currentKey = "" + this.delimiter;
            this.curEntry = this.root;
            if (this.binaryMode) {
                this.IntLoadBinKey(Stream2, "" + this.delimiter);
            } else {
                Vector SL = new Vector();
                this.LoadListFromStream(SL, Stream2);
                this.IntLoadKey(SL, 0, "" + this.delimiter);
            }
        }
        finally {
            this.AfterLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveTotream(DataOutputStream Stream2) throws IOException {
        this.BeforeSave();
        try {
            if (this.binaryMode) {
                this.IntSaveBinKey(Stream2, null, this.root);
            } else {
                if (this.warningMessage != null) {
                    this.WriteAnsiString(Stream2, this.DecodeAnsiString(this.comment + this.warningMessage + "\n"), false);
                }
                this.IntSaveKey(Stream2, null, this.root);
            }
            this.modified = false;
        }
        finally {
            this.AfterSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Load() throws IOException {
        DataInputStream F = null;
        Vector SL = null;
        boolean r = false;
        this.BeforeLoad();
        try {
            this.root.FChildren.clear();
            this.currentKey = "" + this.delimiter;
            this.curEntry = this.root;
            F = new DataInputStream(new BufferedInputStream(new FileInputStream(this.path)));
            if (F != null) {
                if (this.binaryMode) {
                    this.IntLoadBinKey(F, "" + this.delimiter);
                } else {
                    SL = new Vector();
                    this.LoadListFromStream(SL, F);
                    this.IntLoadKey(SL, 0, "" + this.delimiter);
                }
            }
            r = true;
        }
        finally {
            this.AfterLoad();
        }
        return r;
    }

    public void Loaded() {
        if (this.path != null) {
            try {
                this.Load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean MoveEntry(String Key2, String ValueName, String NewKey) {
        MCTreeItem E;
        String S = this.currentKey;
        if (this.OpenKey(Key2, false) && (E = this.curEntry.GetValue(ValueName)) != null) {
            MCTreeItem E1 = this.GetValueEntry(NewKey, null);
            E.SetParent(E1);
            return true;
        }
        this.OpenKey(S, false);
        return false;
    }

    public boolean CopyToDataTree(String Key2, String ValueName, MCDataTree NewTree, String NewKey, boolean CopySubKeys, boolean CopyValue) {
        MCTreeItem E1;
        boolean r = true;
        MCTreeItem E = Key2.equals(String.valueOf(this.delimiter)) && ValueName == null ? this.root : this.GetValueEntry(Key2, ValueName);
        if (E != null && (E1 = NewTree.CreateValue(NewKey, ValueName)) != null) {
            r = r && E1.DubFrom(E, CopySubKeys, CopyValue);
        }
        return r;
    }

    public boolean CopyEntry(String Key2, String ValueName, String NewKey, boolean CopySubKeys, boolean CopyValue) {
        return this.CopyToDataTree(Key2, ValueName, this, NewKey, CopySubKeys, CopyValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean OpenKey(String aKey, boolean CanCreate) {
        MCTreeItem CE;
        if (aKey == null) {
            return true;
        }
        if (aKey.toLowerCase().trim().equals(this.currentKey.toLowerCase().trim())) {
            return true;
        }
        String Key2 = aKey;
        boolean r = false;
        if (this.simple) {
            MCTreeItem CE2;
            this.curEntry = this.root;
            this.currentKey = "" + this.delimiter;
            if (Key2.charAt(0) == this.delimiter) {
                Key2 = Key2.substring(2, Key2.length());
            }
            if ((CE2 = this.root.GetValue(Key2)) != null) {
                this.curEntry = CE2;
                this.currentKey = this.delimiter + Key2;
                return true;
            }
            if (!CanCreate) return false;
            CE2 = new MCTreeItem();
            CE2.FIsKey = true;
            CE2.FValueName = Key2;
            CE2.SetParent(this.root);
            this.modified = true;
            this.curEntry = CE2;
            this.currentKey = this.delimiter + Key2;
            return true;
        }
        if (Key2 != null && Key2.length() > 0 && Key2.charAt(0) == this.delimiter) {
            this.curEntry = this.root;
            this.currentKey = "" + this.delimiter;
            CE = this.root;
            Key2 = Key2.substring(1, Key2.length());
        } else {
            CE = this.curEntry;
            if (this.currentKey != "" + this.delimiter) {
                this.currentKey = this.currentKey + this.delimiter;
            }
        }
        if (Key2.length() < 1) {
            return true;
        }
        if (Key2.charAt(Key2.length() - 1) == this.delimiter) {
            Key2 = Key2.substring(0, Key2.length() - 1);
        }
        do {
            String S;
            int i = -1;
            for (int z = 0; z < Key2.length(); ++z) {
                if (Key2.charAt(z) != this.delimiter) continue;
                i = z;
                break;
            }
            if (i > -1) {
                S = Key2.substring(0, i);
                if (S.length() < 1) {
                    return false;
                }
                Key2 = Key2.substring(i + 1);
            } else {
                S = Key2;
                Key2 = "";
            }
            CE = CE.GetValue(S);
            if (CE == null) {
                if (!CanCreate) {
                    return false;
                }
                this.currentKey = this.currentKey + S + this.delimiter;
                CE = new MCTreeItem();
                CE.FIsKey = true;
                CE.FValueName = S;
                CE.SetParent(this.curEntry);
                this.modified = true;
            } else if (!CE.FIsKey) {
                if (!CanCreate) return false;
                CE.FIsKey = true;
                this.modified = true;
                this.currentKey = this.currentKey + S + this.delimiter;
            } else {
                this.currentKey = this.currentKey + S + this.delimiter;
            }
            this.curEntry = CE;
        } while (Key2.length() >= 1);
        if (this.currentKey.length() <= 1 || this.currentKey.charAt(this.currentKey.length() - 2) != this.delimiter) return true;
        this.currentKey = this.currentKey.substring(0, this.currentKey.length() - 1);
        return true;
    }

    public String OwnKey(String Key2) {
        String t = this.FullKey(Key2);
        int l = t.length();
        int l1 = -1;
        for (int z = l - 1; z >= 0; --z) {
            if (t.charAt(z) != this.delimiter) continue;
            l1 = z;
            break;
        }
        if (l1 < 0) {
            return t;
        }
        String t1 = t.substring(l1 + 1);
        return t1;
    }

    public String ParentKey(String Key2) {
        String t = this.FullKey(Key2);
        int l = t.length();
        int l1 = -1;
        for (int z = l - 1; z >= 0; --z) {
            if (t.charAt(z) != this.delimiter) continue;
            l1 = z;
            break;
        }
        if (l1 < 0) {
            return "" + this.delimiter;
        }
        return t.substring(0, l1 - 1);
    }

    public boolean ReadBool(String Key2, String ValueName, boolean DefValue, Boolean Value) {
        Value = new Boolean(DefValue);
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null) {
            if (E.FValueData.ValueType == 1) {
                Value = new Boolean(E.FValueData.BoolValue);
                return true;
            }
            if (E.FValueData.ValueType == 2) {
                Value = new Boolean(E.FValueData.IntValue != 0);
                return true;
            }
        }
        return false;
    }

    public boolean ReadInteger(String Key2, String ValueName, int DefValue, Integer Value) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null) {
            if (E.FValueData.ValueType == 2) {
                Value = new Integer(E.FValueData.IntValue);
                return true;
            }
            if (E.FValueData.ValueType == 3) {
                try {
                    Value = new Integer(Integer.parseInt(this.EncodeAnsiString(E.FValueData.StrValue)));
                }
                catch (NumberFormatException e) {
                    Value = new Integer(0);
                }
            } else if (E.FValueData.ValueType == 7) {
                try {
                    Value = new Integer(Integer.parseInt(E.FValueData.WideStrValue));
                }
                catch (NumberFormatException e) {
                    Value = new Integer(0);
                }
            } else {
                Value = new Integer(DefValue);
            }
        } else {
            Value = new Integer(DefValue);
        }
        return false;
    }

    public boolean ReadMultiString(String Key2, String ValueName, Vector Strings) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null && E.FValueData.ValueType == 4) {
            Strings = new Vector(E.FValueData.MStrValue);
            return true;
        }
        return false;
    }

    public boolean ReadMultiWideString(String Key2, String ValueName, Vector Strings) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null && E.FValueData.ValueType == 8) {
            Strings = new Vector(E.FValueData.MWideStrValue);
            return true;
        }
        return false;
    }

    public boolean ReadWideString(String Key2, String ValueName, String DefValue, String Value) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null) {
            if (E.FValueData.ValueType == 4) {
                Value = E.FValueData.MStrValue.toString();
                return true;
            }
            if (E.FValueData.ValueType == 8) {
                Value = E.FValueData.MWideStrValue.toString();
                return true;
            }
            if (E.FValueData.ValueType == 3) {
                Value = this.EncodeAnsiString(E.FValueData.StrValue);
                return true;
            }
            if (E.FValueData.ValueType == 7) {
                Value = E.FValueData.WideStrValue;
                return true;
            }
            if (E.FValueData.ValueType == 2) {
                Value = String.valueOf(E.FValueData.IntValue);
                return true;
            }
            if (E.FValueData.ValueType == 1) {
                Value = E.FValueData.BoolValue ? "true" : "false";
                return true;
            }
            if (E.FValueData.ValueType == 5) {
                Value = this.Data2Str(E.FValueData.DataValue);
                return true;
            }
        }
        Value = DefValue;
        return false;
    }

    public boolean ReadString(String Key2, String ValueName, byte[] DefValue, byte[] Value) {
        String v = "";
        Value = this.ReadWideString(Key2, ValueName, "", v) ? this.DecodeAnsiString(v) : DefValue;
        return false;
    }

    public boolean ReadDouble(String Key2, String ValueName, double DefValue, Double Value) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null) {
            if (E.FValueData.ValueType == 6) {
                Value = new Double(E.FValueData.DoubleValue);
                return true;
            }
            Value = E.FValueData.ValueType == 3 ? Double.valueOf(this.EncodeAnsiString(E.FValueData.StrValue)) : (E.FValueData.ValueType == 7 ? Double.valueOf(E.FValueData.WideStrValue) : (E.FValueData.ValueType == 2 ? new Double(E.FValueData.IntValue) : new Double(DefValue)));
        } else {
            Value = new Double(DefValue);
        }
        return false;
    }

    public boolean ReadBinary(String Key2, String ValueName, byte[] Buffer2) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null && E.FValueData.ValueType == 5) {
            E.FValueData.DataValue = Buffer2;
            return true;
        }
        return false;
    }

    public boolean RenameKey(String Key2, String NewName) {
        MCTreeItem E = this.GetValueEntry(Key2, null);
        if (E != null && E != this.root) {
            if (NewName.indexOf(this.delimiter) < 0) {
                return false;
            }
            if (this.KeyExists(Key2.substring(1, Key2.lastIndexOf(this.delimiter)) + NewName)) {
                return false;
            }
            E.FValueName = NewName;
            this.modified = true;
            return true;
        }
        return false;
    }

    public boolean RenameValue(String Key2, String ValueName, String NewName) {
        MCTreeItem E = this.GetValueEntry(Key2, ValueName);
        if (E != null && E != this.root && this.GetValueEntry(Key2, NewName) != null && NewName.indexOf(this.delimiter) >= 0) {
            E.FValueName = NewName;
            this.modified = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Save() throws IOException {
        boolean r = false;
        this.BeforeSave();
        try {
            DataOutputStream F = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.path)));
            try {
                if (this.binaryMode) {
                    this.IntSaveBinKey(F, null, this.root);
                } else {
                    if (this.warningMessage != null) {
                        F.writeBytes(this.comment + this.warningMessage + "\n");
                    }
                    this.IntSaveKey(F, null, this.root);
                }
                this.modified = false;
                r = true;
            }
            finally {
                F.close();
            }
        }
        finally {
            this.AfterSave();
        }
        return r;
    }

    public void SetValueType(String Key2, String ValueName, byte NewType) {
        MCTreeItem E = this.CreateValue(Key2, ValueName);
        if (E != null) {
            E.Invalidate();
            E.FValueData.ValueType = NewType;
            if (NewType == 4) {
                E.FValueData.MStrValue = new Vector();
            }
            if (NewType == 8) {
                E.FValueData.MWideStrValue = new Vector();
            }
        }
        this.modified = true;
    }

    public int SubKeysCount(String Key2) {
        int r = -1;
        Vector sl = new Vector();
        if (this.EnumSubKeys(Key2, sl)) {
            r = sl.size();
        }
        return r;
    }

    public boolean ValueExists(String Key2, String ValueName) {
        MCTreeItem E;
        String S = this.currentKey;
        boolean r = false;
        if (this.OpenKey(Key2, false) && (E = this.curEntry.GetValue(ValueName)) != null && !E.FIsKey) {
            r = true;
        }
        this.OpenKey(S, false);
        return r;
    }

    public int ValuesCount(String Key2) {
        int r = -1;
        Vector sl = new Vector();
        if (this.EnumValues(Key2, sl)) {
            r = sl.size();
        }
        return r;
    }

    public boolean WriteBinary(String Key2, String ValueName, byte[] Buffer2, int BufferLen) throws IOException {
        if (this.simple) {
            return false;
        }
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = (byte)5;
        E.FValueData.DataValue = Buffer2;
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public boolean WriteBool(String Key2, String ValueName, boolean Value) throws IOException {
        if (this.simple) {
            return false;
        }
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = 1;
        E.FValueData.BoolValue = Value;
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public boolean WriteDouble(String Key2, String ValueName, double Value) throws IOException {
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = (byte)6;
        E.FValueData.DoubleValue = Value;
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public boolean WriteInteger(String Key2, String ValueName, int Value) throws IOException {
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = (byte)2;
        E.FValueData.IntValue = Value;
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public boolean WriteMultiString(String Key2, String ValueName, Vector Strings) throws IOException {
        if (this.simple) {
            return false;
        }
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = (byte)4;
        E.FValueData.MStrValue = new Vector();
        E.FValueData.MStrValue = (Vector)Strings.clone();
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public boolean WriteMultiWideString(String Key2, String ValueName, Vector Strings) throws IOException {
        if (this.simple) {
            return false;
        }
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = (byte)8;
        E.FValueData.MWideStrValue = (Vector)Strings.clone();
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public boolean WriteString(String Key2, String ValueName, byte[] Value) throws IOException {
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = (byte)3;
        E.FValueData.StrValue = new byte[Value.length];
        System.arraycopy(Value, 0, E.FValueData.StrValue, 0, Value.length);
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public boolean WriteWideString(String Key2, String ValueName, String Value) throws IOException {
        String S = this.currentKey;
        if (!this.OpenKey(Key2, true)) {
            this.OpenKey(S, false);
            return false;
        }
        MCTreeItem E = this.CreateValue(null, ValueName);
        E.FValueData.ValueType = (byte)7;
        E.FValueData.WideStrValue = Value;
        this.modified = true;
        if (!this.lazyWrite) {
            this.Save();
        }
        this.OpenKey(S, false);
        return true;
    }

    public void setCurrentKey(String newValue) {
        if (this.currentKey != newValue) {
            this.OpenKey(newValue, true);
        }
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public void setComment(String newValue) {
        this.comment = newValue;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean Modified() {
        return this.modified;
    }

    public boolean getBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean val) {
        this.binaryMode = val;
    }

    public void setDelimiter(char newValue) throws IOException {
        if (this.delimiter != newValue) {
            this.delimiter = newValue;
            if (this.curEntry == this.root) {
                this.currentKey = this.delimiter + this.currentKey;
            }
            if (!this.lazyWrite) {
                this.Save();
            }
        }
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDivChar(char newValue) {
        this.divChar = newValue;
    }

    public char getDivChar() {
        return this.divChar;
    }

    public void setLazyWrite(boolean newValue) {
        if (this.lazyWrite != newValue) {
            this.lazyWrite = newValue;
        }
    }

    public boolean getLazyWrite() {
        return this.lazyWrite;
    }

    public void setPath(String newValue) {
        if (this.path != null && newValue != null && this.path != newValue || newValue != null) {
            this.path = newValue;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setSimple(boolean newValue) throws IOException {
        if (this.simple != newValue) {
            String RN = this.path;
            this.path = File.createTempFile("initest", "tmp").getName();
            this.Save();
            this.simple = newValue;
            if (this.simple) {
                char TD = this.delimiter;
                this.delimiter = '\u0000';
                this.Load();
                this.delimiter = TD;
            } else {
                this.Load();
            }
            File F = new File(this.path);
            if (F.exists()) {
                F.delete();
            }
            this.path = RN;
        }
    }

    public void LoadKeyFromStream(DataInputStream F, String KeyName) throws Exception {
        Vector SL = new Vector();
        if (this.binaryMode) {
            this.IntLoadBinKey(F, KeyName);
        } else {
            this.LoadListFromStream(SL, F);
            this.IntLoadKey(SL, 0, KeyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveKeyToStream(DataOutputStream F, String KeyName) throws Exception {
        String S = this.currentKey;
        try {
            if (this.OpenKey(KeyName, false)) {
                if (this.binaryMode) {
                    this.IntSaveBinKey(F, this.curEntry.FValueName, this.curEntry);
                } else {
                    this.IntSaveKey(F, this.curEntry.FValueName, this.curEntry);
                }
            }
        }
        finally {
            this.OpenKey(S, false);
        }
    }

    public boolean getSimple() {
        return this.simple;
    }

    public void BeforeLoad() {
    }

    public void AfterSave() {
    }

    public void BeforeSave() {
    }

    public void AfterLoad() {
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getwarningMessage() {
        return this.warningMessage;
    }

    public void setwarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }
}

