/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCEncryption;

import java.security.InvalidKeyException;

public final class AESEncryptor {
    static final int BLOCK_SIZE = 16;
    static final int blockSize = 16;
    static final int[] alog;
    static final int[] log;
    static final byte[] S;
    static final byte[] Si;
    static final int[] T1;
    static final int[] T2;
    static final int[] T3;
    static final int[] T4;
    static final int[] T5;
    static final int[] T6;
    static final int[] T7;
    static final int[] T8;
    static final int[] U1;
    static final int[] U2;
    static final int[] U3;
    static final int[] U4;
    static final byte[] rcon;
    static final int[][][] shifts;
    private static final char[] HEX_DIGITS;

    static final int mul(int a, int b) {
        return a != 0 && b != 0 ? alog[(log[a & 0xFF] + log[b & 0xFF]) % 255] : 0;
    }

    static final int mul4(int a, byte[] b) {
        if (a == 0) {
            return 0;
        }
        a = log[a & 0xFF];
        int a0 = b[0] != 0 ? alog[(a + log[b[0] & 0xFF]) % 255] & 0xFF : 0;
        int a1 = b[1] != 0 ? alog[(a + log[b[1] & 0xFF]) % 255] & 0xFF : 0;
        int a2 = b[2] != 0 ? alog[(a + log[b[2] & 0xFF]) % 255] & 0xFF : 0;
        int a3 = b[3] != 0 ? alog[(a + log[b[3] & 0xFF]) % 255] & 0xFF : 0;
        return a0 << 24 | a1 << 16 | a2 << 8 | a3;
    }

    private static int getRounds(int keySize) {
        return (keySize >> 2) + 6;
    }

    private static Object makeKey(byte[] keyBytes, boolean decrypt) throws InvalidKeyException {
        int tt;
        if (keyBytes == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (keyBytes.length != 16 && keyBytes.length != 24 && keyBytes.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        int ROUNDS = AESEncryptor.getRounds(keyBytes.length);
        int BC = 4;
        int[][] Ke = new int[ROUNDS + 1][BC];
        int[][] Kd = new int[ROUNDS + 1][BC];
        int ROUND_KEY_COUNT = (ROUNDS + 1) * BC;
        int KC = keyBytes.length / 4;
        int[] tk = new int[KC];
        int i = 0;
        int j = 0;
        while (i < KC) {
            tk[i++] = (keyBytes[j++] & 0xFF) << 24 | (keyBytes[j++] & 0xFF) << 16 | (keyBytes[j++] & 0xFF) << 8 | keyBytes[j++] & 0xFF;
        }
        int t = 0;
        for (j = 0; j < KC && t < ROUND_KEY_COUNT; ++j, ++t) {
            Ke[t / BC][t % BC] = tk[j];
            Kd[ROUNDS - t / BC][t % BC] = tk[j];
        }
        int rconpointer = 0;
        while (t < ROUND_KEY_COUNT) {
            tt = tk[KC - 1];
            tk[0] = tk[0] ^ ((S[tt >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[tt >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[tt & 0xFF] & 0xFF) << 8 ^ S[tt >>> 24 & 0xFF] & 0xFF ^ (rcon[rconpointer++] & 0xFF) << 24);
            if (KC != 8) {
                i = 1;
                j = 0;
                while (i < KC) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
            } else {
                i = 1;
                j = 0;
                while (i < KC / 2) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
                tt = tk[KC / 2 - 1];
                int n = KC / 2;
                tk[n] = tk[n] ^ (S[tt & 0xFF] & 0xFF ^ (S[tt >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[tt >>> 16 & 0xFF] & 0xFF) << 16 ^ (S[tt >>> 24 & 0xFF] & 0xFF) << 24);
                j = KC / 2;
                i = j + 1;
                while (i < KC) {
                    int n2 = i++;
                    tk[n2] = tk[n2] ^ tk[j++];
                }
            }
            for (j = 0; j < KC && t < ROUND_KEY_COUNT; ++j, ++t) {
                Ke[t / BC][t % BC] = tk[j];
                Kd[ROUNDS - t / BC][t % BC] = tk[j];
            }
        }
        for (int r = 1; r < ROUNDS; ++r) {
            for (j = 0; j < BC; ++j) {
                tt = Kd[r][j];
                Kd[r][j] = U1[tt >>> 24 & 0xFF] ^ U2[tt >>> 16 & 0xFF] ^ U3[tt >>> 8 & 0xFF] ^ U4[tt & 0xFF];
            }
        }
        if (decrypt) {
            return Kd;
        }
        return Ke;
    }

    public static Object expandKeyForEncryption(byte[] userkey) throws InvalidKeyException {
        Object res = AESEncryptor.makeKey(userkey, false);
        return res;
    }

    public static Object expandKeyForDecryption(byte[] userkey) throws InvalidKeyException {
        Object res = AESEncryptor.makeKey(userkey, true);
        return res;
    }

    private static void blockEncrypt(Object K, byte[] in, int inOffset, byte[] out, int outOffset, int keylen) {
        int[][] Ke = (int[][])K;
        int ROUNDS = Ke.length - 1;
        int[] Ker = Ke[0];
        int t0 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[0];
        int t1 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[1];
        int t2 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[2];
        int t3 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[3];
        for (int r = 1; r < ROUNDS; ++r) {
            Ker = Ke[r];
            int a0 = T1[t0 >>> 24 & 0xFF] ^ T2[t1 >>> 16 & 0xFF] ^ T3[t2 >>> 8 & 0xFF] ^ T4[t3 & 0xFF] ^ Ker[0];
            int a1 = T1[t1 >>> 24 & 0xFF] ^ T2[t2 >>> 16 & 0xFF] ^ T3[t3 >>> 8 & 0xFF] ^ T4[t0 & 0xFF] ^ Ker[1];
            int a2 = T1[t2 >>> 24 & 0xFF] ^ T2[t3 >>> 16 & 0xFF] ^ T3[t0 >>> 8 & 0xFF] ^ T4[t1 & 0xFF] ^ Ker[2];
            int a3 = T1[t3 >>> 24 & 0xFF] ^ T2[t0 >>> 16 & 0xFF] ^ T3[t1 >>> 8 & 0xFF] ^ T4[t2 & 0xFF] ^ Ker[3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
        }
        Ker = Ke[ROUNDS];
        int tt = Ker[0];
        out[outOffset++] = (byte)(S[t0 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t1 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t2 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(S[t3 & 0xFF] ^ tt);
        tt = Ker[1];
        out[outOffset++] = (byte)(S[t1 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t2 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t3 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(S[t0 & 0xFF] ^ tt);
        tt = Ker[2];
        out[outOffset++] = (byte)(S[t2 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t3 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t0 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(S[t1 & 0xFF] ^ tt);
        tt = Ker[3];
        out[outOffset++] = (byte)(S[t3 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t0 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t1 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset] = (byte)(S[t2 & 0xFF] ^ tt);
    }

    private static void blockDecrypt(Object K, byte[] in, int inOffset, byte[] out, int outOffset, int keylen) {
        int[][] Kd = (int[][])K;
        int ROUNDS = Kd.length - 1;
        int[] Kdr = Kd[0];
        int t0 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[0];
        int t1 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[1];
        int t2 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[2];
        int t3 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[3];
        for (int r = 1; r < ROUNDS; ++r) {
            Kdr = Kd[r];
            int a0 = T5[t0 >>> 24 & 0xFF] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ Kdr[0];
            int a1 = T5[t1 >>> 24 & 0xFF] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ Kdr[1];
            int a2 = T5[t2 >>> 24 & 0xFF] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ Kdr[2];
            int a3 = T5[t3 >>> 24 & 0xFF] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ Kdr[3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
        }
        Kdr = Kd[ROUNDS];
        int tt = Kdr[0];
        out[outOffset++] = (byte)(Si[t0 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(Si[t3 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(Si[t2 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(Si[t1 & 0xFF] ^ tt);
        tt = Kdr[1];
        out[outOffset++] = (byte)(Si[t1 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(Si[t0 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(Si[t3 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(Si[t2 & 0xFF] ^ tt);
        tt = Kdr[2];
        out[outOffset++] = (byte)(Si[t2 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(Si[t1 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(Si[t0 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(Si[t3 & 0xFF] ^ tt);
        tt = Kdr[3];
        out[outOffset++] = (byte)(Si[t3 >>> 24 & 0xFF] ^ tt >>> 24);
        out[outOffset++] = (byte)(Si[t2 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(Si[t1 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset] = (byte)(Si[t0 & 0xFF] ^ tt);
    }

    public static void Encrypt(byte[] InBuf, Object Key2, byte[] OutBuf) {
        int len = 0;
        switch (((int[][])Key2).length) {
            case 11: {
                len = 16;
                break;
            }
            case 13: {
                len = 24;
                break;
            }
            case 15: {
                len = 32;
            }
        }
        AESEncryptor.blockEncrypt(Key2, InBuf, 0, OutBuf, 0, len);
    }

    public static void Decrypt(byte[] InBuf, Object Key2, byte[] OutBuf) {
        int len = 0;
        switch (((int[][])Key2).length) {
            case 11: {
                len = 16;
                break;
            }
            case 13: {
                len = 24;
                break;
            }
            case 15: {
                len = 32;
            }
        }
        AESEncryptor.blockDecrypt(Key2, InBuf, 0, OutBuf, 0, len);
    }

    static {
        int t;
        int i;
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        shifts = new int[][][]{new int[][]{{0, 0}, {1, 3}, {2, 2}, {3, 1}}, new int[][]{{0, 0}, {1, 5}, {2, 4}, {3, 3}}, new int[][]{{0, 0}, {1, 7}, {3, 5}, {4, 4}}};
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        long time = System.currentTimeMillis();
        int ROOT = 283;
        int j = 0;
        AESEncryptor.alog[0] = 1;
        for (i = 1; i < 256; ++i) {
            j = alog[i - 1] << 1 ^ alog[i - 1];
            if ((j & 0x100) != 0) {
                j ^= ROOT;
            }
            AESEncryptor.alog[i] = j;
        }
        for (i = 1; i < 255; ++i) {
            AESEncryptor.log[AESEncryptor.alog[i]] = i;
        }
        byte[][] A = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] B = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] box = new byte[256][8];
        box[1][7] = 1;
        for (i = 2; i < 256; ++i) {
            j = alog[255 - log[i]];
            for (t = 0; t < 8; ++t) {
                box[i][t] = (byte)(j >>> 7 - t & 1);
            }
        }
        byte[][] cox = new byte[256][8];
        for (i = 0; i < 256; ++i) {
            for (t = 0; t < 8; ++t) {
                cox[i][t] = B[t];
                for (j = 0; j < 8; ++j) {
                    byte[] byArray = cox[i];
                    int n = t;
                    byArray[n] = (byte)(byArray[n] ^ A[t][j] * box[i][j]);
                }
            }
        }
        for (i = 0; i < 256; ++i) {
            AESEncryptor.S[i] = (byte)(cox[i][0] << 7);
            for (t = 1; t < 8; ++t) {
                int n = i;
                S[n] = (byte)(S[n] ^ cox[i][t] << 7 - t);
            }
            AESEncryptor.Si[AESEncryptor.S[i] & 0xFF] = (byte)i;
        }
        byte[][] G = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] AA = new byte[4][8];
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                AA[i][j] = G[i][j];
            }
            AA[i][i + 4] = 1;
        }
        byte[][] iG = new byte[4][4];
        for (i = 0; i < 4; ++i) {
            byte pivot = AA[i][i];
            if (pivot == 0) {
                for (t = i + 1; AA[t][i] == 0 && t < 4; ++t) {
                }
                if (t == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                for (j = 0; j < 8; ++j) {
                    byte tmp = AA[i][j];
                    AA[i][j] = AA[t][j];
                    AA[t][j] = tmp;
                }
                pivot = AA[i][i];
            }
            for (j = 0; j < 8; ++j) {
                if (AA[i][j] == 0) continue;
                AA[i][j] = (byte)alog[(255 + log[AA[i][j] & 0xFF] - log[pivot & 0xFF]) % 255];
            }
            for (t = 0; t < 4; ++t) {
                if (i == t) continue;
                for (j = i + 1; j < 8; ++j) {
                    byte[] byArray = AA[t];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] ^ AESEncryptor.mul(AA[i][j], AA[t][i]));
                }
                AA[t][i] = 0;
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                iG[i][j] = AA[i][j + 4];
            }
        }
        for (t = 0; t < 256; ++t) {
            byte s = S[t];
            AESEncryptor.T1[t] = AESEncryptor.mul4(s, G[0]);
            AESEncryptor.T2[t] = AESEncryptor.mul4(s, G[1]);
            AESEncryptor.T3[t] = AESEncryptor.mul4(s, G[2]);
            AESEncryptor.T4[t] = AESEncryptor.mul4(s, G[3]);
            s = Si[t];
            AESEncryptor.T5[t] = AESEncryptor.mul4(s, iG[0]);
            AESEncryptor.T6[t] = AESEncryptor.mul4(s, iG[1]);
            AESEncryptor.T7[t] = AESEncryptor.mul4(s, iG[2]);
            AESEncryptor.T8[t] = AESEncryptor.mul4(s, iG[3]);
            AESEncryptor.U1[t] = AESEncryptor.mul4(t, iG[0]);
            AESEncryptor.U2[t] = AESEncryptor.mul4(t, iG[1]);
            AESEncryptor.U3[t] = AESEncryptor.mul4(t, iG[2]);
            AESEncryptor.U4[t] = AESEncryptor.mul4(t, iG[3]);
        }
        AESEncryptor.rcon[0] = 1;
        int r = 1;
        t = 1;
        while (t < 30) {
            int n = t++;
            r = AESEncryptor.mul(2, r);
            AESEncryptor.rcon[n] = (byte)r;
        }
        long l = System.currentTimeMillis() - time;
    }
}

