/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCEncryption;

import java.security.InvalidKeyException;
import java.util.Hashtable;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCBaseEncryption;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;
import org.eldos.MsgConnect.MCEncryption.AESEncryptor;

public class MCAESEncryption
extends MCBaseEncryption {
    private static final int DATA_BLOCK = 16;
    private Hashtable enckeys = new Hashtable();
    private Hashtable deckeys = new Hashtable();
    private Object defaultEncKey = null;
    private Object defaultDecKey = null;

    @Override
    public int getID() {
        return 1;
    }

    public void clearKeys() {
        this.enckeys.clear();
        this.deckeys.clear();
    }

    Object findEncKeyRecord(String remote) {
        return this.enckeys.get(remote);
    }

    Object findDecKeyRecord(String remote) {
        return this.deckeys.get(remote);
    }

    public void setKey(String remote, byte[] value) throws EMCError {
        boolean emptyRemote;
        Object enckey = null;
        Object deckey = null;
        if (value == null || value.length != 16 && value.length != 24 && value.length != 32) {
            throw new EMCError(14);
        }
        try {
            enckey = AESEncryptor.expandKeyForEncryption(value);
            deckey = AESEncryptor.expandKeyForDecryption(value);
        }
        catch (InvalidKeyException e) {
            throw new EMCError(14);
        }
        boolean bl = null != remote ? remote.length() == 0 : (emptyRemote = false);
        if (!emptyRemote) {
            this.enckeys.remove(remote);
            this.enckeys.put(remote, enckey);
            this.deckeys.remove(remote);
            this.deckeys.put(remote, deckey);
        } else {
            this.defaultEncKey = enckey;
            this.defaultDecKey = deckey;
        }
    }

    @Override
    public boolean encrypt(String remote, MCMessageDataHolder data) {
        int i;
        if (data.getDataSize() == 0) {
            return false;
        }
        Object enckey = this.findEncKeyRecord(remote);
        if (enckey == null) {
            enckey = this.defaultEncKey;
        }
        if (enckey == null) {
            return false;
        }
        byte[] inData = data.getData();
        int outDataSize = inData.length & 0xFFFFFFF0;
        if ((inData.length & 0xF) != 0) {
            outDataSize += 16;
        }
        byte[] outData = new byte[outDataSize += 8];
        byte[] inBuf = new byte[16];
        for (i = 0; i < 4; ++i) {
            outData[i] = (byte)(outDataSize >>> i * 8);
        }
        for (i = 0; i < 4; ++i) {
            outData[i + 4] = (byte)(inData.length >>> i * 8);
        }
        int framesCount = outDataSize / 16 - 1;
        byte[] outBuf = new byte[16];
        for (int i2 = 0; i2 <= framesCount; ++i2) {
            int j;
            if (i2 == framesCount) {
                int lastData = inData.length & 0xF;
                if (lastData == 0) {
                    lastData = 16;
                }
                for (int j2 = 0; j2 < lastData; ++j2) {
                    inBuf[j2] = inData[i2 * 16 + j2];
                }
            } else {
                for (j = 0; j < 16; ++j) {
                    inBuf[j] = inData[i2 * 16 + j];
                }
            }
            AESEncryptor.Encrypt(inBuf, enckey, outBuf);
            for (j = 0; j < 16; ++j) {
                outData[8 + i2 * 16 + j] = outBuf[j];
            }
        }
        data.setData(outData);
        return true;
    }

    @Override
    public boolean decrypt(String remote, MCMessageDataHolder data) {
        if (data.getDataSize() % 16 != 8) {
            return false;
        }
        Object deckey = this.findDecKeyRecord(remote);
        if (deckey == null) {
            deckey = this.defaultDecKey;
        }
        if (deckey == null) {
            return false;
        }
        byte[] inData = data.getData();
        int inDataSize = 0;
        for (int i = 0; i < 4; ++i) {
            int t = inData[i] & 0xFF;
            inDataSize |= t << i * 8;
        }
        if (inDataSize != inData.length) {
            return false;
        }
        int outDataSize = 0;
        for (int i = 0; i < 4; ++i) {
            int t = inData[i + 4] & 0xFF;
            outDataSize |= t << i * 8;
        }
        byte[] outData = new byte[outDataSize];
        int framesCount = inDataSize / 16 - 1;
        byte[] outBuf = new byte[16];
        byte[] inBuf = new byte[16];
        for (int i = 0; i <= framesCount; ++i) {
            int j;
            for (j = 0; j < 16; ++j) {
                inBuf[j] = inData[8 + i * 16 + j];
            }
            AESEncryptor.Decrypt(inBuf, deckey, outBuf);
            if (i == framesCount) {
                int lastData = outDataSize & 0xF;
                if (lastData == 0) {
                    lastData = 16;
                }
                for (j = 0; j < lastData; ++j) {
                    outData[i * 16 + j] = outBuf[j];
                }
                continue;
            }
            for (j = 0; j < 16; ++j) {
                outData[i * 16 + j] = outBuf[j];
            }
        }
        data.setData(outData);
        return true;
    }
}

