/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCStream;

public class MCFileStream
extends MCStream {
    protected RandomAccessFile fileAccess = null;
    protected File file = null;

    public MCFileStream(File obj) throws FileNotFoundException {
        this.file = obj;
        this.fileAccess = new RandomAccessFile(this.file, "rw");
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException {
        this.fileAccess.write(data, offset, len);
    }

    @Override
    public int read(byte[] data, int offset, int len) throws IOException {
        return this.fileAccess.read(data, offset, len);
    }

    @Override
    public int getLength() {
        try {
            return (int)this.fileAccess.length();
        }
        catch (IOException e) {
            MCGlobals.DEBUG_STACKTRACE(e);
            return -1;
        }
    }

    @Override
    public void setPosition(int pos) {
        try {
            this.fileAccess.seek(pos);
        }
        catch (IOException e) {
            MCGlobals.DEBUG_STACKTRACE(e);
        }
    }

    @Override
    public int getPosition() {
        try {
            return (int)this.fileAccess.getFilePointer();
        }
        catch (IOException e) {
            MCGlobals.DEBUG_STACKTRACE(e);
            return -1;
        }
    }

    @Override
    public void close() {
        try {
            if (null != this.fileAccess) {
                this.fileAccess.close();
            }
            if (null != this.file) {
                this.file.delete();
            }
            this.fileAccess = null;
            this.file = null;
        }
        catch (IOException e) {
            MCGlobals.DEBUG_STACKTRACE(e);
        }
    }
}

