/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCHttpSocket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCHttpSocket.MCHttpConnectionEntry;
import org.eldos.MsgConnect.MCHttpSocket.MCHttpTransportJob;
import org.eldos.MsgConnect.MCSocket.MCInetConnectionEntry;
import org.eldos.MsgConnect.MCSocket.MCInetTransport;
import org.eldos.MsgConnect.MCSocket.MCInetTransportJob;

public class MCHttpTransport
extends MCInetTransport {
    protected boolean fUseProxy = false;
    protected int fProxyPort = 3128;
    protected String fProxyAddress = null;
    protected InetAddress fProxyIP = null;
    protected long reqTime = 1000L;

    public MCHttpTransport() {
        this.defaultTransportName = "HTTP";
    }

    @Override
    protected MCInetTransportJob createTransportJob() {
        MCHttpTransportJob trans = new MCHttpTransportJob();
        trans.adjustBufferSize(this.incomingBufferSize, this.outgoingBufferSize);
        trans.adjustSpeedLimits(this.incomingSpeedLimit, this.outgoingSpeedLimit);
        return trans;
    }

    @Override
    protected boolean needLiveConnectionForDelivery() {
        return false;
    }

    @Override
    protected MCInetConnectionEntry createConnectionEntry() {
        MCHttpConnectionEntry httpEntry = new MCHttpConnectionEntry();
        httpEntry.setProxyIP(this.fProxyIP);
        httpEntry.setProxyPort(this.fProxyPort);
        httpEntry.setUseProxy(this.fUseProxy);
        return httpEntry;
    }

    @Override
    public void doSetActive() {
        super.doSetActive();
        if (this.getActive()) {
            try {
                if (this.fUseProxy && this.fProxyAddress != null) {
                    this.fProxyIP = InetAddress.getByName(this.fProxyAddress);
                }
            }
            catch (UnknownHostException e) {
                MCGlobals.DEBUG_PRINTLN(e.toString());
            }
        }
    }

    public boolean getUseProxy() {
        return this.fUseProxy;
    }

    public void setUseProxy(boolean useProxy) {
        if (useProxy && !this.fUseProxy) {
            try {
                if (this.fUseProxy && this.fProxyAddress != null) {
                    this.fProxyIP = InetAddress.getByName(this.fProxyAddress);
                }
            }
            catch (UnknownHostException e) {
                MCGlobals.DEBUG_PRINTLN(e.toString());
            }
        }
        this.fUseProxy = useProxy;
    }

    @Override
    protected long getDeliveryInterval() {
        return this.reqTime;
    }

    public long getRequestTime() {
        return this.reqTime;
    }

    public void setRequestTime(long reqTime) {
        this.reqTime = reqTime;
    }

    public int getProxyPort() {
        return this.fProxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.fProxyPort = proxyPort;
    }

    public String getProxyAddress() {
        return this.fProxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.fProxyAddress = proxyAddress;
    }
}

