/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCHttpSocket;

import java.io.IOException;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCFileStream;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCHttpSocket.MCHttpConnectionEntry;
import org.eldos.MsgConnect.MCHttpSocket.MCHttpTransport;
import org.eldos.MsgConnect.MCMemStream;
import org.eldos.MsgConnect.MCRemoteAddress;
import org.eldos.MsgConnect.MCSock.MCSocket;
import org.eldos.MsgConnect.MCSocket.MCInetTransport;
import org.eldos.MsgConnect.MCSocket.MCInetTransportJob;
import org.eldos.MsgConnect.MCStream;

public class MCHttpTransportJob
extends MCInetTransportJob {
    protected int headerRead = 0;
    protected int alreadyReceived = -1;
    protected String httpURL = null;
    protected String hostName = null;
    protected boolean postFound = false;
    protected int contentLength = 0;
    protected int httpCode = 0;
    protected int headerSent = 0;
    protected int headerSize = 0;
    protected int sendingStage = 0;
    protected long lastRequestTime = 0L;
    private final String HTTPPostFormatString1 = "POST {0} HTTP/1.1\r\nHost: {1}\r\nUser-Agent: MsgConnect\r\n";
    private final String HTTPPostFormatString2 = "Content-Length: {0}\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nContent-Type: application/octet-stream\r\n\r\n";
    private final int ssHeader = 0;
    private final int ssBody = 1;
    private static final int MAX_HEADER_SIZE = 4096;

    @Override
    protected boolean postConnectionStep() {
        return true;
    }

    @Override
    protected void updateConnectionContext() {
        if (this.entry.getInfo() != null) {
            ((MCHttpConnectionEntry)this.entry).setURL(this.entry.getInfo().getUrlPart());
        }
    }

    @Override
    protected void setTransporterAddress() throws EMCError {
        MCHttpConnectionEntry httpEntry = (MCHttpConnectionEntry)this.entry;
        MCSocket socket = this.transporter;
        if (httpEntry.getUseProxy()) {
            socket.setRemoteAddress(httpEntry.getProxyIP().getHostAddress());
            socket.setRemotePort(httpEntry.getProxyPort());
        } else {
            MCRemoteAddress remAddr = new MCRemoteAddress();
            if (MCInetTransport.parseRemoteAddr(httpEntry.getRemoteAddress(), remAddr)) {
                socket.setRemoteAddress(remAddr.getIP());
                socket.setRemotePort(remAddr.getPort());
            }
        }
    }

    @Override
    public boolean messageReceivedCompletely2() {
        boolean result = super.messageReceivedCompletely2();
        if (result) {
            this.alreadyReceived = -1;
            this.headerRead = 0;
        }
        return result;
    }

    protected boolean needClose() {
        if (this.getSending()) {
            return false;
        }
        this.alreadyReceived = -1;
        this.headerRead = 0;
        return true;
    }

    protected void resetTransfer() {
    }

    protected int clientBuildHTTPHeader() {
        MCRemoteAddress remAddr = new MCRemoteAddress();
        MCInetTransport.parseRemoteAddr(this.entry.getRemoteAddress(), remAddr);
        StringBuffer result = new StringBuffer("POST ");
        MCHttpConnectionEntry httpEntry = (MCHttpConnectionEntry)this.entry;
        result.append("http://");
        result.append(remAddr.getIP());
        result.append(":");
        result.append(remAddr.getPort());
        result.append("/");
        if (httpEntry.getURL() != null) {
            result.append(httpEntry.getURL());
        }
        result.append(" HTTP/1.1\r\n");
        result.append("Host: ");
        result.append(remAddr.getIP());
        result.append("\r\n");
        result.append("User-Agent: MsgConnect\r\n");
        result.append("Content-Length: ");
        result.append(httpEntry.getContentLength());
        result.append("\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nContent-Type: application/octet-stream\r\n\r\n");
        byte[] header = result.toString().getBytes();
        System.arraycopy(header, 0, this.outgoingBuffer, 0, header.length);
        return header.length;
    }

    protected int serverBuildHTTPHeader() {
        StringBuffer result = new StringBuffer();
        MCHttpConnectionEntry httpEntry = (MCHttpConnectionEntry)this.entry;
        result.append("HTTP/1.0 200 OK\r\n");
        result.append("Content-Type: application/octet-stream\r\n");
        result.append("Content-Length: ");
        result.append(httpEntry.getContentLength());
        result.append("\r\n");
        result.append("X-Request-Time: ");
        result.append((int)((MCHttpTransport)this.owner).getRequestTime());
        result.append("\r\n\r\n");
        byte[] header = result.toString().getBytes();
        System.arraycopy(header, 0, this.outgoingBuffer, 0, header.length);
        return header.length;
    }

    @Override
    protected boolean sendData() {
        int toSend = 0;
        int sent = 0;
        boolean res = true;
        if (this.getSending()) {
            block15: {
                this.entry.getCS().enter();
                try {
                    MCStream is;
                    if (this.sendingStage == 0) {
                        if (this.headerSent == 0) {
                            try {
                                ((MCHttpConnectionEntry)this.entry).setContentLength(this.entry.getOutgoingStream().getLength());
                            }
                            catch (Exception e) {
                                MCGlobals.DEBUG_STACKTRACE(e);
                            }
                            this.headerSize = this.entry.getInfo().getOldState() == 1 || this.entry.getInfo().getOldState() == 6 ? this.clientBuildHTTPHeader() : this.serverBuildHTTPHeader();
                        }
                        toSend = this.headerSize - this.headerSent;
                        try {
                            sent = this.transporter.send(this.outgoingBuffer, this.headerSent, toSend);
                            this.transporter.flush();
                            this.blOutSessionTransferred += (long)sent;
                            this.blOutMsgTransferred += (long)sent;
                            this.blOutSecTransferred += (long)sent;
                        }
                        catch (Exception e) {
                            res = false;
                            sent = 0;
                        }
                        this.headerSent += sent;
                        if (this.headerSent == this.headerSize) {
                            this.sendingStage = 1;
                            this.headerSent = 0;
                            this.headerSize = 0;
                        }
                        break block15;
                    }
                    if (this.sendingStage == 1 && (is = this.entry.getOutgoingStream()).getLength() > 0) {
                        toSend = is.getLength() - is.getPosition();
                        if (toSend > this.blToSend) {
                            toSend = this.blToSend;
                        }
                        is.read(this.outgoingBuffer, 0, toSend);
                        sent = this.transporter.send(this.outgoingBuffer, 0, toSend);
                        this.transporter.flush();
                        if (sent > 0) {
                            this.blOutSessionTransferred += (long)sent;
                            this.blOutMsgTransferred += (long)sent;
                            this.blOutSecTransferred += (long)sent;
                        }
                        if (toSend != sent) {
                            is.setPosition(is.getPosition() - toSend + sent);
                        }
                        if (this.entry.getOutgoingStream().getPosition() == this.entry.getOutgoingStream().getLength()) {
                            this.sendingStage = 0;
                        }
                    }
                }
                catch (Exception e) {
                    MCGlobals.DEBUG_STACKTRACE(e);
                    res = false;
                }
            }
            this.entry.getCS().leave();
        }
        return res;
    }

    protected boolean parseHeaders(String headers, StringBuffer URL2, StringBuffer host) {
        boolean res = true;
        int headerStart = 0;
        int headerEnd = headers.indexOf("\r\n");
        this.postFound = false;
        this.contentLength = 0;
        this.httpCode = 0;
        try {
            while (headerEnd != -1 && headerEnd != headers.length() - 2) {
                int spaceP = headers.indexOf(" ", headerStart);
                if (spaceP == -1 && spaceP > headerEnd) {
                    return false;
                }
                String headerName = headers.substring(headerStart, spaceP).toUpperCase();
                String headerValue = headers.substring(spaceP + 1, headerEnd).trim();
                if (headerName.regionMatches(true, 0, "POST", 0, "POST".length())) {
                    int spaceP2 = headerValue.indexOf(" ");
                    if (-1 != spaceP2) {
                        URL2.append(headerValue.substring(0, spaceP2));
                        this.postFound = true;
                    }
                } else if (headerName.regionMatches(true, 0, "HOST:", 0, "HOST:".length())) {
                    host.append(headerValue);
                } else if (headerName.length() > 4 && headerName.regionMatches(false, 0, "HTTP", 0, 4)) {
                    this.httpCode = Integer.decode(headerValue.substring(0, 3));
                } else if (headerName.compareTo("CONTENT-LENGTH:") == 0) {
                    this.contentLength = Integer.parseInt(headerValue);
                } else if (headerName.compareTo("X-REQUEST-TIME:") == 0) {
                    this.serverRequestTime = Integer.parseInt(headerValue);
                }
                headerStart = headerEnd + 2;
                headerEnd = headers.indexOf("\r\n", headerStart);
            }
        }
        catch (Exception e) {
            MCGlobals.DEBUG_STACKTRACE(e);
            MCGlobals.DEBUG_PRINTLN(headers);
        }
        return true;
    }

    protected int makeIntFromBytes(byte[] data, int offset) {
        int arg0 = data[offset + 0] < 0 ? data[offset + 0] & 0xFF : data[offset + 0];
        int arg1 = data[offset + 1] < 0 ? data[offset + 0] & 0xFF : data[offset + 1];
        int arg2 = data[offset + 2] < 0 ? data[offset + 0] & 0xFF : data[offset + 2];
        int arg3 = data[offset + 3] < 0 ? data[offset + 0] & 0xFF : data[offset + 3];
        return arg0 + (arg1 << 8) + (arg2 << 16) + (arg3 << 24);
    }

    protected int isHttpHeaderRead(String buffer) {
        return buffer.indexOf("\r\n\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected boolean receiveData() {
        block23: {
            block28: {
                block27: {
                    block26: {
                        block24: {
                            block25: {
                                res = false;
                                received = 0;
                                host = new StringBuffer();
                                URL = new StringBuffer();
                                this.entry.getCS().enter();
                                if (this.getReceiving()) ** GOTO lbl83
                                this.entry.setMsgSize(0);
                                received = this.transporter.receive(this.incomingBuffer, this.headerRead, this.incomingBufferSize - this.headerRead);
                                this.blInSessionTransferred += (long)received;
                                this.blInMsgTransferred += (long)received;
                                this.blInSecTransferred += (long)received;
                                this.headerRead = received += this.headerRead;
                                if (received <= 0) break block23;
                                httpHeader = new String(this.incomingBuffer, 0, this.headerRead, "us-ascii");
                                headerSize = this.isHttpHeaderRead(httpHeader);
                                if (headerSize > 0) break block24;
                                if (headerSize <= 4096 && headerSize != 0) break block25;
                                res = false;
                                this.alreadyReceived = -1;
                                this.setReceiving(false);
                                var7_10 = res;
                                this.entry.getCS().leave();
                                return var7_10;
                            }
                            var7_11 = true;
                            this.entry.getCS().leave();
                            return var7_11;
                        }
                        if (this.parseHeaders(httpHeader.substring(0, headerSize + 4), URL, host)) break block26;
                        res = false;
                        this.alreadyReceived = -1;
                        this.setReceiving(false);
                        var7_12 = res;
                        this.entry.getCS().leave();
                        return var7_12;
                    }
                    if (this.postFound || 200 == this.httpCode) break block27;
                    res = false;
                    this.alreadyReceived = -1;
                    this.setReceiving(false);
                    var7_13 = res;
                    this.entry.getCS().leave();
                    return var7_13;
                }
                if (this.owner.getMaxMsgSize() == 0 || this.contentLength <= this.owner.getMaxMsgSize()) break block28;
                res = false;
                this.alreadyReceived = -1;
                this.headerRead = 0;
                this.setReceiving(false);
                var7_14 = res;
                this.entry.getCS().leave();
                return var7_14;
            }
            try {
                try {
                    this.entry.setMsgSize(this.contentLength);
                    useMem = true;
                    if (this.owner.getUseTempFilesForIncoming() && (long)this.entry.getMsgSize() > this.owner.getIncomingMemoryThreshold()) {
                        try {
                            this.entry.setIncomingStream(new MCFileStream(this.createTempFile()));
                            useMem = false;
                        }
                        catch (IOException e) {
                            MCGlobals.DEBUG_STACKTRACE(e);
                        }
                    }
                    if (useMem) {
                        this.entry.setIncomingStream(new MCMemStream());
                    }
                    this.setReceiving(true);
                    offset = headerSize + 4;
                    remains = received - offset;
                    if (remains > this.contentLength) {
                        remains = this.contentLength;
                    }
                    if (0 != remains) {
                        this.entry.getIncomingStream().write(this.incomingBuffer, offset, remains);
                    }
                    if (received > (offset += remains)) {
                        this.transporter.returnData(this.incomingBuffer, offset, received - offset);
                    }
                    res = true;
                    break block23;
lbl83:
                    // 1 sources

                    this.alreadyReceived = -1;
                    this.headerRead = 0;
                    toRecv = this.entry.getMsgSize() - this.entry.getIncomingStream().getLength();
                    if (toRecv > (long)this.blToRecv) {
                        toRecv = this.blToRecv;
                    }
                    try {
                        this.lastReceived = received = this.transporter.receive(this.incomingBuffer, 0, (int)toRecv);
                        this.blInSessionTransferred += (long)received;
                        this.blInMsgTransferred += (long)received;
                        this.blInSecTransferred += (long)received;
                    }
                    catch (Exception e) {
                        MCGlobals.DEBUG_STACKTRACE(e);
                    }
                    if (received > 0) {
                        this.entry.getIncomingStream().write(this.incomingBuffer, 0, received);
                        res = true;
                        break block23;
                    }
                    res = false;
                }
                catch (Exception e) {
                    MCGlobals.DEBUG_STACKTRACE(e);
                }
            }
            catch (Exception e) {
                MCGlobals.DEBUG_STACKTRACE(e);
            }
            catch (Throwable var10_20) {
                throw var10_20;
            }
            finally {
                this.entry.getCS().leave();
            }
        }
        return res;
    }

    @Override
    protected boolean initializeConnection() {
        if (super.initializeConnection()) {
            this.sendingStage = 0;
            this.lastRequestTime = System.currentTimeMillis();
            this.serverRequestTime = 1000;
            this.headerSent = 0;
            this.headerRead = 0;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isRequestNeeded() {
        if (this.transporter.getDirection() == 1) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long lastRequest = Math.min(currentTime - this.lastRequestTime, currentTime - this.lastMsgRecvTime);
        if (lastRequest > (long)this.serverRequestTime) {
            boolean ret = true;
            this.entry.getCS().enter();
            try {
                if (this.getSending() || this.getMessageForDelivery() != null) {
                    ret = false;
                }
            }
            finally {
                this.entry.getCS().leave();
            }
            this.lastRequestTime = currentTime;
            return ret;
        }
        return false;
    }

    @Override
    protected void changeLastSendTime(int state) {
        if (state != 6 && state != 7) {
            this.activityTime = this.lastMsgSendTime = System.currentTimeMillis();
            MCGlobals.DEBUG_PRINTLN("Last message with state " + state + " sent at " + this.lastMsgSendTime);
        } else {
            this.activityTime = Math.max(this.lastMsgSendTime, this.lastMsgRecvTime);
            MCGlobals.DEBUG_PRINTLN("ActivityTime reset to " + this.activityTime);
        }
    }

    @Override
    protected void changeLastRecvTime(int state) {
        if (state != 6 && state != 7) {
            this.activityTime = this.lastMsgRecvTime = System.currentTimeMillis();
            MCGlobals.DEBUG_PRINTLN("Last message with state " + state + " received at " + this.lastMsgSendTime);
        } else {
            this.activityTime = Math.max(this.lastMsgSendTime, this.lastMsgRecvTime);
            MCGlobals.DEBUG_PRINTLN("ActivityTime reset to " + this.activityTime);
        }
    }
}

