/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect;

public class MCMutex {
    protected Thread owner_ = null;
    protected long holds_ = 0L;

    public void enter() {
        try {
            this.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void leave() {
        try {
            this.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.owner_ == Thread.currentThread()) {
            ++this.holds_;
        } else {
            while (this.owner_ != null) {
                this.wait();
            }
            this.owner_ = Thread.currentThread();
            this.holds_ = 1L;
        }
    }

    public synchronized boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.owner_ == Thread.currentThread()) {
            ++this.holds_;
            return true;
        }
        if (this.owner_ == null) {
            this.owner_ = Thread.currentThread();
            this.holds_ = 1L;
            return true;
        }
        if (msecs <= 0L) {
            return false;
        }
        long waitTime = msecs;
        long start = System.currentTimeMillis();
        do {
            this.wait(waitTime);
            if (this.owner_ == Thread.currentThread()) {
                ++this.holds_;
                return true;
            }
            if (this.owner_ != null) continue;
            this.owner_ = Thread.currentThread();
            this.holds_ = 1L;
            return true;
        } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.owner_) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.owner_ || n > this.holds_) {
            throw new Error("Illegal Lock usage");
        }
        this.holds_ -= n;
        if (this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }
}

