/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSealing;

import org.eldos.MsgConnect.MCBase.MCBaseSealing;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;

public class MCAdlerSealing
extends MCBaseSealing {
    private static final int ADLER_PRIME = 65521;

    @Override
    public int getID() {
        return 1;
    }

    @Override
    protected boolean seal(String remote, MCMessageDataHolder data) {
        int i;
        if (data.getDataSize() == 0) {
            return false;
        }
        byte[] inData = data.getData();
        byte[] outData = new byte[data.getDataSize() + 4];
        int j = this.adlerBuffer(1, inData, 0, inData.length);
        for (i = 0; i < 4; ++i) {
            outData[i] = (byte)(j >>> i * 8);
        }
        for (i = 0; i < data.getDataSize(); ++i) {
            outData[i + 4] = inData[i];
        }
        data.setData(outData);
        return true;
    }

    @Override
    protected boolean unseal(String remote, MCMessageDataHolder data) {
        if (data.getDataSize() < 5) {
            return false;
        }
        byte[] inData = data.getData();
        int j = this.adlerBuffer(1, inData, 4, inData.length - 4);
        int firstInt = 0;
        for (int i = 0; i < 4; ++i) {
            int t = inData[i] & 0xFF;
            firstInt |= t << i * 8;
        }
        if (firstInt != j) {
            return false;
        }
        byte[] outData = new byte[inData.length - 4];
        for (int i = 0; i < inData.length - 4; ++i) {
            outData[i] = inData[i + 4];
        }
        data.setData(outData);
        return true;
    }

    private int adler(int c, byte b) {
        int bInt = b & 0xFF;
        int i1 = ((c & 0xFFFF) + bInt) % 65521;
        int i2 = ((c >>> 16 & 0xFFFF) + i1) % 65521;
        return (i2 << 16) + i1;
    }

    private int adlerBuffer(int initialAdler, byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            initialAdler = this.adler(initialAdler, buffer[i + offset]);
        }
        return initialAdler;
    }
}

