/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSealing;

import org.eldos.MsgConnect.MCBase.MCBaseSealing;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;

public class MCCRC32Sealing
extends MCBaseSealing {
    private static int CRC32_POLYNOM = 0;
    private static int CRC32_POLYNOM_INIT = -306674912;
    public static int CRC32_POLYNOMIAL = 0;
    private static boolean CRCTableBuilt = false;
    private static int[] ccitt32Table = new int[256];

    public MCCRC32Sealing() {
        CRCTableBuilt = false;
        CRC32_POLYNOMIAL = CRC32_POLYNOM;
        CRC32_POLYNOMIAL = CRC32_POLYNOM_INIT;
    }

    private static void buildCRCTable() {
        int value = 0;
        for (int i = 0; i < 256; ++i) {
            value = i;
            for (int j = 8; j > 0; --j) {
                if ((value & 1) != 0) {
                    value = value >>> 1 ^ CRC32_POLYNOMIAL;
                    continue;
                }
                value >>>= 1;
            }
            MCCRC32Sealing.ccitt32Table[i] = value;
        }
        CRCTableBuilt = true;
    }

    private static int crc32(int crc, byte c) {
        return crc >>> 8 & 0xFFFFFF ^ ccitt32Table[(crc ^ c & 0xFF) & 0xFF];
    }

    public static int crcBuffer(int initialCRC, byte[] buffer, int offset, int length) {
        if (!CRCTableBuilt) {
            MCCRC32Sealing.buildCRCTable();
        }
        for (int i = 0; i < length; ++i) {
            initialCRC = MCCRC32Sealing.crc32(initialCRC, buffer[i + offset]);
        }
        return initialCRC;
    }

    @Override
    public int getID() {
        return 3;
    }

    @Override
    protected boolean seal(String remote, MCMessageDataHolder data) {
        int i;
        if (data.getDataSize() == 0) {
            return false;
        }
        byte[] inData = data.getData();
        byte[] outData = new byte[data.getDataSize() + 4];
        int j = MCCRC32Sealing.crcBuffer(1, inData, 0, inData.length);
        for (i = 0; i < 4; ++i) {
            outData[i] = (byte)(j >>> i * 8);
        }
        for (i = 0; i < data.getDataSize(); ++i) {
            outData[i + 4] = inData[i];
        }
        data.setData(outData);
        return true;
    }

    @Override
    protected boolean unseal(String remote, MCMessageDataHolder data) {
        if (data.getDataSize() < 5) {
            return false;
        }
        byte[] inData = data.getData();
        int j = MCCRC32Sealing.crcBuffer(1, inData, 4, inData.length - 4);
        int firstInt = 0;
        for (int i = 0; i < 4; ++i) {
            int t = inData[i] & 0xFF;
            firstInt |= t << i * 8;
        }
        if (firstInt != j) {
            return false;
        }
        byte[] outData = new byte[inData.length - 4];
        for (int i = 0; i < inData.length - 4; ++i) {
            outData[i] = inData[i + 4];
        }
        data.setData(outData);
        return true;
    }
}

