/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect;

public class MCSemaphore {
    protected long permits;

    public MCSemaphore(long initialPermits) {
        this.permits = initialPermits;
    }

    public synchronized void release() {
        ++this.permits;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        MCSemaphore mCSemaphore = this;
        synchronized (mCSemaphore) {
            try {
                while (this.permits <= 0L) {
                    this.wait();
                }
                --this.permits;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        MCSemaphore mCSemaphore = this;
        synchronized (mCSemaphore) {
            if (this.permits > 0L) {
                --this.permits;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            try {
                long now;
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                do {
                    this.wait(waitTime);
                    if (this.permits <= 0L) continue;
                    --this.permits;
                    return true;
                } while ((waitTime = msecs - ((now = System.currentTimeMillis()) - startTime)) > 0L);
                return false;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }
}

