/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSock;

import org.eldos.MsgConnect.MCBase.EMCError;

public class EMCSockError
extends EMCError {
    public static final int MCError_NotASocket = 201;
    public static final int MCError_WrongSocketState = 202;
    public static final int MCError_SockInitFailed = 203;
    public static final int MCError_InvalidAddress = 204;
    public static final int MCError_ConnectionFailed = 205;
    public static final int MCError_ConnectionLost = 206;
    public static final int MCError_InvalidLocalPort = 207;
    public static final int MCError_InvalidRemotePort = 208;
    public static final int MCError_WrongSocketType = 209;

    public EMCSockError(int errorCode) {
        super(EMCSockError.getMessageFromErrorCode(errorCode));
        this.errorCode = errorCode;
    }

    public EMCSockError(String msg) {
        super(msg);
    }

    protected static String getMessageFromErrorCode(int errorCode) {
        String result = null;
        switch (errorCode) {
            case 201: {
                result = "Operation called on invalid socket.";
                break;
            }
            case 202: {
                result = "Socket is in state that is not acceptable for current operation.";
                break;
            }
            case 203: {
                result = "Failed to initialize socket.";
                break;
            }
            case 204: {
                result = "Invalid address specified.";
                break;
            }
            case 205: {
                result = "Connection failed.";
                break;
            }
            case 206: {
                result = "Connection to remote host was lost.";
                break;
            }
            case 207: {
                result = "Invalid local port specified.";
                break;
            }
            case 208: {
                result = "Invalid remote port specified.";
                break;
            }
            case 209: {
                result = "Wrong socket type.";
                break;
            }
            default: {
                result = EMCError.getMessageFromErrorCode(errorCode);
            }
        }
        return result;
    }
}

