/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSock;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCReturnedDataBuffer;

public abstract class MCSocket {
    public static final int DATAGRAM_PACKET_SIZE = 512;
    public static final byte isdOutgoing = 0;
    public static final byte isdIncoming = 1;
    public static final byte issNotASocket = 0;
    public static final byte issInitializing = 1;
    public static final byte issInitialized = 2;
    public static final byte issBound = 3;
    public static final byte issConnected = 4;
    public static final byte issListening = 5;
    public static final byte istStream = 1;
    public static final byte istDatagram = 2;
    public static final byte issClient = 0;
    public static final byte issServer = 1;
    public static final int OP_READ = 1;
    public static final int OP_WRITE = 4;
    public static final int OP_ACCEPT = 16;
    public static final byte bpFlexible = 0;
    public static final byte bpStrict = 1;
    public static final byte mcSocksV5 = 5;
    public static final byte mcSocksV4 = 4;
    public static final byte saNoAuthentication = 0;
    public static final byte saUsercode = 1;
    public static final byte wtaNoAuthentication = 0;
    public static final byte wtaRequiresAuthentication = 1;
    protected byte direction = 0;
    protected String localAddress = null;
    protected int localPort = 0;
    protected String remoteAddress = null;
    protected int remotePort = 0;
    protected MulticastSocket datagramSocket = null;
    protected DatagramPacket packet = null;
    protected byte state = 0;
    protected byte socketType = 0;
    protected Selector selector;
    protected SocketChannel socketChannel;
    protected ServerSocketChannel serverSocketChannel;
    protected boolean useSocks = false;
    protected String socksServer = null;
    protected int socksPort = 1080;
    protected byte socksVersion = (byte)5;
    protected byte socksAuth = 0;
    protected String socksUserCode = null;
    protected String socksPassword = null;
    protected boolean useWebTunneling = false;
    protected String webTunnelAddress = null;
    protected int webTunnelPort = 3128;
    protected byte webTunnelAuth = 0;
    protected String webTunnelUserId = null;
    protected String webTunnelPassword = null;
    protected MCReturnedDataBuffer returnedDatabuffer = new MCReturnedDataBuffer();

    public abstract int addToMulticastCli(String var1, byte var2, boolean var3) throws EMCError;

    public abstract int addToMulticastSrv(String var1, String var2) throws EMCError;

    public synchronized boolean available() throws SocketException, IOException, EMCError {
        if (this.serverSocketChannel != null) {
            throw new IllegalStateException();
        }
        if (this.socketChannel != null) {
            if (this.returnedDatabuffer.length() > 0) {
                return true;
            }
            int ret = this.selectNow(1);
            return (ret & 1) != 0;
        }
        if (this.datagramSocket != null) {
            if (this.packet != null) {
                return true;
            }
            int time = this.datagramSocket.getSoTimeout();
            this.datagramSocket.setSoTimeout(10);
            this.packet = new DatagramPacket(new byte[512], 512);
            try {
                this.datagramSocket.receive(this.packet);
                this.datagramSocket.setSoTimeout(time);
                return true;
            }
            catch (InterruptedIOException e) {
                this.packet = null;
                this.datagramSocket.setSoTimeout(time);
                return false;
            }
        }
        throw new IllegalStateException();
    }

    public abstract MCSocket accept() throws EMCError;

    public int afterConnection(int timeout) {
        return 0;
    }

    public abstract void bind() throws EMCError;

    public abstract void close(boolean var1);

    public void connect(int timeout) throws EMCError {
        this.setDirection((byte)0);
    }

    public abstract MCSocket createAcceptingSocket();

    public void finalize() {
        this.close(false);
    }

    public boolean hasBufferedIncomingData() {
        try {
            return this.returnedDatabuffer.length() > 0 || this.available();
        }
        catch (EMCError ex) {
            return false;
        }
        catch (SocketException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean hasBufferedOutgoingData() {
        return false;
    }

    public abstract void init(byte var1, boolean var2) throws EMCError;

    public void init(byte socketType) throws EMCError {
        this.init(socketType, true);
    }

    public void listen(int backLog) throws EMCError {
        this.setDirection((byte)1);
    }

    public boolean preprocessIncomingData() {
        return true;
    }

    public boolean postprocessOutgoingData() {
        return true;
    }

    public int selectNow(int interestOps) throws EMCError, IOException {
        return this.select(interestOps, -1L);
    }

    public int select(int interestOps, long timeout) throws EMCError, IOException {
        if ((interestOps & 1) != 0 && this.returnedDatabuffer.length() > 0) {
            return 1;
        }
        if (this.getSocketType() != 1) {
            throw new EMCError(208);
        }
        for (SelectionKey sk : this.selector.keys()) {
            sk.interestOps(interestOps);
        }
        if (timeout < 0L) {
            this.selector.selectNow();
        } else {
            this.selector.select(timeout);
        }
        int ret = 0;
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey selKey = it.next();
            it.remove();
            if (!selKey.isValid()) continue;
            if (selKey.isAcceptable()) {
                ret |= 0x10;
            }
            if (selKey.isReadable()) {
                ret |= 1;
            }
            if (!selKey.isWritable()) continue;
            ret |= 4;
        }
        return ret;
    }

    public void returnData(byte[] buf, int offset, int length) {
        this.returnedDatabuffer.returnData(buf, offset, length);
    }

    public abstract int receive(byte[] var1, int var2, int var3) throws EMCError;

    public abstract void receive(DatagramPacket var1) throws EMCError;

    public void reusePort() throws SocketException {
        if (this.socketChannel != null) {
            this.socketChannel.socket().setReuseAddress(true);
        }
        if (this.serverSocketChannel != null) {
            this.serverSocketChannel.socket().setReuseAddress(true);
        }
    }

    public abstract int send(byte[] var1, int var2, int var3) throws EMCError;

    public abstract void flush() throws EMCError;

    public abstract void send(DatagramPacket var1) throws EMCError;

    protected void setState(byte state) throws EMCError {
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.state = state;
                return;
            }
        }
        throw new EMCError(202);
    }

    public byte getState() {
        return this.state;
    }

    protected void setDirection(byte direction) {
        if (direction != 0 && direction != 1) {
            throw new IllegalStateException();
        }
        this.direction = direction;
    }

    public byte getDirection() {
        return this.direction;
    }

    public void setLocalAddress(String address) throws EMCError {
        if (this.getState() == 0 || this.getState() == 1 || this.getState() == 2) {
            this.localAddress = address == null ? null : address;
        } else {
            throw new EMCError(202);
        }
    }

    public String getLocalAddress() {
        if (this.state == 4 || this.state == 5) {
            if (this.socketChannel != null) {
                return this.socketChannel.socket().getLocalAddress().getHostAddress();
            }
            if (this.serverSocketChannel != null) {
                return this.serverSocketChannel.socket().getInetAddress().getHostAddress();
            }
            if (this.datagramSocket != null) {
                return this.datagramSocket.getLocalAddress().getHostAddress();
            }
            throw new IllegalStateException();
        }
        return this.localAddress;
    }

    public void setLocalPort(int port) throws EMCError {
        if (this.getState() != 0 && this.getState() != 1 && this.getState() != 2) {
            throw new EMCError(202);
        }
        this.localPort = port;
    }

    public int getLocalPort() {
        if (this.state == 4 || this.state == 5) {
            if (this.socketChannel != null) {
                return this.socketChannel.socket().getLocalPort();
            }
            if (this.serverSocketChannel != null) {
                return this.serverSocketChannel.socket().getLocalPort();
            }
            if (this.datagramSocket != null) {
                return this.datagramSocket.getLocalPort();
            }
        }
        return this.localPort;
    }

    public void setRemoteAddress(String address) throws EMCError {
        if (this.getState() == 0 || this.getState() == 1 || this.getState() == 2) {
            this.remoteAddress = address == null ? null : address;
        } else {
            throw new EMCError(202);
        }
    }

    public String getRemoteAddress() {
        if (this.state == 4) {
            if (this.socketChannel != null) {
                return this.socketChannel.socket().getInetAddress().getHostAddress();
            }
            if (this.datagramSocket != null) {
                return this.datagramSocket.getInetAddress().getHostAddress();
            }
        }
        return this.remoteAddress;
    }

    public void setRemotePort(int port) throws EMCError {
        if (this.getState() != 0 && this.getState() != 1 && this.getState() != 2) {
            throw new EMCError(202);
        }
        this.remotePort = port;
    }

    public int getRemotePort() {
        if (this.state == 4 && this.socketChannel != null) {
            return this.socketChannel.socket().getPort();
        }
        return this.remotePort;
    }

    public boolean getUseSocks() {
        return this.useSocks;
    }

    public void setUseSocks(boolean value) {
        this.useSocks = value;
    }

    public String getSocksServer() {
        return this.socksServer;
    }

    public void setSocksServer(String value) {
        this.socksServer = value;
    }

    public int getSocksPort() {
        return this.socksPort;
    }

    public void setSocksPort(int value) {
        this.socksPort = value;
    }

    public byte getSocksVersion() {
        return this.socksVersion;
    }

    public void setSocksVersion(byte version) {
        this.socksVersion = version;
    }

    public byte getSocksAuthentication() {
        return this.socksAuth;
    }

    public void setSocksAuthentication(byte value) {
        this.socksAuth = value;
    }

    public String getSocksUserCode() {
        return this.socksUserCode;
    }

    public void setSocksUserCode(String value) {
        this.socksUserCode = value;
    }

    public String getSocksPassword() {
        return this.socksPassword;
    }

    public void setSocksPassword(String value) {
        this.socksPassword = value;
    }

    protected void setSocketType(byte type) {
        if (type != 1 && type != 2) {
            throw new IllegalStateException();
        }
        this.socketType = type;
    }

    public byte getSocketType() {
        return this.socketType;
    }

    public int getSoTimeout() throws SocketException, IOException {
        if (this.socketChannel != null) {
            return this.socketChannel.socket().getSoTimeout();
        }
        if (this.serverSocketChannel != null) {
            return this.serverSocketChannel.socket().getSoTimeout();
        }
        if (this.datagramSocket != null) {
            return this.datagramSocket.getSoTimeout();
        }
        throw new IllegalStateException();
    }

    public boolean getUseWebTunneling() {
        return this.useWebTunneling;
    }

    public void setUseWebTunneling(boolean value) {
        this.useWebTunneling = value;
        if (value) {
            this.setUseSocks(false);
        }
    }

    public String getWebTunnelAddress() {
        return this.webTunnelAddress;
    }

    public void setWebTunnelAddress(String value) {
        this.webTunnelAddress = value;
    }

    public int getWebTunnelPort() {
        return this.webTunnelPort;
    }

    public void setWebTunnelPort(int value) {
        this.webTunnelPort = value;
    }

    public byte getWebTunnelAuthentication() {
        return this.webTunnelAuth;
    }

    public void setWebTunnelAuthentication(byte value) {
        this.webTunnelAuth = value;
    }

    public String getWebTunnelUserId() {
        return this.webTunnelUserId;
    }

    public void setWebTunnelUserId(String value) {
        this.webTunnelUserId = value;
    }

    public String getWebTunnelPassword() {
        return this.webTunnelPassword;
    }

    public void setWebTunnelPassword(String value) {
        this.webTunnelPassword = value;
    }
}

