/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSock;

import java.util.Vector;
import org.eldos.MsgConnect.MCSock.MCSocket;
import org.eldos.MsgConnect.MCSock.MCSocketCreationEvent;
import org.eldos.MsgConnect.MCSock.MCSocketCreationListener;

public abstract class MCSocketFactory {
    private Vector MCSocketCreationListeners = null;

    protected abstract MCSocket doCreateClientSocket();

    protected abstract MCSocket doCreateServerSocket();

    public MCSocket createClientSocket() {
        MCSocket result = this.doCreateClientSocket();
        this.fireSocketCreation(new MCSocketCreationEvent(this, result, 0));
        return result;
    }

    public MCSocket createServerSocket() {
        MCSocket result = this.doCreateServerSocket();
        this.fireSocketCreation(new MCSocketCreationEvent(this, result, 1));
        return result;
    }

    public synchronized void removeSocketCreationListener(MCSocketCreationListener l) {
        if (this.MCSocketCreationListeners != null && this.MCSocketCreationListeners.contains(l)) {
            Vector v = (Vector)this.MCSocketCreationListeners.clone();
            v.removeElement(l);
            this.MCSocketCreationListeners = v;
        }
    }

    public synchronized void addSocketCreationListener(MCSocketCreationListener l) {
        Vector v;
        Vector vector = v = this.MCSocketCreationListeners == null ? new Vector(2) : (Vector)this.MCSocketCreationListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.MCSocketCreationListeners = v;
        }
    }

    protected boolean fireSocketCreation(MCSocketCreationEvent e) {
        boolean res = false;
        if (this.MCSocketCreationListeners != null) {
            Vector listeners = this.MCSocketCreationListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MCSocketCreationListener)listeners.elementAt(i)).socketCreation(e);
            }
        }
        return res;
    }
}

