/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSock;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eldos.MsgConnect.IntegerHolder;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCSock.MCBase64Codec;
import org.eldos.MsgConnect.MCSock.MCSocket;

public class MCStdSocket
extends MCSocket {
    protected InetAddress localAddr;
    protected InetAddress remoteAddr;
    ByteBuffer buf = ByteBuffer.allocateDirect(1024);

    @Override
    public void init(byte socketType, boolean AllocateSocket) throws EMCError {
        if (this.getState() != 0 && this.getState() != 2) {
            throw new EMCError(202);
        }
        this.setSocketType(socketType);
        this.setState((byte)2);
    }

    @Override
    public void bind() throws EMCError {
        if (this.getState() == 2 || this.getState() == 3) {
            if (this.getLocalPort() <= 0 || this.getLocalPort() >= 65535) {
                this.setLocalPort(0);
                return;
            }
            if (this.getLocalAddress() != null) {
                try {
                    this.localAddr = InetAddress.getByName(this.getLocalAddress());
                }
                catch (UnknownHostException e) {
                    try {
                        this.localAddr = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException ex) {
                        throw new EMCError(204);
                    }
                }
            } else {
                try {
                    this.localAddr = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    throw new EMCError(204);
                }
            }
            if (this.getSocketType() == 2 && this.datagramSocket == null) {
                this.allocateDatagramSocket();
            }
        } else {
            throw new EMCError(202);
        }
        this.setState((byte)3);
    }

    @Override
    public void connect(int timeout) throws EMCError {
        if (this.getSocketType() == 1) {
            if (this.useSocks) {
                this.socksConnect(timeout);
            } else if (this.useWebTunneling) {
                this.httpConnect(timeout);
            } else {
                this.syncConnect(timeout);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncConnect(int timeout) throws EMCError {
        block9: {
            if (this.getState() != 2) {
                if (this.getState() != 3) throw new EMCError(202);
            }
            if (this.getRemoteAddress() == null) throw new EMCError(204);
            try {
                this.remoteAddr = null;
                this.remoteAddr = InetAddress.getByName(this.getRemoteAddress());
            }
            catch (UnknownHostException e) {
                throw new EMCError(204);
            }
            if (this.getRemotePort() <= 0) throw new EMCError(204);
            if (this.getRemotePort() >= 65535) {
                throw new EMCError(204);
            }
            this.bind();
            try {
                boolean success;
                SelectionKey selKey;
                if (this.getSocketType() != 1) break block9;
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(false);
                if (this.getLocalPort() != 0) {
                    this.socketChannel.socket().bind(new InetSocketAddress(this.localAddr, this.getLocalPort()));
                }
                if (timeout <= 0) {
                    timeout = 30000;
                }
                this.socketChannel.connect(new InetSocketAddress(this.remoteAddr, this.getRemotePort()));
                this.selector = Selector.open();
                this.socketChannel.register(this.selector, this.socketChannel.validOps());
                if (this.selector.select(timeout) == 1 && (selKey = this.selector.selectedKeys().iterator().next()).isValid() && selKey.isConnectable() && !(success = this.socketChannel.finishConnect())) {
                    selKey.cancel();
                }
            }
            catch (IOException e) {
                throw new EMCError(e.getMessage());
            }
        }
        super.connect(timeout);
        this.setState((byte)4);
    }

    @Override
    public void listen(int backlog) throws EMCError {
        if (this.getState() == 3 || this.getState() == 2) {
            if (this.getState() == 2) {
                this.bind();
            }
            try {
                if (this.getSocketType() == 2) {
                    this.setDirection((byte)1);
                } else {
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.serverSocketChannel.configureBlocking(false);
                    this.serverSocketChannel.socket().bind(new InetSocketAddress(this.getLocalPort()), backlog);
                    this.selector = Selector.open();
                    this.serverSocketChannel.register(this.selector, this.serverSocketChannel.validOps());
                    super.listen(backlog);
                }
                this.setState((byte)5);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EMCError(205);
            }
        } else {
            throw new EMCError(202);
        }
    }

    protected void allocateDatagramSocket() throws EMCError {
        try {
            this.datagramSocket = this.localAddr != null ? new MulticastSocket(new InetSocketAddress(this.localAddr, this.getLocalPort())) : (this.getLocalAddress() != null ? new MulticastSocket(new InetSocketAddress(InetAddress.getByName(this.getLocalAddress()), this.getLocalPort())) : new MulticastSocket());
        }
        catch (IOException e) {
            throw new EMCError(e.getMessage());
        }
    }

    @Override
    public MCSocket createAcceptingSocket() {
        return new MCStdSocket();
    }

    @Override
    public MCSocket accept() throws EMCError {
        if (this.getState() != 5) {
            throw new EMCError(202);
        }
        if (this.getSocketType() == 2) {
            throw new EMCError(208);
        }
        MCSocket retSock = null;
        try {
            SocketChannel newSocket = this.serverSocketChannel.accept();
            if (newSocket != null) {
                retSock = this.createAcceptingSocket();
                retSock.init((byte)1, false);
                retSock.socketChannel = newSocket;
                retSock.socketChannel.configureBlocking(false);
                retSock.selector = Selector.open();
                retSock.socketChannel.register(retSock.selector, 5);
                retSock.setDirection((byte)1);
                retSock.setLocalPort(newSocket.socket().getLocalPort());
                retSock.setRemotePort(newSocket.socket().getPort());
                retSock.setLocalAddress(newSocket.socket().getLocalAddress().getHostAddress());
                retSock.setRemoteAddress(newSocket.socket().getInetAddress().getHostAddress());
                retSock.setState((byte)4);
            }
        }
        catch (IOException e) {
            throw new EMCError(e.getMessage());
        }
        return retSock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean forced) {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
                this.socketChannel = null;
            }
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
            if (this.selector != null) {
                this.selector.close();
                this.selector = null;
            }
            if (this.datagramSocket != null) {
                this.datagramSocket.close();
                this.datagramSocket = null;
                this.allocateDatagramSocket();
            }
        }
        catch (EMCError ex) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                this.setState((byte)2);
            }
            catch (EMCError ex1) {}
        }
    }

    @Override
    public void finalize() {
        this.close(false);
    }

    @Override
    public int receive(byte[] b, int offset, int dataLength) throws EMCError {
        return this.intReceive(b, offset, dataLength);
    }

    public int intReceive(byte[] b, int offset, int dataLength) throws EMCError {
        if (this.getState() != 4) {
            throw new EMCError(202);
        }
        int ret = 0;
        if (dataLength > b.length) {
            dataLength = b.length;
        }
        if (this.returnedDatabuffer.length() > 0) {
            ret += this.returnedDatabuffer.getData(b, offset, dataLength);
            offset += ret;
            if ((dataLength -= ret) == 0) {
                return ret;
            }
        }
        try {
            if (this.getSocketType() == 1) {
                ByteBuffer bb = ByteBuffer.wrap(b, offset, dataLength);
                ret += this.socketChannel.read(bb);
            } else {
                if (this.packet != null) {
                    int len = dataLength < this.packet.getLength() ? dataLength : this.packet.getLength();
                    byte[] temp = this.packet.getData();
                    for (int i = 0; i < len; ++i) {
                        b[i + offset] = temp[i];
                    }
                    this.packet = null;
                    return len;
                }
                DatagramPacket dp = new DatagramPacket(b, offset, dataLength);
                this.datagramSocket.receive(dp);
                ret += dp.getLength();
            }
        }
        catch (IOException e) {
            throw new EMCError(e.getMessage());
        }
        return ret;
    }

    @Override
    public int send(byte[] b, int offset, int dataLength) throws EMCError {
        int i = this.intSend(b, offset, dataLength);
        return i;
    }

    @Override
    public void flush() throws EMCError {
        if (this.getState() != 4) {
            throw new EMCError(202);
        }
        try {
            if (this.getSocketType() == 1) {
                this.socketChannel.socket().getOutputStream().flush();
            }
        }
        catch (IOException e) {
            MCGlobals.DEBUG_STACKTRACE(e);
            throw new EMCError(e.getMessage());
        }
    }

    public int intSend(byte[] b, int offset, int dataLength) throws EMCError {
        int ret;
        block9: {
            if (this.getState() != 4) {
                throw new EMCError(202);
            }
            if (dataLength > b.length) {
                dataLength = b.length;
            }
            ret = 0;
            try {
                if (this.getSocketType() == 1) {
                    ByteBuffer bb = ByteBuffer.wrap(b, offset, dataLength);
                    ret = this.socketChannel.write(bb);
                    break block9;
                }
                DatagramPacket dp = null;
                int sendLen = 0;
                while (dataLength > 0) {
                    if (dataLength > 512) {
                        throw new EMCError(52);
                    }
                    sendLen = dataLength;
                    dataLength -= sendLen;
                    dp = new DatagramPacket(b, offset, sendLen, this.remoteAddr, this.getRemotePort());
                    offset += sendLen;
                    try {
                        this.datagramSocket.send(dp);
                    }
                    catch (IOException e) {
                        throw new EMCError(e.getMessage());
                    }
                    ret = sendLen;
                }
            }
            catch (IOException e) {
                MCGlobals.DEBUG_STACKTRACE(e);
                throw new EMCError(e.getMessage());
            }
        }
        return ret;
    }

    public void sendTo(InetAddress address, int port, byte[] b, int offset, int dataLength) throws Exception {
        if (this.getSocketType() != 2) {
            throw new EMCError(503);
        }
        if (dataLength > 512) {
            throw new EMCError(52);
        }
        if (this.datagramSocket == null) {
            this.allocateDatagramSocket();
        }
        this.datagramSocket.setBroadcast(true);
        this.setState((byte)4);
        DatagramPacket dp = new DatagramPacket(b, offset, dataLength, address, port);
        try {
            this.datagramSocket.send(dp);
        }
        catch (IOException e) {
            throw new EMCError(e.getMessage());
        }
    }

    @Override
    public void receive(DatagramPacket P) throws EMCError {
        if (this.getSocketType() != 2) {
            throw new EMCError(208);
        }
        try {
            this.datagramSocket.receive(P);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EMCError(e.getMessage());
        }
        if (P.getData().length > 512) {
            throw new EMCError(52);
        }
    }

    @Override
    public void send(DatagramPacket P) throws EMCError {
        if (this.getState() != 3 || this.datagramSocket == null) {
            throw new EMCError(202);
        }
        if (this.getSocketType() == 1) {
            throw new EMCError(208);
        }
        try {
            this.datagramSocket.send(P);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EMCError(e.getMessage());
        }
    }

    public InetAddress getInAddr() {
        return this.remoteAddr;
    }

    @Override
    public int addToMulticastCli(String bindAddress, byte ttl, boolean loop) throws EMCError {
        if (this.getState() != 2) {
            throw new EMCError(202);
        }
        if (this.getSocketType() == 1) {
            throw new EMCError(208);
        }
        try {
            if (this.datagramSocket == null) {
                this.allocateDatagramSocket();
            }
            if (bindAddress != null) {
                this.datagramSocket.setNetworkInterface(NetworkInterface.getByInetAddress(InetAddress.getByName(bindAddress)));
            }
            this.datagramSocket.setLoopbackMode(loop);
        }
        catch (UnknownHostException e) {
            throw new EMCError(203);
        }
        catch (IOException e) {
            throw new EMCError(203);
        }
        return 0;
    }

    @Override
    public int addToMulticastSrv(String groupAddress, String bindAddress) throws EMCError {
        if (this.getState() != 3) {
            throw new EMCError(202);
        }
        if (this.getSocketType() == 1) {
            throw new EMCError(208);
        }
        try {
            if (this.datagramSocket == null) {
                this.allocateDatagramSocket();
            }
            if (bindAddress != null) {
                this.datagramSocket.joinGroup(new InetSocketAddress(groupAddress, 0), NetworkInterface.getByInetAddress(InetAddress.getByName(bindAddress)));
            } else {
                this.datagramSocket.joinGroup(InetAddress.getByName(groupAddress));
            }
        }
        catch (UnknownHostException e) {
            throw new EMCError(203);
        }
        catch (IOException e) {
            throw new EMCError(203);
        }
        return 0;
    }

    protected boolean socksSendReceive(int timeout, byte[] sendBuf, int sendBufSize, IntegerHolder wasSent, byte[] readBuf, int readBufSize, IntegerHolder wasRead) throws EMCError, IOException, InterruptedException {
        this.intSend(sendBuf, 0, sendBufSize);
        wasSent.setI(sendBufSize);
        long startTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        while (timeout == 0 || startTime + (long)timeout > currentTime) {
            if (this.available()) {
                wasRead.setI(this.intReceive(readBuf, 0, readBufSize));
                return true;
            }
            Thread.sleep(10L);
            currentTime = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean httpConnect(int timeout) throws EMCError {
        boolean res;
        block19: {
            res = false;
            String rAddr = this.remoteAddress;
            int rPort = this.getRemotePort();
            IntegerHolder holder = new IntegerHolder();
            this.setRemoteAddress(this.webTunnelAddress);
            this.setRemotePort(this.webTunnelPort);
            this.syncConnect(timeout);
            int len = 1024;
            boolean cnt = false;
            boolean selectRes = false;
            byte[] buf = new byte[len];
            try {
                block20: {
                    byte[] readBuf;
                    block22: {
                        block21: {
                            if (this.state != 4) break block20;
                            StringBuffer HttpRequest = null;
                            if (1 == this.webTunnelAuth && this.webTunnelUserId != null && this.webTunnelPassword != null) {
                                String basicCredentials = this.webTunnelUserId + ":" + this.webTunnelPassword;
                                String basicCredentialsEnc = MCBase64Codec.encode(basicCredentials.getBytes());
                                HttpRequest = new StringBuffer();
                                HttpRequest.append("CONNECT ");
                                HttpRequest.append(rAddr);
                                HttpRequest.append(":");
                                HttpRequest.append(rPort);
                                HttpRequest.append(" HTTP/1.1\r\nUser-agent: MsgConnect\r\nProxy-Authorization: Basic ");
                                HttpRequest.append(basicCredentialsEnc);
                                HttpRequest.append("\r\n\r\n");
                            } else {
                                HttpRequest = new StringBuffer();
                                HttpRequest.append("CONNECT ");
                                HttpRequest.append(rAddr);
                                HttpRequest.append(":");
                                HttpRequest.append(rPort);
                                HttpRequest.append(" HTTP/1.1\r\nUser-agent: MsgConnect\r\n\r\n");
                            }
                            int psize = HttpRequest.length();
                            int wasRead = 0;
                            readBuf = new byte[1024];
                            try {
                                buf = HttpRequest.toString().getBytes("ascii");
                            }
                            catch (UnsupportedEncodingException ex) {
                                throw new EMCError(550);
                            }
                            if (!this.socksSendReceive(timeout, buf, psize, holder, readBuf, 1024, holder)) {
                                throw new EMCError(0);
                            }
                            wasRead = holder.i;
                            if (wasRead < 12) {
                                throw new EMCError(552);
                            }
                            int httpMajor = 0;
                            int httpMinor = 0;
                            int httpCode = 0;
                            try {
                                String HttpResponse = new String(readBuf, 0, wasRead);
                                httpMajor = Integer.parseInt(new String(readBuf, 5, 1), 10);
                                httpMinor = Integer.parseInt(new String(readBuf, 7, 1), 10);
                                httpCode = Integer.parseInt(new String(readBuf, 9, 3), 10);
                            }
                            catch (Exception e) {
                                throw new EMCError(552);
                            }
                            if (1 != httpMajor || 0 != httpMinor && 1 != httpMinor) break block21;
                            switch (httpCode) {
                                case 200: {
                                    res = true;
                                    break block22;
                                }
                                case 407: {
                                    throw new EMCError(551);
                                }
                                default: {
                                    throw new EMCError(552);
                                }
                            }
                        }
                        throw new EMCError(552);
                    }
                    String readData = new String(readBuf, 0, holder.i);
                    int headerEnd = readData.indexOf("\r\n\r\n");
                    if (headerEnd + 4 < holder.i) {
                        this.returnData(readBuf, headerEnd + 4, holder.i - (headerEnd + 4));
                    }
                    break block19;
                }
                throw new EMCError(550);
            }
            catch (Exception e) {
                e.printStackTrace();
                res = false;
            }
            finally {
                buf = null;
                if (!res && this.state == 4) {
                    this.close(true);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean socksConnect(int timeout) throws EMCError {
        boolean res = false;
        String rAddr = this.remoteAddress;
        int rPrt = this.getRemotePort();
        this.setRemoteAddress(this.socksServer);
        this.setRemotePort(this.socksPort);
        this.syncConnect(timeout);
        int len = 1024;
        int cnt = 0;
        int selectRes = 0;
        byte[] buf = new byte[len];
        int psize = 0;
        InetAddress rIP = null;
        IntegerHolder holder = new IntegerHolder();
        try {
            if (this.getState() == 4) {
                if (5 == this.socksVersion) {
                    psize = 4;
                    switch (this.socksAuth) {
                        case 1: {
                            buf[0] = 5;
                            buf[1] = 2;
                            buf[2] = 0;
                            buf[3] = 2;
                            break;
                        }
                        case 0: {
                            buf[0] = 5;
                            buf[1] = 1;
                            buf[2] = 0;
                            buf[3] = 0;
                            psize = 3;
                        }
                    }
                    holder.setI(cnt);
                    if (!this.socksSendReceive(timeout, buf, psize, holder, buf, 1024, holder)) {
                        throw new EMCError(0);
                    }
                    cnt = holder.getI();
                    if (buf[0] == 5 && buf[1] == 255) {
                        throw new EMCError(501);
                    }
                    if (buf[0] == 5 && buf[1] == 2) {
                        cnt = this.socksUserCode.length();
                        buf[0] = 1;
                        buf[1] = (byte)cnt;
                        System.arraycopy(this.socksUserCode.getBytes(), 0, buf, 2, cnt);
                        psize = this.socksPassword.length();
                        buf[cnt + 2] = (byte)psize;
                        System.arraycopy(this.socksPassword.getBytes(), 0, buf, cnt + 3, psize);
                        holder.setI(cnt);
                        if (!this.socksSendReceive(timeout, buf, psize, holder, buf, 1024, holder)) {
                            throw new EMCError(0);
                        }
                        if (buf[1] != 0) {
                            throw new EMCError(502);
                        }
                    }
                    psize = 8;
                    rIP = InetAddress.getByName(rAddr);
                    System.arraycopy(rIP.getAddress(), 0, buf, 4, 4);
                    buf[2] = 0;
                    buf[3] = 1;
                    buf[0] = 5;
                    buf[1] = 1;
                    buf[psize] = (byte)((rPrt & 0xFF00) / 256);
                    buf[psize + 1] = (byte)(rPrt & 0xFF);
                    if (!this.socksSendReceive(timeout, buf, psize += 2, holder, buf, 1024, holder)) {
                        throw new EMCError(0);
                    }
                    cnt = holder.getI();
                    switch (buf[1]) {
                        case 0: {
                            res = true;
                            break;
                        }
                        case 1: {
                            selectRes = 503;
                            break;
                        }
                        case 2: {
                            selectRes = 504;
                            break;
                        }
                        case 3: {
                            selectRes = 505;
                            break;
                        }
                        case 4: {
                            selectRes = 506;
                            break;
                        }
                        case 5: {
                            selectRes = 507;
                            break;
                        }
                        case 6: {
                            selectRes = 508;
                            break;
                        }
                        case 7: {
                            selectRes = 509;
                            break;
                        }
                        case 8: {
                            selectRes = 510;
                            break;
                        }
                        default: {
                            selectRes = 0;
                            res = false;
                        }
                    }
                    if (!res) {
                        throw new EMCError(selectRes);
                    }
                    int realDataLen = 0;
                    switch (buf[3]) {
                        case 1: {
                            realDataLen = 10;
                            break;
                        }
                        case 3: {
                            realDataLen = 4 + (1 + buf[4]) + 2;
                            break;
                        }
                        case 4: {
                            realDataLen = 22;
                            break;
                        }
                        default: {
                            realDataLen = -1;
                        }
                    }
                    if (realDataLen == -1) {
                        throw new EMCError(503);
                    }
                    if (realDataLen < holder.i) {
                        this.returnData(buf, realDataLen, holder.i - realDataLen);
                    }
                } else {
                    buf[0] = 4;
                    buf[1] = 1;
                    buf[2] = (byte)((rPrt & 0xFF00) / 256);
                    buf[3] = (byte)(rPrt % 256);
                    cnt = this.socksUserCode.length();
                    System.arraycopy(this.socksUserCode.getBytes(), 0, buf, 8, cnt);
                    psize = cnt + 8 + 1;
                    buf[psize - 1] = 0;
                    rIP = InetAddress.getByName(rAddr);
                    System.arraycopy(rIP.getAddress(), 0, buf, 4, 4);
                    if (!this.socksSendReceive(timeout, buf, psize, holder, buf, 1024, holder)) {
                        throw new EMCError(0);
                    }
                    switch (buf[1]) {
                        case 90: {
                            res = true;
                            break;
                        }
                        default: {
                            throw new EMCError(504);
                        }
                    }
                    if (res && 8 < holder.i) {
                        this.returnData(buf, 8, holder.i - 8);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        finally {
            buf = null;
            if (!res) {
                this.close(true);
            }
            rAddr = null;
        }
        return res;
    }
}

