/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSocket;

import java.net.SocketException;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCSemaphore;
import org.eldos.MsgConnect.MCSock.MCSocket;
import org.eldos.MsgConnect.MCSock.MCSocketJob;
import org.eldos.MsgConnect.MCSocket.MCInetConnectionEntry;
import org.eldos.MsgConnect.MCSocket.MCInetTransport;
import org.eldos.MsgConnect.MCSocket.MCInetTransportJob;

public class MCInetListenerJob
extends MCSocketJob {
    protected boolean initialized = false;
    protected MCInetTransport owner = null;
    protected MCSocket listener = null;
    protected MCSemaphore startSignal = new MCSemaphore(0L);
    protected MCSemaphore finishSignal = new MCSemaphore(0L);

    public void initialize(MCSocket aSocket) throws EMCError {
        this.listener = aSocket;
        this.listener.setLocalAddress(this.owner.getMessengerAddress());
        this.listener.setLocalPort(this.owner.getMessengerPort());
        this.listener.init((byte)1);
        try {
            if (this.owner.getReuseServerPort()) {
                this.listener.reusePort();
            }
        }
        catch (SocketException e1) {
            throw new EMCError(8);
        }
        this.listener.bind();
        this.listener.listen(-1);
        this.initialized = true;
    }

    public void setOwner(MCInetTransport owner) {
        this.owner = owner;
    }

    public MCInetTransport getOwner() {
        return this.owner;
    }

    public void finalize() {
        this.listener.close(false);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acceptConnection() throws EMCError {
        MCInetTransportJob newJob = null;
        MCSocket newSocket = null;
        MCInetConnectionEntry newEntry = null;
        if (this.listener.getState() != 5) {
            return false;
        }
        try {
            while (!(this.getTerminated() || (this.listener.select(16, 100L) & 0x10) != 0 && (newSocket = this.listener.accept()) != null)) {
            }
            if (this.getTerminated()) {
                newSocket.close(true);
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        this.owner.enterCriticalSection();
        try {
            newJob = this.owner.createTransportJob();
            newJob.setOwner(this.owner);
            newJob.initialize(newSocket, this.owner.createConnectionEntry());
            newEntry = newJob.getEntry();
            newEntry.setRemoteAddress(this.owner.createSMessenger(0, 0, newSocket.getRemoteAddress(), newSocket.getRemotePort()));
            newEntry.setProcessingJob(newJob);
            newEntry.setLastActionTime(System.currentTimeMillis());
            newEntry.getCS().enter();
            try {
                this.owner.getConnections().add(newEntry);
            }
            finally {
                newEntry.getCS().leave();
            }
            this.owner.threadPool.postJob(newJob);
        }
        finally {
            this.owner.leaveCriticalSection();
        }
        return true;
    }

    @Override
    public void run() {
        this.startSignal.release();
        while (!this.terminated) {
            try {
                if (this.acceptConnection()) continue;
                break;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        this.listener.finalize();
        this.finishSignal.release();
    }

    public MCSemaphore getStartSignal() {
        return this.startSignal;
    }

    public MCSemaphore getFinishSignal() {
        return this.finishSignal;
    }
}

