/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSocket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import org.eldos.MsgConnect.MCAbstractJob;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCBaseTransport;
import org.eldos.MsgConnect.MCBase.MCMessage;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCBase.ValidateCredentialsEvent;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMutex;
import org.eldos.MsgConnect.MCRemoteAddress;
import org.eldos.MsgConnect.MCSock.MCSocket;
import org.eldos.MsgConnect.MCSock.MCSocketFactory;
import org.eldos.MsgConnect.MCSock.MCStdSocketFactory;
import org.eldos.MsgConnect.MCSocket.MCFakeConnectionJob;
import org.eldos.MsgConnect.MCSocket.MCInetConnectionEntry;
import org.eldos.MsgConnect.MCSocket.MCInetListenerJob;
import org.eldos.MsgConnect.MCSocket.MCInetTransportJob;
import org.eldos.MsgConnect.MCSocket.SocketConnectedEvent;
import org.eldos.MsgConnect.MCSocket.SocketConnectedListener;
import org.eldos.MsgConnect.MCSocket.SocketDisconnectedEvent;
import org.eldos.MsgConnect.MCSocket.SocketDisconnectedListener;
import org.eldos.MsgConnect.MCThreadPool;

public abstract class MCInetTransport
extends MCBaseTransport {
    public static final byte stmP2P = 0;
    public static final byte stmServer = 1;
    public static final byte stmClient = 2;
    protected long attemptsInterval = 1L;
    protected int attemptsToConnect = 0;
    protected Vector connections = new Vector();
    protected boolean failOnInactive = true;
    protected long inactivityTime = 0L;
    protected long incomingMemoryThreshold = 0L;
    protected long outgoingMemoryThreshold = 0L;
    protected String messengerAddress = "0.0.0.0";
    protected int messengerPort = 1458;
    protected String tempFilesFolder = null;
    protected MCThreadPool threadPool = new MCThreadPool();
    protected byte transportMode = 0;
    protected boolean useTempFilesForIncoming = false;
    protected boolean useTempFilesForOutgoing = false;
    protected MCInetListenerJob listenerJob = null;
    protected boolean reuseServerPort = true;
    protected int connectionTimeout;
    protected boolean routingAllowed = true;
    protected boolean noTransformerFallback = false;
    protected int incomingBufferSize = 8192;
    protected int outgoingBufferSize = 8192;
    protected int incomingSpeedLimit = 0;
    protected int outgoingSpeedLimit = 0;
    protected Vector outgoingQueue = new Vector();
    protected boolean useSocks = false;
    protected String socksServer = null;
    protected int socksPort = 1080;
    protected byte socksVersion = (byte)5;
    protected byte socksAuth = 0;
    protected String socksUserCode = null;
    protected String socksPassword = null;
    protected boolean useWebTunneling = false;
    protected String webTunnelAddress = null;
    protected int webTunnelPort = 3128;
    protected byte webTunnelAuth = 0;
    protected String webTunnelUserId = null;
    protected String webTunnelPassword = null;
    protected MCSocketFactory socketFactory = null;
    protected MCSocketFactory defaultSocketFactory = null;
    protected byte bandwidthPolicy = 1;
    private Vector SocketConnectedListeners;
    private Vector SocketDisconnectedListeners;

    public MCInetTransport() {
        this.defaultTransportName = "";
        this.defaultSocketFactory = new MCStdSocketFactory();
        this.setActive(false);
        this.threadPool.setThreadSize(0);
    }

    @Override
    public void destroy() {
        this.setActive(false);
    }

    protected abstract MCInetTransportJob createTransportJob();

    protected abstract MCInetConnectionEntry createConnectionEntry();

    protected abstract boolean needLiveConnectionForDelivery();

    protected abstract long getDeliveryInterval();

    @Override
    public MCMutex getLinkCriticalSection() {
        return this.linkCriticalSection;
    }

    public Vector getConnections() {
        return this.connections;
    }

    protected Vector getOutgoingQueue() {
        return this.outgoingQueue;
    }

    public void setInactivityTime(long time) {
        this.inactivityTime = time;
    }

    public long getInactivityTime() {
        return this.inactivityTime;
    }

    public int getAttemptsToConnect() {
        return this.attemptsToConnect;
    }

    public void setAttemptsToConnect(int attemptsToConnect) {
    }

    public long getAttemptsInterval() {
        return this.attemptsInterval;
    }

    public void setAttemptsInterval(long value) {
        this.attemptsInterval = value;
    }

    public int getThreadPoolSize() {
        return this.threadPool.getThreadSize();
    }

    public void setThreadPoolSize(int value) {
        this.threadPool.setThreadSize(value);
    }

    public boolean getRoutingAllowed() {
        return this.routingAllowed;
    }

    public void setRoutingAllowed(boolean value) {
        this.routingAllowed = value;
    }

    public boolean getUseSocks() {
        return this.useSocks;
    }

    public void setUseSocks(boolean value) {
        this.useSocks = value;
        if (value) {
            this.setUseWebTunneling(false);
        }
    }

    public String getSocksServer() {
        return this.socksServer;
    }

    public void setSocksServer(String value) {
        this.socksServer = value;
    }

    public int getSocksPort() {
        return this.socksPort;
    }

    public void setSocksPort(int value) {
        this.socksPort = value;
    }

    public byte getSocksVersion() {
        return this.socksVersion;
    }

    public void setSocksVersion(byte version) {
        this.socksVersion = version;
    }

    public byte getSocksAuthentication() {
        return this.socksAuth;
    }

    public void setSocksAuthentication(byte value) {
        this.socksAuth = value;
    }

    public String getSocksUserCode() {
        return this.socksUserCode;
    }

    public void setSocksUserCode(String value) {
        this.socksUserCode = value;
    }

    public String getSocksPassword() {
        return this.socksPassword;
    }

    public void setSocksPassword(String value) {
        this.socksPassword = value;
    }

    public boolean getUseWebTunneling() {
        return this.useWebTunneling;
    }

    public void setUseWebTunneling(boolean value) {
        this.useWebTunneling = value;
        if (value) {
            this.setUseSocks(false);
        }
    }

    public String getWebTunnelAddress() {
        return this.webTunnelAddress;
    }

    public void setWebTunnelAddress(String value) {
        this.webTunnelAddress = value;
    }

    public int getWebTunnelPort() {
        return this.webTunnelPort;
    }

    public void setWebTunnelPort(int value) {
        this.webTunnelPort = value;
    }

    public byte getWebTunnelAuthentication() {
        return this.webTunnelAuth;
    }

    public void setWebTunnelAuthentication(byte value) {
        this.webTunnelAuth = value;
    }

    public String getWebTunnelUserId() {
        return this.webTunnelUserId;
    }

    public void setWebTunnelUserId(String value) {
        this.webTunnelUserId = value;
    }

    public String getWebTunnelPassword() {
        return this.webTunnelPassword;
    }

    public void setWebTunnelPassword(String value) {
        this.webTunnelPassword = value;
    }

    protected MCInetListenerJob createListenerJob() throws EMCError {
        MCInetListenerJob job = new MCInetListenerJob();
        job.setOwner(this);
        job.initialize(this.createServerSocket());
        return job;
    }

    public static boolean parseRemoteAddr(String S, MCRemoteAddress RemAddr) {
        RemAddr.setClientID(0);
        RemAddr.setConnID(0);
        RemAddr.setIP("");
        RemAddr.setPort(0);
        if (null == S) {
            return false;
        }
        String cc = "";
        String IP = "";
        int p1 = -1;
        int p2 = -1;
        int p3 = -1;
        int Port = 0;
        boolean result = false;
        p2 = S.lastIndexOf(58, S.length());
        if (-1 != p2) {
            p1 = S.indexOf(58, 0);
            if (p1 != p2) {
                p3 = S.indexOf(58, p1 + 1);
                if (p3 == p2) {
                    p3 = p1;
                }
                cc = S.substring(0, p3);
                IP = S.substring(0, p2);
                IP = IP.substring(p3 + 1, IP.length());
                Port = Integer.parseInt(S.substring(p2 + 1, S.length()));
                result = true;
            } else if (S.length() - 1 == p2) {
                cc = S.substring(0, p1 - 1);
            } else {
                IP = S.substring(0, p2);
                Port = Integer.parseInt(S.substring(p2 + 1, S.length()));
                result = true;
            }
        } else {
            cc = new String(S);
        }
        if (cc.length() > 0) {
            p1 = cc.indexOf(58);
            if (p1 > -1) {
                if (p1 > 0) {
                    RemAddr.setClientID(Integer.parseInt(cc.substring(0, p1)));
                }
                if (p1 < cc.length()) {
                    RemAddr.setConnID(Integer.parseInt(cc.substring(p1 + 1, cc.length())));
                }
            } else {
                p1 = cc.indexOf(92);
                if (p1 == -1) {
                    RemAddr.setClientID(Integer.parseInt(cc));
                } else if (p1 > 0) {
                    RemAddr.setClientID(Integer.parseInt(cc.substring(0, p1)));
                }
                if (p1 < cc.length()) {
                    RemAddr.setConnID(Integer.parseInt(cc.substring(p1 + 1, cc.length())));
                }
            }
        }
        RemAddr.setIP(IP);
        RemAddr.setPort(Port);
        return result;
    }

    public static boolean compareAddress(String addr1, String addr2, boolean strict) {
        if (null == addr1 || null == addr2) {
            return false;
        }
        MCRemoteAddress remAddr1 = new MCRemoteAddress();
        MCRemoteAddress remAddr2 = new MCRemoteAddress();
        remAddr1.setIP(new String(""));
        remAddr2.setIP(new String(""));
        MCInetTransport.parseRemoteAddr(addr1, remAddr1);
        MCInetTransport.parseRemoteAddr(addr2, remAddr2);
        if (!strict) {
            return remAddr1.getIP().compareToIgnoreCase(remAddr2.getIP()) == 0 && remAddr1.getPort() == remAddr2.getPort();
        }
        return remAddr1.getClientID() == remAddr2.getClientID() && remAddr1.getIP().compareToIgnoreCase(remAddr2.getIP()) == 0 && remAddr1.getPort() == remAddr2.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MCInetConnectionEntry findEntry(String socketName, MCMessageInfo info) {
        if (socketName == null) {
            return null;
        }
        MCInetConnectionEntry entry = null;
        int i = 0;
        if (null != info) {
            for (i = 0; i < this.connections.size(); ++i) {
                entry = (MCInetConnectionEntry)this.connections.elementAt(i);
                if (entry == null) continue;
                entry.getCS().enter();
                try {
                    if ((long)entry.getConnID() != info.getConnID()) continue;
                    MCInetConnectionEntry mCInetConnectionEntry = entry;
                    return mCInetConnectionEntry;
                }
                finally {
                    entry.getCS().leave();
                }
            }
        }
        if (info.getClientID() == 0L) {
            for (i = 0; i < this.connections.size(); ++i) {
                entry = (MCInetConnectionEntry)this.connections.elementAt(i);
                if (entry == null) continue;
                entry.getCS().enter();
                try {
                    if (!MCInetTransport.compareAddress(entry.getRemoteAddress(), socketName, false) && !MCInetTransport.compareAddress(entry.getRemoteSAddress(), socketName, false)) continue;
                    MCInetConnectionEntry mCInetConnectionEntry = entry;
                    return mCInetConnectionEntry;
                }
                finally {
                    entry.getCS().leave();
                }
            }
        } else {
            for (i = 0; i < this.connections.size(); ++i) {
                entry = (MCInetConnectionEntry)this.connections.elementAt(i);
                if (entry == null) continue;
                entry.getCS().enter();
                try {
                    if (entry.getProcessingJob().getTransporter().getDirection() == 1) {
                        if (info.getClientID() != (long)entry.getClientID()) continue;
                        MCInetConnectionEntry mCInetConnectionEntry = entry;
                        return mCInetConnectionEntry;
                    }
                    if (info.getClientID() != (long)entry.getClientID() || !MCInetTransport.compareAddress(entry.getRemoteAddress(), socketName, false) && !MCInetTransport.compareAddress(entry.getRemoteSAddress(), socketName, false)) continue;
                    MCInetConnectionEntry mCInetConnectionEntry = entry;
                    return mCInetConnectionEntry;
                }
                finally {
                    entry.getCS().leave();
                }
            }
        }
        return null;
    }

    protected Class getSocketClass() {
        Class<?> c = null;
        try {
            c = Class.forName("org.eldos.MsgConnect.MCSock.MCStdSocket");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return c;
    }

    protected MCSocket createClientSocket() throws EMCError {
        MCSocket s = null;
        s = this.socketFactory != null ? this.socketFactory.createClientSocket() : this.defaultSocketFactory.createClientSocket();
        s.init((byte)1);
        return s;
    }

    protected MCSocket createServerSocket() {
        MCSocket s = null;
        s = this.socketFactory != null ? this.socketFactory.createServerSocket() : this.defaultSocketFactory.createServerSocket();
        return s;
    }

    @Override
    protected boolean deliverMessage(String destAddress, MCMessageInfo info) throws EMCError {
        if (destAddress.length() > 0 && this.addressValid(destAddress)) {
            int i1 = destAddress.indexOf(124);
            if (i1 == -1) {
                return false;
            }
            String socketName = destAddress.substring(destAddress.indexOf(58) + 1, i1);
            i1 = socketName.indexOf(47);
            if (i1 != -1) {
                info.setUrlPart(socketName.substring(i1 + 1));
                socketName = socketName.substring(0, i1);
            } else {
                info.setUrlPart(null);
            }
            String queueName = destAddress.substring(destAddress.indexOf(124) + 1);
            if (queueName.length() == 0) {
                return false;
            }
            int j = queueName.lastIndexOf(124);
            if (j >= 0) {
                info.setRouteTo(queueName.substring(0, j));
                queueName = queueName.substring(j + 1);
            }
            info.setDQueue(queueName);
            StringBuffer sockName = new StringBuffer(socketName);
            MCRemoteAddress remAddr = new MCRemoteAddress();
            this.extractConnID(sockName, remAddr);
            socketName = sockName.toString();
            info.setConnID(remAddr.getConnID());
            info.setClientID(remAddr.getClientID());
            info.setDMessenger(socketName);
            info.setState((byte)1);
            this.putMessageToOutgoing(socketName, info);
            return true;
        }
        return false;
    }

    void extractConnID(StringBuffer SocketName, MCRemoteAddress remAddr) {
        MCInetTransport.parseRemoteAddr(SocketName.toString(), remAddr);
        if (remAddr.getClientID() != 0 || remAddr.getConnID() != 0) {
            int p = SocketName.toString().indexOf(58);
            if (-1 != p) {
                SocketName.delete(0, p);
            } else {
                remAddr.setClientID(0);
                remAddr.setConnID(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putMessageToOutgoing(String socketName, MCMessageInfo info) throws EMCError {
        block13: {
            boolean foundEntry = false;
            MCInetConnectionEntry entry = null;
            this.criticalSection.enter();
            try {
                entry = this.findEntry(socketName, info);
                if (null != entry) {
                    entry.getCS().enter();
                    try {
                        info.setConnID(entry.getConnID());
                        info.setClientID(entry.getClientID());
                        info.setMessage((MCMessage)info.getMessage().clone());
                        entry.getProcessingJob().getCS().enter();
                        try {
                            MCBaseTransport.insertInfoIntoQueueWithPriorities((Vector)entry.getProcessingJob().getOutgoingQueue(), info, false);
                            break block13;
                        }
                        finally {
                            entry.getProcessingJob().getCS().leave();
                        }
                    }
                    finally {
                        entry.getCS().leave();
                    }
                }
                MCBaseTransport.insertInfoIntoQueueWithPriorities(this.outgoingQueue, info, false);
                if (!this.needLiveConnectionForDelivery()) {
                    if (this.IsImmediateDelivery(socketName) && info.getState() == 1) {
                        this.initiateDelivery(null, null);
                    }
                } else {
                    this.initiateDelivery(null, null);
                }
            }
            finally {
                this.criticalSection.leave();
            }
        }
    }

    protected String createSMessenger(int clientID, int connID, String IP, int port) {
        StringBuffer res = new StringBuffer();
        if (clientID != 0) {
            res.append(clientID);
            if (connID != 0) {
                res.append(":");
            }
        }
        if (connID != 0) {
            res.append(connID);
        }
        if (clientID != 0 || connID != 0) {
            res.append(":");
        }
        res.append(IP);
        res.append(":");
        res.append(port);
        return res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliveryFailed(MCMessageInfo info) {
        this.linkCriticalSection.enter();
        try {
            if (this.messenger != null && (info.getState() == 1 || info.getState() == 2) && info.isSendMsg() && !info.getIntermed()) {
                this.messenger.completeCriticalSection.enter();
                info.setState((byte)5);
                this.messenger.completeQueue.add(info);
                this.messenger.completeEvent.signal();
                if (info.getReplyFlag() != null) {
                    info.getReplyFlag().signal();
                }
                this.messenger.completeCriticalSection.leave();
            }
        }
        finally {
            this.linkCriticalSection.leave();
        }
    }

    @Override
    protected void doSetActive() {
        if (this.getActive() && null == this.messenger) {
            return;
        }
        if (this.getActive()) {
            if (this.getTransportMode() == 0 || this.getTransportMode() == 1) {
                try {
                    this.listenerJob = this.createListenerJob();
                    this.threadPool.setJobsRan(0);
                    this.threadPool.postJob(this.listenerJob);
                    this.listenerJob.getStartSignal().attempt(100000L);
                }
                catch (Exception e) {
                    MCGlobals.DEBUG_STACKTRACE(e);
                    this.setActive(false);
                }
            }
        } else {
            if (null != this.listenerJob) {
                this.listenerJob.getThread().setTerminated();
                String ip = null;
                ip = this.messengerAddress.compareTo("0.0.0.0") == 0 ? "127.0.0.1" : this.messengerAddress;
                MCFakeConnectionJob job = new MCFakeConnectionJob(ip, this.messengerPort);
                ((MCAbstractJob)job).run();
                try {
                    this.listenerJob.getFinishSignal().attempt(1000000L);
                }
                catch (Exception e) {
                    MCGlobals.DEBUG_STACKTRACE(e);
                }
                this.listenerJob = null;
            }
            this.threadPool.clear();
            this.cleanOutgoingQueue();
        }
    }

    @Override
    protected void messageProcessed(MCMessageInfo info) {
        String socketName;
        if (!this.needLiveConnectionForDelivery()) {
            MCRemoteAddress remAddr = new MCRemoteAddress();
            MCInetTransport.parseRemoteAddr(info.getDMessenger(), remAddr);
            socketName = Integer.toString(remAddr.getClientID());
        } else {
            socketName = new String(info.getDMessenger());
        }
        try {
            this.putMessageToOutgoing(socketName, info);
        }
        catch (EMCError e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived(MCMessageInfo info) {
        block10: {
            this.linkCriticalSection.enter();
            try {
                if (this.messenger != null) {
                    if (!this.messenger.fireValidateCredentials(new ValidateCredentialsEvent(this, info.getMessage(), info.getCredentials()))) {
                        info.setMCError(16);
                        info.setState((byte)5);
                        if (info.isSendMsg()) {
                            this.linkCriticalSection.leave();
                            this.messageProcessed(info);
                            this.linkCriticalSection.enter();
                        } else {
                            info = null;
                        }
                        break block10;
                    }
                    info.setMCError(0);
                    info.setTransport(this);
                    info.setState((byte)2);
                    this.messenger.incomingCriticalSection.enter();
                    try {
                        MCInetTransport.insertInfoIntoQueueWithPriorities(this.messenger.incomingQueue, info, this.ignoreIncomingPriorities);
                        this.messenger.incomingEvent.signal();
                        break block10;
                    }
                    finally {
                        this.messenger.incomingCriticalSection.leave();
                    }
                }
                info = null;
            }
            finally {
                this.linkCriticalSection.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replyReceived(MCMessageInfo info) {
        block7: {
            this.linkCriticalSection.enter();
            try {
                if (this.messenger == null) break block7;
                this.messenger.completeCriticalSection.enter();
                try {
                    this.messenger.completeQueue.add(info);
                    this.messenger.completeEvent.signal();
                    if (info.getReplyFlag() != null) {
                        info.getReplyFlag().signal();
                    }
                }
                finally {
                    this.messenger.completeCriticalSection.leave();
                }
            }
            finally {
                this.linkCriticalSection.leave();
            }
        }
    }

    public void setClientThreadLimit(int value) {
        this.threadPool.setThreadSize(value + 1);
    }

    public int getClientThreadLimit() {
        return this.threadPool.getThreadSize() - 1;
    }

    public void setFailOnInactive(boolean value) {
        this.failOnInactive = value;
    }

    public boolean getFailOnInactive() {
        return this.failOnInactive;
    }

    public void setIncomingMemoryThreshold(long value) {
        if (this.incomingMemoryThreshold != value) {
            if (this.getActive()) {
                this.criticalSection.enter();
                this.incomingMemoryThreshold = value;
                this.criticalSection.leave();
            } else {
                this.incomingMemoryThreshold = value;
            }
        }
    }

    public long getIncomingMemoryThreshold() {
        return this.incomingMemoryThreshold;
    }

    public void setMessengerAddress(String value) throws EMCError {
        if (!this.messengerAddress.equals(value)) {
            boolean b = this.getActive();
            this.setActive(false);
            if (!value.equals("255.255.255.255")) {
                try {
                    InetAddress ia = InetAddress.getByName(value);
                }
                catch (UnknownHostException e) {
                    throw new EMCError(204);
                }
            }
            this.messengerAddress = value;
            this.setActive(b);
        }
    }

    public String getMessengerAddress() {
        return this.messengerAddress;
    }

    public void setMessengerPort(int value) {
        if (this.messengerPort != value && value > 0 && value <= 65535) {
            boolean b = this.getActive();
            this.setActive(false);
            this.messengerPort = value;
            this.setActive(b);
        }
    }

    public int getMessengerPort() {
        return this.messengerPort;
    }

    public int getMessengerPortBound() {
        if (!this.getActive() || this.listenerJob == null) {
            return 0;
        }
        return this.listenerJob.listener.getLocalPort();
    }

    public void setOutgoingMemoryThreshold(long value) {
        if (this.outgoingMemoryThreshold != value) {
            if (this.getActive()) {
                this.criticalSection.enter();
                this.outgoingMemoryThreshold = value;
                this.criticalSection.leave();
            } else {
                this.outgoingMemoryThreshold = value;
            }
        }
    }

    public long getOutgoingMemoryThreshold() {
        return this.outgoingMemoryThreshold;
    }

    public void setTempFilesFolder(String folderName) {
        this.tempFilesFolder = folderName;
    }

    public String getTempFilesFolder() {
        return this.tempFilesFolder;
    }

    public void setTransportMode(byte mode) {
        if (this.getActive()) {
            this.setActive(false);
            this.transportMode = mode;
            this.setActive(true);
        } else {
            this.transportMode = mode;
        }
    }

    public byte getTransportMode() {
        return this.transportMode;
    }

    public void setUseTempFilesForIncoming(boolean value) {
        if (this.useTempFilesForIncoming != value) {
            if (this.getActive()) {
                this.criticalSection.enter();
                this.useTempFilesForIncoming = value;
                this.criticalSection.leave();
            } else {
                this.useTempFilesForIncoming = value;
            }
        }
    }

    public boolean getUseTempFilesForIncoming() {
        return this.useTempFilesForIncoming;
    }

    public void setUseTempFilesForOutgoing(boolean value) {
        if (this.useTempFilesForOutgoing != value) {
            if (this.getActive()) {
                this.criticalSection.enter();
                this.useTempFilesForOutgoing = value;
                this.criticalSection.leave();
            } else {
                this.useTempFilesForOutgoing = value;
            }
        }
    }

    public boolean getUseTempFilesForOutgoing() {
        return this.useTempFilesForOutgoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelMessage(List Queue, MCMessageInfo info) {
        MCInetConnectionEntry entry = null;
        this.criticalSection.enter();
        try {
            String socketName = info.getDMessenger();
            entry = this.findEntry(socketName, info);
            if (entry != null) {
                entry.CS.enter();
                try {
                    if (entry.getInfo() != null && entry.getInfo().equals(info)) {
                        entry.setInfo(null);
                        entry.setOutgoingStream(null);
                        if (null != entry.getProcessingJob()) {
                            entry.getProcessingJob().setSending(false);
                        }
                        entry.setCancelID(info.getMessage().getMsgID());
                    }
                    if (null != entry.getProcessingJob()) {
                        entry.getProcessingJob().getCS().enter();
                        entry.getProcessingJob().getOutgoingQueue().remove(info);
                        entry.getProcessingJob().getCS().leave();
                    }
                }
                finally {
                    entry.CS.leave();
                }
            }
            if (Queue != null) {
                Queue.remove(info);
            } else {
                for (int j = 0; j < this.connections.size(); ++j) {
                    entry = (MCInetConnectionEntry)this.connections.elementAt(j);
                    entry.CS.enter();
                    try {
                        MCInetTransportJob job = entry.getProcessingJob();
                        if (job == null) continue;
                        job.getCS().enter();
                        try {
                            int idx = job.getOutgoingQueue().indexOf(info);
                            if (idx == -1) continue;
                            job.getOutgoingQueue().remove(idx);
                            break;
                        }
                        finally {
                            job.getCS().leave();
                        }
                    }
                    finally {
                        entry.CS.leave();
                    }
                }
                this.outgoingQueue.remove(info);
            }
        }
        finally {
            this.criticalSection.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void cleanOutgoingQueue() {
        this.criticalSection.enter();
        try {
            while (this.outgoingQueue.size() > 0) {
                this.cancelMessageByID(((MCMessageInfo)this.outgoingQueue.elementAt(0)).getMessage().getMsgID(), 51);
            }
        }
        finally {
            this.criticalSection.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void cleanupMessages() {
        int i = 0;
        int j = 0;
        MCMessageInfo Info = null;
        long TC = 0L;
        boolean me = false;
        MCInetConnectionEntry entry = null;
        TC = System.currentTimeMillis();
        i = 0;
        this.criticalSection.enter();
        try {
            while (i < this.outgoingQueue.size()) {
                Info = (MCMessageInfo)this.outgoingQueue.get(i);
                if (Info.getTimeout() == 0) {
                    ++i;
                    continue;
                }
                boolean bl = me = TC - Info.getStartTime() >= (long)Info.getTimeout();
                if (me) {
                    this.cancelMessage(null, Info);
                    Info.setState((byte)8);
                    if (this.getMessenger() == null) continue;
                    this.linkCriticalSection.enter();
                    try {
                        if (this.messenger == null) continue;
                        this.messenger.completeCriticalSection.enter();
                        try {
                            this.messenger.completeQueue.add(Info);
                            this.messenger.completeEvent.signal();
                            if (Info.getReplyFlag() == null) continue;
                            Info.getReplyFlag().signal();
                            continue;
                        }
                        finally {
                            this.messenger.completeCriticalSection.leave();
                            continue;
                        }
                    }
                    finally {
                        this.linkCriticalSection.leave();
                        continue;
                    }
                }
                ++i;
            }
        }
        finally {
            this.criticalSection.leave();
        }
        for (j = 0; j < this.connections.size(); ++j) {
            entry = (MCInetConnectionEntry)this.connections.elementAt(j);
            entry.CS.enter();
            try {
                MCInetTransportJob job = entry.getProcessingJob();
                if (job == null) continue;
                i = 0;
                job.getCS().enter();
                try {
                    while (i < job.getOutgoingQueue().size()) {
                        Info = (MCMessageInfo)job.getOutgoingQueue().get(i);
                        me = Info.getTimeout() > 0 ? TC - Info.getStartTime() >= (long)Info.getTimeout() : false;
                        if (me) {
                            this.cancelMessage(job.getOutgoingQueue(), Info);
                            Info.setState((byte)8);
                            if (this.getMessenger() == null) continue;
                            this.linkCriticalSection.enter();
                            try {
                                if (this.messenger == null) continue;
                                this.messenger.completeCriticalSection.enter();
                                try {
                                    this.messenger.completeQueue.add(Info);
                                    this.messenger.completeEvent.signal();
                                    if (Info.getReplyFlag() == null) continue;
                                    Info.getReplyFlag().signal();
                                    continue;
                                }
                                finally {
                                    this.messenger.completeCriticalSection.leave();
                                    continue;
                                }
                            }
                            finally {
                                this.linkCriticalSection.leave();
                                continue;
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                finally {
                    job.getCS().leave();
                }
            }
            finally {
                entry.CS.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MCMessageInfo getMessageByID(long MsgID) {
        MCMessageInfo Info;
        int i;
        MCMessageInfo res = null;
        MCInetConnectionEntry entry = null;
        this.criticalSection.enter();
        try {
            for (i = 0; i < this.outgoingQueue.size(); ++i) {
                Info = (MCMessageInfo)this.outgoingQueue.elementAt(i);
                if (Info.getMessage().getMsgID() != MsgID) continue;
                res = Info;
                break;
            }
        }
        finally {
            this.criticalSection.leave();
        }
        if (res != null) {
            return res;
        }
        block10: for (int j = 0; j < this.connections.size(); ++j) {
            entry = (MCInetConnectionEntry)this.connections.elementAt(j);
            entry.CS.enter();
            try {
                MCInetTransportJob job = entry.getProcessingJob();
                if (job == null) continue;
                job.getCS().enter();
                try {
                    for (i = 0; i < job.getOutgoingQueue().size(); ++i) {
                        Info = (MCMessageInfo)job.getOutgoingQueue().get(i);
                        if (Info.getMessage().getMsgID() != MsgID) continue;
                        res = Info;
                        continue block10;
                    }
                    continue;
                }
                finally {
                    job.getCS().leave();
                }
            }
            finally {
                entry.CS.leave();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initiateDelivery(MCInetTransportJob thread, MCInetConnectionEntry entry) throws EMCError {
        MCSocket socket = null;
        MCMessageInfo info = null;
        MCInetConnectionEntry newEntry = null;
        MCInetTransportJob newJob = null;
        boolean r = false;
        boolean fromPool = true;
        boolean isMessage = this.outgoingQueue.size() > 0;
        boolean isClientMode = this.transportMode == 0 || this.transportMode == 2;
        boolean shouldCreateJob = true;
        if (isMessage && isClientMode && shouldCreateJob) {
            newEntry = this.createConnectionEntry();
            if (null != this.getEncryptor()) {
                newEntry.setEncryptID(this.getEncryptor().getID());
            }
            if (null != this.getCompressor()) {
                newEntry.setCompressID(this.getCompressor().getID());
            }
            if (null != this.getSealer()) {
                newEntry.setSealID(this.getSealer().getID());
            }
            newJob = this.createTransportJob();
            this.connections.add(newEntry);
            info = (MCMessageInfo)this.outgoingQueue.elementAt(0);
            String s = info.getDMessenger();
            boolean removedItems = false;
            int i = 0;
            while (i < this.outgoingQueue.size()) {
                MCMessageInfo candidateInfo = (MCMessageInfo)this.outgoingQueue.elementAt(i);
                if (MCInetTransport.compareAddress(s, candidateInfo.getDMessenger(), false)) {
                    candidateInfo.setConnID(newEntry.getConnID());
                    candidateInfo.setClientID(newEntry.getClientID());
                    this.outgoingQueue.remove(candidateInfo);
                    newJob.getOutgoingQueue().add(candidateInfo);
                    continue;
                }
                ++i;
            }
            socket = this.createClientSocket();
            newJob.setOwner(this);
            try {
                newJob.initialize(socket, newEntry);
            }
            catch (EMCError e) {
                MCGlobals.DEBUG_STACKTRACE(e);
                this.connections.remove(newEntry);
                boolean bl = false;
                return bl;
            }
            newEntry.setProcessingJob(newJob);
            newEntry.setRemoteAddress(info.getDMessenger());
            newEntry.setRemoteSAddress(info.getDMessenger());
            this.threadPool.postJob(newJob);
            r = true;
        }
        return r;
    }

    protected boolean IsImmediateDelivery(String remAddr) {
        int P1 = remAddr.indexOf(58);
        int P2 = -1;
        if (P1 != -1) {
            P2 = remAddr.indexOf(58, P1 + 1);
        }
        if (P1 != -1 && P2 != -1) {
            return false;
        }
        return P1 != -1 && P2 == -1;
    }

    public boolean getNoTransformerFallback() {
        return this.noTransformerFallback;
    }

    public void setNoTransformerFallback(boolean value) {
        this.noTransformerFallback = value;
    }

    public int getIncomingBufferSize() {
        return this.incomingBufferSize;
    }

    public void setIncomingBufferSize(int value) {
        if (this.incomingBufferSize != value && value >= 1024) {
            this.incomingBufferSize = value;
        }
    }

    public int getOutgoingBufferSize() {
        return this.outgoingBufferSize;
    }

    public void setOutgoingBufferSize(int value) {
        if (this.outgoingBufferSize != value && value >= 1024) {
            this.outgoingBufferSize = value;
        }
    }

    public int getIncomingSpeedLimit() {
        return this.incomingSpeedLimit;
    }

    public void setIncomingSpeedLimit(int value) {
        if (this.incomingSpeedLimit != value && value >= 0) {
            this.incomingSpeedLimit = value;
        }
    }

    public int getOutgoingSpeedLimit() {
        return this.outgoingSpeedLimit;
    }

    public void setOutgoingSpeedLimit(int value) {
        if (this.outgoingSpeedLimit != value && value >= 0) {
            this.outgoingSpeedLimit = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIncomingConnectionCount() {
        int res = 0;
        int i = 0;
        MCInetConnectionEntry entry = null;
        MCInetTransportJob job = null;
        this.criticalSection.enter();
        try {
            for (i = 0; i < this.connections.size(); ++i) {
                entry = (MCInetConnectionEntry)this.connections.elementAt(i);
                entry.getCS().enter();
                try {
                    job = entry.processingJob;
                    if (job == null || job.getTransporter().getDirection() != 1) continue;
                    ++res;
                    continue;
                }
                finally {
                    entry.getCS().leave();
                }
            }
        }
        finally {
            this.criticalSection.leave();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutgoingConnectionCount() {
        int res = 0;
        int i = 0;
        MCInetConnectionEntry entry = null;
        MCInetTransportJob job = null;
        this.criticalSection.enter();
        try {
            for (i = 0; i < this.connections.size(); ++i) {
                entry = (MCInetConnectionEntry)this.connections.elementAt(i);
                entry.getCS().enter();
                try {
                    job = entry.processingJob;
                    if (job == null || job.getTransporter().getDirection() != 0) continue;
                    ++res;
                    continue;
                }
                finally {
                    entry.getCS().leave();
                }
            }
        }
        finally {
            this.criticalSection.leave();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutgoingMessagesCount() {
        int res = 0;
        this.criticalSection.enter();
        try {
            res = this.outgoingQueue.size();
            for (int j = 0; j < this.connections.size(); ++j) {
                MCInetConnectionEntry entry = (MCInetConnectionEntry)this.connections.elementAt(j);
                entry.CS.enter();
                try {
                    MCInetTransportJob job = entry.getProcessingJob();
                    if (job == null) continue;
                    res += job.getOutgoingQueue().size();
                    continue;
                }
                finally {
                    entry.CS.leave();
                }
            }
        }
        finally {
            this.criticalSection.leave();
        }
        return res;
    }

    public boolean getReuseServerPort() {
        return this.reuseServerPort;
    }

    public void setReuseServerPort(boolean value) {
        this.reuseServerPort = value;
    }

    public MCSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(MCSocketFactory value) {
        this.socketFactory = value;
    }

    public byte getBandwidthPolicy() {
        return this.bandwidthPolicy;
    }

    public void setBandwidthPolicy(byte value) {
        this.bandwidthPolicy = value;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int value) {
        if (value >= 0) {
            this.connectionTimeout = value;
        }
    }

    public synchronized void removeSocketConnectedListener(SocketConnectedListener l) {
        if (this.SocketConnectedListeners != null && this.SocketConnectedListeners.contains(l)) {
            this.SocketConnectedListeners.removeElement(l);
        }
    }

    public synchronized void addSocketConnectedListener(SocketConnectedListener l) {
        if (this.SocketConnectedListeners == null) {
            this.SocketConnectedListeners = new Vector(2);
        }
        if (!this.SocketConnectedListeners.contains(l)) {
            this.SocketConnectedListeners.addElement(l);
        }
    }

    protected boolean fireSocketConnected(SocketConnectedEvent e) {
        if (this.SocketConnectedListeners != null) {
            Vector listeners = this.SocketConnectedListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((SocketConnectedListener)listeners.elementAt(i)).socketConnected(e);
                if (!e.getAllowConnection()) break;
            }
        }
        return e.getAllowConnection();
    }

    public synchronized void removeSocketDisconnectedListener(SocketDisconnectedListener l) {
        if (this.SocketDisconnectedListeners != null && this.SocketDisconnectedListeners.contains(l)) {
            this.SocketDisconnectedListeners.removeElement(l);
        }
    }

    public synchronized void addSocketDisconnectedListener(SocketDisconnectedListener l) {
        Vector v;
        Vector vector = v = this.SocketDisconnectedListeners == null ? new Vector(2) : (Vector)this.SocketDisconnectedListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.SocketDisconnectedListeners = v;
        }
    }

    protected void fireSocketDisconnected(SocketDisconnectedEvent e) {
        if (this.SocketDisconnectedListeners != null) {
            Vector listeners = this.SocketDisconnectedListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((SocketDisconnectedListener)listeners.elementAt(i)).socketDisconnected(e);
            }
        }
    }

    @Override
    protected String getMessageSource(MCMessageInfo info) {
        MCInetConnectionEntry entry = this.findEntry(info.getDMessenger(), info);
        String s = null != entry ? entry.getRemoteAddress() : info.getSMessenger();
        if (this.getName() == "") {
            return this.defaultTransportName + ":" + s;
        }
        return this.getName() + ":" + s;
    }
}

