/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSocket;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.eldos.MsgConnect.IntegerHolder;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCMessage;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCFileStream;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMemStream;
import org.eldos.MsgConnect.MCMutex;
import org.eldos.MsgConnect.MCRemoteAddress;
import org.eldos.MsgConnect.MCSock.EMCSockError;
import org.eldos.MsgConnect.MCSock.MCSocket;
import org.eldos.MsgConnect.MCSock.MCSocketJob;
import org.eldos.MsgConnect.MCSock.MCStdSocket;
import org.eldos.MsgConnect.MCSocket.MCInetConnectionEntry;
import org.eldos.MsgConnect.MCSocket.MCInetHeader;
import org.eldos.MsgConnect.MCSocket.MCInetTransport;
import org.eldos.MsgConnect.MCSocket.SocketConnectedEvent;
import org.eldos.MsgConnect.MCSocket.SocketDisconnectedEvent;
import org.eldos.MsgConnect.MCStream;

public abstract class MCInetTransportJob
extends MCSocketJob {
    protected MCInetConnectionEntry entry = null;
    protected byte[] incomingBuffer = null;
    protected byte[] outgoingBuffer = null;
    protected MCSocket transporter = null;
    protected boolean initialized = false;
    protected boolean isReceiving = false;
    protected boolean isSending = false;
    protected boolean canSend = true;
    protected boolean isConnected = false;
    protected MCInetTransport owner = null;
    protected boolean newAttempt = false;
    protected boolean useMem = true;
    protected byte priorityCount = (byte)-2;
    protected int curPriority = 5;
    protected long inactiveTimeCount = 0L;
    protected Vector outgoingQueue = new Vector();
    protected MCMutex criticalSection = new MCMutex();
    protected boolean errorFlag = false;
    protected boolean timeout = false;
    protected boolean closeConnection = false;
    protected int lastReceived = 0;
    protected int incomingBufferSize = 0;
    protected int outgoingBufferSize = 0;
    protected int incomingSpeedLimit;
    protected int outgoingSpeedLimit;
    protected long blInSessionStartTime;
    protected long blOutSessionStartTime;
    protected long blInMsgStartTime;
    protected long blOutMsgStartTime;
    protected long blInSessionTransferred;
    protected long blOutSessionTransferred;
    protected long blInMsgTransferred;
    protected long blOutMsgTransferred;
    protected long blInSecTransferred;
    protected long blOutSecTransferred;
    protected long blInNextTime = 0L;
    protected long blOutNextTime = 0L;
    protected int blToRecv;
    protected int blToSend;
    protected long activityTime;
    protected long lastMsgSendTime;
    protected long lastMsgRecvTime;
    protected int lastMsgSendState;
    protected int lastMsgRecvState;
    protected int serverRequestTime;
    boolean wasConnected = false;

    public MCInetTransportJob() {
        this.adjustBufferSize(8192, 8192);
    }

    public void adjustBufferSize(int Incoming, int Outgoing) {
        this.incomingBufferSize = Incoming;
        this.incomingBuffer = new byte[Incoming];
        this.outgoingBufferSize = Outgoing;
        this.outgoingBuffer = new byte[Outgoing];
        this.blToRecv = Incoming;
        this.blToSend = Outgoing;
    }

    public void adjustSpeedLimits(int Incoming, int Outgoing) {
        this.incomingSpeedLimit = Incoming;
        this.outgoingSpeedLimit = Outgoing;
    }

    public void initialize(MCSocket socket, MCInetConnectionEntry entry) throws EMCError {
        if (socket == null || entry == null) {
            throw new NullPointerException();
        }
        this.setTransporter(socket);
        this.setEntry(entry);
        this.initialized = true;
    }

    public void setReceiving(boolean receiving) {
        this.isReceiving = receiving;
        if (!receiving && this.entry != null) {
            this.entry.setMsgSize(0);
        }
    }

    public boolean getReceiving() {
        return this.isReceiving;
    }

    public void setSending(boolean sending) {
        this.isSending = sending;
    }

    public boolean getSending() {
        return this.isSending;
    }

    public void setOwner(MCInetTransport owner) {
        this.owner = owner;
    }

    public MCInetTransport getOwner() {
        return this.owner;
    }

    public void setTransporter(MCSocket socket) {
        this.transporter = socket;
    }

    public MCSocket getTransporter() {
        return this.transporter;
    }

    public void setEntry(MCInetConnectionEntry entry) {
        this.entry = entry;
    }

    public MCInetConnectionEntry getEntry() {
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MCMessageInfo getMessageForDelivery() {
        MCMessageInfo r = null;
        MCMessageInfo r1 = null;
        this.criticalSection.enter();
        try {
            for (int i = 0; i < this.outgoingQueue.size(); ++i) {
                r = (MCMessageInfo)this.outgoingQueue.get(i);
                if (this.entry.getClientID() != 0) {
                    if (r.getState() != 1 && r.getState() != 4 && r.getState() != 5 && r.getState() != 6 && r.getState() != 7) continue;
                    r1 = r;
                } else {
                    if (r.getState() != 6) continue;
                    r1 = r;
                }
                break;
            }
        }
        finally {
            this.criticalSection.leave();
        }
        return r1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean prepareMessageForSending() {
        MCMessageInfo info = null;
        MCStream outStream = null;
        MCInetHeader header = null;
        byte[] dataBuf = null;
        boolean im = false;
        boolean wrt = false;
        int extra = 0;
        int i = 0;
        byte bt = 0;
        try {
            this.owner.enterCriticalSection();
            try {
                this.entry.getCS().enter();
                try {
                    if (this.entry.getInfo() == null) {
                        this.entry.setInfo(this.getMessageForDelivery());
                        if (this.entry.getInfo() == null) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    info = this.entry.getInfo();
                    String s = this.owner.createSMessenger(this.entry.getClientID(), this.entry.getConnID(), this.transporter.getLocalAddress(), this.owner.getMessengerPort());
                    info.setSMessenger(s);
                    this.entry.getInfo().setState(this.entry.getInfo().getOldState());
                    outStream = new MCMemStream();
                    im = false;
                    if (info.getEncodedMsg() != null) {
                        im = true;
                    }
                    if (!im) {
                        info.writeToStream(outStream);
                    }
                    info.setState((byte)2);
                    if (im) {
                        dataBuf = info.getEncodedMsg();
                        info.setEncodedMsg(null);
                        info.setEncodedLen(0);
                    } else {
                        dataBuf = ((MCMemStream)outStream).toByteArray();
                        outStream.close();
                        outStream = null;
                        MCMessageDataHolder md = new MCMessageDataHolder(dataBuf);
                        md.setEncryptID(this.entry.getEncryptID());
                        md.setCompressID(this.entry.getCompressID());
                        md.setSealID(this.entry.getSealID());
                        MCRemoteAddress remAddr = new MCRemoteAddress();
                        MCInetTransport.parseRemoteAddr(info.getDMessenger(), remAddr);
                        s = remAddr.getIP() != null && remAddr.getIP().length() > 0 ? remAddr.getIP() + ":" + remAddr.getPort() : "";
                        this.owner.prepareDataBlock(s, md);
                        dataBuf = md.getData();
                    }
                    header = new MCInetHeader();
                    header.setDataSize(24 + info.getSMessenger().length() + dataBuf.length);
                    extra = 14;
                    extra += info.getRecvPath().length() + info.getRouteTo().length() + info.getDQueue().length();
                    if (im) {
                        header.setCompressID(info.getCompressID());
                        header.setEncryptID(info.getEncryptID());
                        header.setSealID(info.getSealID());
                    } else {
                        header.setCompressID(this.entry.getCompressID());
                        header.setEncryptID(this.entry.getEncryptID());
                        header.setSealID(this.entry.getSealID());
                    }
                    header.setDataSize(header.getDataSize() + extra);
                    if (this.owner.getUseTempFilesForOutgoing() && (long)header.getDataSize() > this.owner.getOutgoingMemoryThreshold()) {
                        try {
                            outStream = new MCFileStream(this.createTempFile());
                        }
                        catch (IOException e) {
                            outStream = new MCMemStream();
                        }
                    } else {
                        outStream = new MCMemStream();
                    }
                    header.writeToStream(outStream);
                    byte[] b = info.getSMessenger().getBytes("US-ASCII");
                    outStream.write(b.length + extra);
                    if (b.length > 0) {
                        outStream.write(b, 0, b.length);
                    }
                    wrt = false;
                    bt = 0;
                    outStream.write(bt);
                    bt = info.getTransactCmd();
                    outStream.write(bt);
                    i = info.getRecvPath().length();
                    outStream.write(i);
                    if (i > 0) {
                        outStream.write(info.getRecvPath().getBytes("US-ASCII"));
                    }
                    i = info.getRouteTo().length();
                    outStream.write(i);
                    if (i > 0) {
                        outStream.write(info.getRouteTo().getBytes("US-ASCII"));
                    }
                    i = info.getDQueue().length();
                    outStream.write(i);
                    if (i > 0) {
                        outStream.write(info.getDQueue().getBytes("US-ASCII"));
                    }
                    wrt = true;
                    outStream.write(dataBuf, 0, dataBuf.length);
                    outStream.setPosition(0);
                    this.entry.setOutgoingStream(outStream);
                    this.setSending(true);
                    return true;
                }
                finally {
                    this.entry.getCS().leave();
                }
            }
            finally {
                this.owner.leaveCriticalSection();
            }
        }
        catch (Exception e) {
            MCGlobals.DEBUG_STACKTRACE(e);
        }
        return true;
    }

    protected abstract boolean receiveData();

    protected abstract boolean sendData();

    protected abstract boolean postConnectionStep();

    protected abstract void setTransporterAddress() throws Exception;

    protected boolean waitForSignal(long ms) {
        long time = System.currentTimeMillis();
        long finish = time + ms;
        while (time <= finish && !this.getTerminated()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (0L == ms) continue;
            time = System.currentTimeMillis();
        }
        return false;
    }

    protected boolean clientConnect() throws Exception {
        boolean tryToConnect = true;
        boolean breakFlag = false;
        this.setTransporterAddress();
        try {
            this.transporter.setUseSocks(this.owner.getUseSocks());
            this.transporter.setSocksAuthentication(this.owner.getSocksAuthentication());
            this.transporter.setSocksPassword(this.owner.getSocksPassword());
            this.transporter.setSocksUserCode(this.owner.getSocksUserCode());
            this.transporter.setSocksPort(this.owner.getSocksPort());
            this.transporter.setSocksServer(this.owner.getSocksServer());
            this.transporter.setSocksPort(this.owner.getSocksPort());
            this.transporter.setSocksVersion(this.owner.getSocksVersion());
            this.transporter.setUseWebTunneling(this.owner.getUseWebTunneling());
            this.transporter.setWebTunnelAuthentication(this.owner.getWebTunnelAuthentication());
            this.transporter.setWebTunnelPassword(this.owner.getWebTunnelPassword());
            this.transporter.setWebTunnelUserId(this.owner.getWebTunnelUserId());
            this.transporter.setWebTunnelPort(this.owner.getWebTunnelPort());
            this.transporter.setWebTunnelAddress(this.owner.getWebTunnelAddress());
            this.transporter.setWebTunnelPort(this.owner.getWebTunnelPort());
            int timeout = this.owner.getConnectionTimeout();
            if (timeout == 0) {
                timeout = 30000;
            }
            this.transporter.connect(timeout);
            if (this.transporter.getState() == 4) {
                if (this.transporter.afterConnection(this.owner.getConnectionTimeout()) != 0) {
                    this.transporter.close(true);
                }
                if (this.transporter.getState() == 4 && this.initializeConnection()) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleIncomingData() {
        try {
            if (this.entry.getIncomingStream() == null || this.entry.getIncomingStream().getPosition() == 0) {
                this.blInMsgStartTime = System.currentTimeMillis();
                this.blInMsgTransferred = 0L;
            }
        }
        catch (IOException e) {
            this.blInMsgStartTime = System.currentTimeMillis();
            this.blInMsgTransferred = 0L;
        }
        if (!this.receiveData()) return false;
        try {
            if (!this.messageReceivedCompletely2()) return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean handleOutgoingData() {
        try {
            if (this.entry.getOutgoingStream() == null || this.entry.getOutgoingStream().getPosition() == 0) {
                this.blOutMsgStartTime = System.currentTimeMillis();
                this.blOutMsgTransferred = 0L;
            }
        }
        catch (IOException e) {
            this.blOutMsgStartTime = System.currentTimeMillis();
            this.blOutMsgTransferred = 0L;
        }
        if (this.sendData()) {
            try {
                this.messageSentCompletely();
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int selectSocket(boolean RecvAllowed, long timeoutMS) throws EMCSockError {
        long time = System.currentTimeMillis();
        long finish = Long.MAX_VALUE - timeoutMS < time ? Long.MAX_VALUE : time + timeoutMS;
        boolean dataAvailable = false;
        boolean messageAvailable = false;
        while (!(time > finish || dataAvailable || this.getTerminated() || messageAvailable)) {
            if (RecvAllowed) {
                try {
                    dataAvailable = this.transporter.available();
                }
                catch (Exception e) {
                    dataAvailable = true;
                }
                if (dataAvailable) break;
            }
            this.entry.getCS().enter();
            try {
                messageAvailable = false;
                try {
                    if (this.transporter.selectNow(4) != 0 && (this.getSending() || this.getMessageForDelivery() != null)) {
                        messageAvailable = true;
                    }
                }
                catch (Exception ex) {
                    throw new EMCSockError(ex.getMessage());
                }
            }
            finally {
                this.entry.getCS().leave();
            }
            if (messageAvailable) break;
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                MCGlobals.DEBUG_STACKTRACE(e);
            }
            if (timeoutMS == 0L) continue;
            time = System.currentTimeMillis();
        }
        int resCode = 0;
        if (messageAvailable) {
            resCode += 2;
        }
        if (dataAvailable) {
            resCode += 4;
        }
        return resCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setMessageForSending() {
        boolean bRet = false;
        this.entry.getCS().enter();
        try {
            if (this.entry.getInfo() == null) {
                MCMessageInfo info = this.getMessageForDelivery();
                this.entry.setInfo(info);
                if (null != info) {
                    info.setOldState(info.getState());
                    info.setState((byte)2);
                }
            }
            bRet = this.entry.getInfo() != null;
        }
        finally {
            this.entry.getCS().leave();
        }
        return bRet;
    }

    protected abstract void updateConnectionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean failCurrentMessage(int errorCode) {
        MCMessageInfo info = null;
        boolean result = false;
        this.entry.getCS().enter();
        try {
            this.criticalSection.enter();
            try {
                if (this.outgoingQueue.size() > 0 && ((info = (MCMessageInfo)this.outgoingQueue.get(0)).getState() == 6 || info.getOldState() == 6)) {
                    this.outgoingQueue.remove(0);
                    if (this.entry.getInfo() == info) {
                        this.entry.setInfo(null);
                    }
                }
                int index = 0;
                if (this.entry.getInfo() != null) {
                    index = this.outgoingQueue.indexOf(this.entry.getInfo());
                }
                if (index >= 0 && this.outgoingQueue.size() > 0) {
                    info = (MCMessageInfo)this.outgoingQueue.get(index);
                    info.setMCError(errorCode);
                    this.outgoingQueue.remove(index);
                    if (this.entry.getInfo() == info) {
                        this.entry.setInfo(null);
                    }
                    this.criticalSection.leave();
                    this.entry.getCS().leave();
                    try {
                        this.owner.deliveryFailed(info);
                    }
                    finally {
                        this.entry.getCS().enter();
                        this.criticalSection.enter();
                    }
                }
                result = this.outgoingQueue.size() > 0;
            }
            finally {
                this.criticalSection.leave();
            }
        }
        finally {
            this.entry.getCS().leave();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performRecvSend() {
        long CurTicks;
        long InactTime = 0L;
        this.blInMsgStartTime = CurTicks = System.currentTimeMillis();
        this.blOutMsgStartTime = CurTicks;
        while (!(this.errorFlag || this.timeout || this.closeConnection || this.getTerminated())) {
            try {
                long timeoutV;
                int x1;
                if (!this.getSending() && this.setMessageForSending()) {
                    this.prepareMessageForSending();
                }
                if (this.isRequestNeeded()) {
                    this.criticalSection.enter();
                    try {
                        this.outgoingQueue.insertElementAt(this.makeEmptyPacket((byte)6), 0);
                        continue;
                    }
                    finally {
                        this.criticalSection.leave();
                        continue;
                    }
                }
                this.updateConnectionContext();
                this.adjustSpeedLimits(this.owner.getIncomingSpeedLimit(), this.owner.getOutgoingSpeedLimit());
                boolean IsBWLimit = this.incomingSpeedLimit > 0 || this.outgoingSpeedLimit > 0;
                CurTicks = System.currentTimeMillis() + 1000L;
                boolean RecvAllowed = true;
                this.blToRecv = this.incomingBufferSize;
                if (this.incomingSpeedLimit > 0) {
                    if (this.owner.getBandwidthPolicy() == 1) {
                        if (CurTicks > this.blInNextTime) {
                            this.blInNextTime = (CurTicks / 1000L + 1L) * 1000L;
                            this.blInSecTransferred = 0L;
                        }
                        if (this.blInSecTransferred < (long)this.incomingSpeedLimit) {
                            this.blToRecv = this.incomingSpeedLimit;
                            if (this.incomingBufferSize < this.blToRecv) {
                                this.blToRecv = this.incomingBufferSize;
                            }
                            if (this.blToRecv == 0) {
                                RecvAllowed = false;
                            }
                        } else {
                            RecvAllowed = false;
                        }
                    } else if (this.blInSessionTransferred > (CurTicks - this.blInSessionStartTime) * (long)this.incomingSpeedLimit / 1000L || this.blInMsgTransferred > (CurTicks - this.blInMsgStartTime) * (long)this.incomingSpeedLimit / 1000L) {
                        RecvAllowed = false;
                    } else {
                        this.blToRecv = (int)((CurTicks - this.blInSessionStartTime) * (long)this.incomingSpeedLimit / 1000L - this.blInSessionTransferred);
                        x1 = (int)((CurTicks - this.blInMsgStartTime) * (long)this.incomingSpeedLimit / 1000L - this.blInMsgTransferred);
                        if (x1 < this.blToRecv) {
                            this.blToRecv = x1;
                        }
                        if (this.incomingBufferSize < this.blToRecv) {
                            this.blToRecv = this.incomingBufferSize;
                        }
                        if (this.blToRecv > this.incomingSpeedLimit) {
                            this.blToRecv = this.incomingSpeedLimit;
                        }
                        if (this.blToRecv == 0) {
                            RecvAllowed = false;
                        }
                    }
                }
                boolean SendAllowed = true;
                this.blToSend = this.outgoingBufferSize;
                if (this.getSending() && this.outgoingSpeedLimit > 0) {
                    if (this.owner.getBandwidthPolicy() == 1) {
                        if (CurTicks > this.blOutNextTime) {
                            this.blOutNextTime = (CurTicks / 1000L + 1L) * 1000L;
                            this.blOutSecTransferred = 0L;
                        }
                        if (this.blOutSecTransferred < (long)this.outgoingSpeedLimit) {
                            this.blToSend = this.outgoingSpeedLimit;
                            if (this.outgoingBufferSize < this.blToSend) {
                                this.blToSend = this.outgoingBufferSize;
                            }
                            if (this.blToSend == 0) {
                                SendAllowed = false;
                            }
                        } else {
                            SendAllowed = false;
                        }
                    } else if (this.blOutSessionTransferred > (CurTicks - this.blOutSessionStartTime) * (long)this.outgoingSpeedLimit / 1000L || this.blOutMsgTransferred > (CurTicks - this.blOutMsgStartTime) * (long)this.outgoingSpeedLimit / 1000L) {
                        SendAllowed = false;
                    } else {
                        this.blToSend = (int)((CurTicks - this.blOutSessionStartTime) * (long)this.outgoingSpeedLimit / 1000L - this.blOutSessionTransferred);
                        x1 = (int)((CurTicks - this.blOutMsgStartTime) * (long)this.outgoingSpeedLimit / 1000L - this.blOutMsgTransferred);
                        if (x1 < this.blToSend) {
                            this.blToSend = x1;
                        }
                        if (this.outgoingBufferSize < this.blToSend) {
                            this.blToSend = this.outgoingBufferSize;
                        }
                        if (this.blToSend > this.outgoingSpeedLimit) {
                            this.blToSend = this.outgoingSpeedLimit;
                        }
                        if (this.blToSend == 0) {
                            SendAllowed = false;
                        }
                    }
                }
                InactTime = this.owner.getInactivityTime();
                if (IsBWLimit && (InactTime == 0L || InactTime > 1000L)) {
                    timeoutV = 1000L;
                } else if (this.serverRequestTime != 0) {
                    timeoutV = Math.min(this.serverRequestTime, 1000);
                } else {
                    timeoutV = (int)InactTime;
                    if (timeoutV == 0L) {
                        timeoutV = Long.MAX_VALUE;
                    }
                }
                if (RecvAllowed && this.transporter.hasBufferedIncomingData()) {
                    if (this.handleIncomingData()) {
                        this.changeLastRecvTime(this.lastMsgRecvState);
                        continue;
                    }
                    this.errorFlag = true;
                    continue;
                }
                if (SendAllowed) {
                    boolean bSending = this.getSending();
                    if (!bSending || this.handleOutgoingData()) {
                        if (this.transporter.postprocessOutgoingData() && bSending) {
                            this.changeLastSendTime(this.lastMsgSendState);
                        }
                    } else {
                        this.errorFlag = true;
                    }
                }
                if (this.errorFlag) continue;
                int select_res = this.selectSocket(RecvAllowed, timeoutV);
                if (RecvAllowed && (select_res & 4) != 0 && this.transporter.preprocessIncomingData()) {
                    if (this.handleIncomingData()) {
                        this.changeLastRecvTime(this.lastMsgRecvState);
                    } else {
                        this.errorFlag = true;
                    }
                }
                if ((select_res & 2) != 0 || select_res != 0) continue;
                if (IsBWLimit || this.serverRequestTime != 0) {
                    if (this.owner.getInactivityTime() > 0L) {
                        MCGlobals.DEBUG_PRINTLN("Currently activityTime is " + this.activityTime);
                        long elapsed = System.currentTimeMillis() - this.activityTime;
                        MCGlobals.DEBUG_PRINTLN("elapsed: " + elapsed);
                        this.timeout = elapsed > this.owner.getInactivityTime();
                        continue;
                    }
                    this.timeout = false;
                    continue;
                }
                this.timeout = true;
            }
            catch (Exception e) {
                this.errorFlag = true;
                MCGlobals.DEBUG_STACKTRACE(e);
            }
        }
        return true;
    }

    protected MCMessageInfo makeEmptyPacket(byte state) {
        MCMessageInfo res = new MCMessageInfo();
        res.setOrigID(MCMessage.getUniqueID());
        res.setDQueue("");
        res.setDMessenger(this.owner.createSMessenger(this.entry.getClientID(), this.entry.getConnID(), this.transporter.getLocalAddress(), this.owner.getMessengerPort()));
        res.setSMessenger(this.entry.remoteAddress);
        res.setMCError(0);
        res.setState(state);
        res.setStartTime(System.currentTimeMillis());
        res.setTimeout((int)this.owner.getMsgTimeout());
        return res;
    }

    protected void finalizeJob() {
        this.entry = null;
        this.setSending(false);
        this.setReceiving(false);
        if (null != this.transporter) {
            this.transporter.close(false);
            this.transporter = null;
        }
    }

    @Override
    public void run() {
        try {
            if (this.transporter.getDirection() == 0) {
                this.clientExecute();
            } else {
                this.serverExecute();
            }
        }
        catch (Exception e) {
            MCGlobals.DEBUG_STACKTRACE(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void clientExecute() throws Exception {
        int n;
        this.errorFlag = false;
        this.closeConnection = false;
        this.timeout = false;
        boolean connected = false;
        try {
            while (!(this.errorFlag || this.closeConnection || this.getTerminated() || this.timeout || this.owner.getAttemptsToConnect() != 0 && this.entry.getAttempt() > this.owner.getAttemptsToConnect())) {
                if (!connected) {
                    this.entry.setAttempt(this.entry.getAttempt() + 1);
                    if (this.owner.getAttemptsToConnect() > 0 && this.entry.getAttempt() > this.owner.getAttemptsToConnect()) {
                        if (this.failCurrentMessage(205)) {
                            this.entry.setAttempt(0);
                            continue;
                        }
                        this.errorFlag = true;
                        continue;
                    }
                    if (this.entry.getAttempt() > 1) {
                        Thread.sleep(0L);
                    }
                    if (this.clientConnect()) {
                        if (this.postConnectionStep()) {
                            connected = !this.getTerminated();
                            if (!connected || this.entry.getClientID() != 0 || this.entry.getInfo() != null) continue;
                            this.criticalSection.enter();
                            try {
                                this.outgoingQueue.insertElementAt(this.makeEmptyPacket((byte)6), 0);
                                continue;
                            }
                            finally {
                                this.criticalSection.leave();
                                continue;
                            }
                        }
                        this.finalizeConnection();
                        if (this.transporter != null) {
                            this.transporter.close(true);
                        }
                    }
                    if (!(this.timeout || this.owner.getAttemptsToConnect() < this.entry.getAttempt() && this.owner.getAttemptsToConnect() != 0)) {
                        MCSocket newTransporter = this.owner.createClientSocket();
                        this.transporter.close(false);
                        this.transporter = newTransporter;
                        this.waitForSignal(this.owner.getAttemptsInterval());
                        continue;
                    }
                    if (this.failCurrentMessage(205)) {
                        this.entry.setAttempt(0);
                        continue;
                    }
                    this.errorFlag = true;
                    continue;
                }
                this.performRecvSend();
                this.finalizeConnection();
                if (!this.errorFlag || this.getTerminated() || this.timeout) continue;
                connected = false;
                boolean tryAgain = false;
                this.entry.getCS().enter();
                try {
                    this.entry.setOutgoingStream(null);
                    this.entry.setIncomingStream(null);
                    this.setReceiving(false);
                    this.setSending(false);
                }
                finally {
                    this.entry.getCS().leave();
                }
                if (!(this.timeout || this.owner.getAttemptsToConnect() <= this.entry.getAttempt() && this.owner.getAttemptsToConnect() != 0)) {
                    tryAgain = true;
                } else if (this.failCurrentMessage(206)) {
                    tryAgain = true;
                    this.entry.setAttempt(0);
                }
                if (!tryAgain) continue;
                this.errorFlag = false;
                this.closeConnection = false;
                connected = false;
                this.entry.getCS().enter();
                try {
                    this.criticalSection.enter();
                    try {
                        if (!(this.getTerminated() || this.entry.getInfo() != null || this.areRequestsInQueue() && this.entry.getClientID() != 0)) {
                            this.outgoingQueue.insertElementAt(this.makeEmptyPacket((byte)6), 0);
                        }
                    }
                    finally {
                        this.criticalSection.leave();
                    }
                }
                finally {
                    this.entry.getCS().leave();
                }
                MCSocket newTransporter = this.owner.createClientSocket();
                this.transporter.close(false);
                this.transporter = null;
                this.transporter = newTransporter;
                newTransporter = null;
                this.waitForSignal(this.owner.getAttemptsInterval());
            }
            n = ((MCStdSocket)this.transporter).getInAddr() == null ? 204 : 206;
        }
        catch (Throwable throwable) {
            int errorCode2 = ((MCStdSocket)this.transporter).getInAddr() == null ? 204 : 206;
            this.owner.enterCriticalSection();
            try {
                this.owner.getConnections().remove(this.entry);
                this.criticalSection.enter();
                try {
                    if (0 < this.outgoingQueue.size()) {
                        this.finalizeJob();
                        while (0 < this.outgoingQueue.size()) {
                            MCMessageInfo info = (MCMessageInfo)this.outgoingQueue.get(0);
                            info.setTrack(null);
                            if (info.getState() == 2 && !info.getSent()) {
                                info.setState(info.getOldState());
                            }
                            this.outgoingQueue.remove(info);
                            if (info.getOldState() != 6 && info.getOldState() != 7) {
                                if (this.owner.getDiscardUnsentMessages() && !info.isSendMsg()) {
                                    info = null;
                                    continue;
                                }
                                if (this.owner.getDiscardUnsentMessages() && info.isSendMsg() || this.getTerminated() && this.owner.failOnInactive) {
                                    info.setMCError(errorCode2);
                                    this.criticalSection.leave();
                                    this.owner.leaveCriticalSection();
                                    try {
                                        this.owner.deliveryFailed(info);
                                        continue;
                                    }
                                    finally {
                                        this.owner.enterCriticalSection();
                                        this.criticalSection.enter();
                                        continue;
                                    }
                                }
                                this.owner.outgoingQueue.add(info);
                                continue;
                            }
                            info = null;
                        }
                    } else {
                        this.finalizeJob();
                    }
                }
                finally {
                    this.criticalSection.leave();
                }
            }
            finally {
                this.owner.leaveCriticalSection();
            }
            this.errorFlag = false;
            connected = false;
            this.closeConnection = true;
            throw throwable;
        }
        int errorCode = n;
        this.owner.enterCriticalSection();
        try {
            this.owner.getConnections().remove(this.entry);
            this.criticalSection.enter();
            try {
                if (0 < this.outgoingQueue.size()) {
                    this.finalizeJob();
                    while (0 < this.outgoingQueue.size()) {
                        MCMessageInfo info = (MCMessageInfo)this.outgoingQueue.get(0);
                        info.setTrack(null);
                        if (info.getState() == 2 && !info.getSent()) {
                            info.setState(info.getOldState());
                        }
                        this.outgoingQueue.remove(info);
                        if (info.getOldState() != 6 && info.getOldState() != 7) {
                            if (this.owner.getDiscardUnsentMessages() && !info.isSendMsg()) {
                                info = null;
                                continue;
                            }
                            if (this.owner.getDiscardUnsentMessages() && info.isSendMsg() || this.getTerminated() && this.owner.failOnInactive) {
                                info.setMCError(errorCode);
                                this.criticalSection.leave();
                                this.owner.leaveCriticalSection();
                                try {
                                    this.owner.deliveryFailed(info);
                                    continue;
                                }
                                finally {
                                    this.owner.enterCriticalSection();
                                    this.criticalSection.enter();
                                    continue;
                                }
                            }
                            this.owner.outgoingQueue.add(info);
                            continue;
                        }
                        Object var3_6 = null;
                    }
                } else {
                    this.finalizeJob();
                }
            }
            finally {
                this.criticalSection.leave();
            }
        }
        finally {
            this.owner.leaveCriticalSection();
        }
        this.errorFlag = false;
        connected = false;
        this.closeConnection = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverExecute() {
        boolean connected = false;
        this.errorFlag = false;
        this.closeConnection = false;
        this.timeout = false;
        try {
            this.errorFlag = this.transporter.afterConnection(this.owner.getConnectionTimeout()) != 0;
        }
        catch (Exception E) {
            this.errorFlag = true;
        }
        if (!this.errorFlag) {
            if (!this.initializeConnection()) {
                this.errorFlag = true;
            }
            if (!this.errorFlag && !this.getTerminated() && this.postConnectionStep()) {
                this.performRecvSend();
            }
            this.finalizeConnection();
        }
        this.owner.enterCriticalSection();
        try {
            this.owner.getConnections().remove(this.entry);
            this.entry.setAttempt(0);
            this.criticalSection.enter();
            try {
                if (0 < this.outgoingQueue.size()) {
                    this.finalizeJob();
                    while (0 < this.outgoingQueue.size()) {
                        MCMessageInfo info = (MCMessageInfo)this.outgoingQueue.get(0);
                        info.setTrack(null);
                        if (info.getState() == 2 && !info.getSent()) {
                            info.setState(info.getOldState());
                        }
                        this.outgoingQueue.remove(info);
                        if (info.getOldState() != 6 && info.getOldState() != 7) {
                            if (this.owner.getDiscardUnsentMessages() && !info.isSendMsg()) {
                                info = null;
                                continue;
                            }
                            if (this.owner.getDiscardUnsentMessages() && info.isSendMsg() || this.getTerminated() && this.owner.failOnInactive) {
                                info.setMCError(206);
                                this.criticalSection.leave();
                                this.owner.leaveCriticalSection();
                                try {
                                    this.owner.deliveryFailed(info);
                                    continue;
                                }
                                finally {
                                    this.owner.enterCriticalSection();
                                    this.criticalSection.enter();
                                    continue;
                                }
                            }
                            this.owner.outgoingQueue.add(info);
                            continue;
                        }
                        Object var2_3 = null;
                    }
                } else {
                    this.finalizeJob();
                }
            }
            finally {
                this.criticalSection.leave();
            }
        }
        finally {
            this.owner.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTransformerOK(MCInetHeader Header) {
        if (this.transporter.getDirection() == 1) {
            this.owner.getLinkCriticalSection().enter();
            try {
                this.entry.setCompressID(0);
                this.entry.setSealID(0);
                this.entry.setEncryptID(0);
                this.entry.setRejectedTransformer(false);
                if (0 != Header.getCompressID()) {
                    if (null != this.owner.getCompressor()) {
                        if (this.owner.getCompressor().getID() == Header.getCompressID()) {
                            this.entry.setCompressID(Header.getCompressID());
                        } else {
                            this.entry.setRejectedTransformer(true);
                        }
                    } else {
                        this.entry.setRejectedTransformer(true);
                    }
                }
                if (0 != Header.getEncryptID()) {
                    if (null != this.owner.getEncryptor()) {
                        if (this.owner.getEncryptor().getID() == Header.getEncryptID()) {
                            this.entry.setEncryptID(Header.getEncryptID());
                        } else {
                            this.entry.setRejectedTransformer(true);
                        }
                    } else {
                        this.entry.setRejectedTransformer(true);
                    }
                }
                if (0 != Header.getSealID()) {
                    if (null != this.owner.getSealer()) {
                        if (this.owner.getSealer().getID() == Header.getSealID()) {
                            this.entry.setSealID(Header.getSealID());
                        } else {
                            this.entry.setRejectedTransformer(true);
                        }
                    } else {
                        this.entry.setRejectedTransformer(true);
                    }
                }
            }
            finally {
                this.owner.getLinkCriticalSection().leave();
            }
            return !this.entry.getRejectedTransformer();
        }
        return true;
    }

    protected int extractClientID(String S) {
        MCRemoteAddress remAddr = new MCRemoteAddress();
        MCInetTransport.parseRemoteAddr(S, remAddr);
        return remAddr.getClientID();
    }

    protected String readString(MCStream input) throws IOException, EOFException {
        int len = input.readInt();
        if (0 != len) {
            byte[] buf = new byte[len];
            input.read(buf, 0, len);
            return new String(buf);
        }
        return new String();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean areRequestsInQueue() {
        this.criticalSection.enter();
        try {
            for (int i = 0; i < this.outgoingQueue.size(); ++i) {
                MCMessageInfo info = (MCMessageInfo)this.outgoingQueue.get(i);
                if (info.getSent()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.criticalSection.leave();
        }
        return false;
    }

    protected boolean isMessageFetched() throws IOException {
        if (this.entry.getIncomingStream() != null) {
            return this.entry.getMsgSize() > 0 && this.entry.getIncomingStream().getLength() == this.entry.getMsgSize();
        }
        return false;
    }

    protected boolean parseRoutingStrings(byte[] strArray, int offset, StringBuffer outS, StringBuffer routeTo, IntegerHolder transactCmd, StringBuffer recvPath, StringBuffer dQueue) throws IOException {
        int i = offset;
        MCMemStream pathReader = new MCMemStream();
        pathReader.write(strArray, offset + 1, strArray.length - offset - 1);
        pathReader.setPosition(0);
        transactCmd.setI(pathReader.readByte());
        i = pathReader.readInt();
        recvPath.append(new String(pathReader.readBytes(i), 0, i));
        i = pathReader.readInt();
        routeTo.append(new String(pathReader.readBytes(i), 0, i));
        i = pathReader.readInt();
        dQueue.append(new String(pathReader.readBytes(i), 0, i));
        return true;
    }

    protected boolean readHeader(MCInetHeader header, StringBuffer s, IntegerHolder transactCmd, StringBuffer routeTo, StringBuffer recvPath, StringBuffer dQueue) throws IOException {
        int i;
        MCStream inStream = this.entry.getIncomingStream();
        header.readFromStream(inStream);
        int sMsgLen = inStream.readInt();
        byte[] strArray = null;
        StringBuffer newS = new StringBuffer();
        int maxMsgSize = this.owner.getMaxMsgSize() + 8192;
        if (maxMsgSize < 0) {
            maxMsgSize = this.owner.getMaxMsgSize();
        }
        if (sMsgLen > 0 && sMsgLen < maxMsgSize) {
            strArray = new byte[sMsgLen];
            inStream.read(strArray, 0, sMsgLen);
            i = 0;
            for (i = 0; i < sMsgLen; ++i) {
                if (strArray[i] != 0) continue;
                if (!this.parseRoutingStrings(strArray, i, newS, routeTo, transactCmd, recvPath, dQueue)) {
                    return false;
                }
                s.append(new String(strArray, 0, i));
                return true;
            }
        } else {
            return false;
        }
        s.append(new String(strArray, 0, i));
        return true;
    }

    protected boolean updateEntry(StringBuffer s, StringBuffer outS) throws EMCError {
        MCRemoteAddress remAddr = new MCRemoteAddress();
        outS.append(s);
        boolean isRemoteAddr = MCInetTransport.parseRemoteAddr(s.toString(), remAddr);
        if (remAddr.getClientID() != 0) {
            if (this.entry.getClientID() == 0) {
                this.entry.setClientID(remAddr.getClientID());
            }
        } else if (this.entry.getClientID() == 0) {
            this.entry.setClientID(MCMessage.getUniqueID());
        }
        if (s.length() != 0) {
            s.delete(0, s.length());
        }
        if (isRemoteAddr) {
            if (remAddr.getIP().compareTo("0.0.0.0") != 0) {
                s.append(this.owner.createSMessenger(this.entry.getClientID(), this.entry.getConnID(), remAddr.getIP(), remAddr.getPort()));
            } else {
                MCRemoteAddress oldAddr = new MCRemoteAddress();
                MCInetTransport.parseRemoteAddr(this.entry.getRemoteAddress(), oldAddr);
                s.append(this.owner.createSMessenger(this.entry.getClientID(), this.entry.getConnID(), oldAddr.getIP(), remAddr.getPort()));
            }
        } else {
            s.append(Integer.toString(this.entry.getClientID()));
            s.append(":");
            s.append(Integer.toString(this.entry.getConnID()));
        }
        this.entry.setRemoteAddress(s.toString());
        return true;
    }

    protected boolean prepareRouting(String s, String originalSMsg, StringBuffer recvPath) {
        StringBuffer tmpPath = new StringBuffer();
        tmpPath.append(this.owner.realTransportName());
        tmpPath.append(":");
        tmpPath.append(s);
        if (recvPath.length() > 0) {
            tmpPath.append("|");
            tmpPath.append(recvPath);
        }
        recvPath.delete(0, recvPath.length());
        recvPath.append(tmpPath);
        if (!this.owner.getRoutingAllowed()) {
            this.putErrorPacket(originalSMsg, s, recvPath.toString(), 0L, 27);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putErrorPacket(String dMessenger, String sMessenger, String recvPath, long msgID, int error) {
        MCMessage message = new MCMessage();
        MCMessageInfo info = new MCMessageInfo();
        info.setMessage(message);
        info.setDMessenger(dMessenger);
        info.setSMessenger(sMessenger);
        info.setMCError(error);
        info.setState((byte)5);
        info.setStartTime(System.currentTimeMillis());
        info.setTimeout((int)this.owner.getMsgTimeout());
        info.setOrigID(msgID);
        info.setMsgID();
        info.setRecvPath(recvPath);
        this.criticalSection.enter();
        try {
            this.outgoingQueue.add(info);
        }
        finally {
            this.criticalSection.leave();
        }
    }

    private MCMessageInfo loadAndUnpackMessage(MCInetHeader header, MCMemStream stream, String s, String sMsg, byte transactCmd, String recvPath) throws IOException {
        MCMessageInfo info = null;
        MCStream inStream = this.entry.getIncomingStream();
        if (inStream.getPosition() >= inStream.getLength()) {
            return null;
        }
        int dataLen = inStream.getLength() - inStream.getPosition();
        byte[] dataBufArr = new byte[dataLen];
        try {
            inStream.read(dataBufArr, 0, dataLen);
            MCMessageDataHolder dataHolder = new MCMessageDataHolder(dataBufArr);
            dataHolder.setCompressID(this.entry.getCompressID());
            dataHolder.setEncryptID(this.entry.getEncryptID());
            dataHolder.setSealID(this.entry.getSealID());
            MCRemoteAddress remAddr = new MCRemoteAddress();
            MCInetTransport.parseRemoteAddr(s, remAddr);
            if (this.owner.unprepareDataBlock(remAddr.getIP() + ":" + remAddr.getPort(), dataHolder)) {
                info = new MCMessageInfo();
                MCMessage message = new MCMessage();
                info.setMessage(message);
                info.setSMessenger(sMsg);
                info.setDMessenger(s);
                info.setTrack(this.entry);
                info.setTransactCmd(transactCmd);
                info.setRecvPath(recvPath);
                stream.write(dataHolder.getData());
                stream.setPosition(0);
                int rez = info.readFromStream(stream, this.owner.getMaxMsgSize());
                if (rez != 0) {
                    if (info.isSendMsg() && !this.getTerminated()) {
                        this.putErrorPacket(info.getDMessenger(), info.getSMessenger(), recvPath, info.getOrigID(), 8);
                    } else {
                        info = null;
                    }
                }
            }
        }
        catch (Exception e) {
            MCGlobals.DEBUG_STACKTRACE(e);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleEmptyRequest(MCMessageInfo info, MCMemStream stream) {
        this.entry.getCS().leave();
        this.owner.enterCriticalSection();
        this.entry.getCS().enter();
        try {
            int i = 0;
            this.criticalSection.enter();
            try {
                while (i < this.owner.outgoingQueue.size()) {
                    MCMessageInfo pInfo = (MCMessageInfo)this.owner.outgoingQueue.get(i);
                    if (info.getClientID() == (long)this.entry.getClientID() || info.getClientID() == 0L && MCInetTransport.compareAddress(pInfo.getSMessenger(), this.entry.getRemoteAddress(), false)) {
                        this.owner.outgoingQueue.remove(pInfo);
                        this.outgoingQueue.add(pInfo);
                        continue;
                    }
                    ++i;
                }
                if (this.outgoingQueue.size() == 0) {
                    this.outgoingQueue.add(this.makeEmptyPacket((byte)7));
                }
            }
            finally {
                this.criticalSection.leave();
            }
        }
        finally {
            this.entry.getCS().leave();
            this.owner.leaveCriticalSection();
            this.entry.getCS().enter();
            info = null;
        }
        return true;
    }

    protected boolean handleEmptyReply(MCMessageInfo info) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleDispatching(MCMessageInfo info, String recvPath) {
        info.setMsgID();
        if (info.getMessage().getDataSize() == 0) {
            info.getMessage().setData(null);
        }
        this.entry.getCS().leave();
        try {
            this.owner.messageReceived(info);
        }
        finally {
            this.entry.getCS().enter();
        }
        return true;
    }

    protected boolean handleReply(MCMessageInfo info, MCMemStream stream) {
        MCMessageInfo curInfo = null;
        int i = -1;
        this.criticalSection.enter();
        for (i = 0; i < this.outgoingQueue.size(); ++i) {
            if (((MCMessageInfo)this.outgoingQueue.get(i)).getOrigID() != info.getOrigID()) continue;
            curInfo = (MCMessageInfo)this.outgoingQueue.get(i);
            this.outgoingQueue.remove(i);
            break;
        }
        this.criticalSection.leave();
        if (null != curInfo) {
            if (0 != curInfo.getMessage().getDataType()) {
                if (null != curInfo.getMessage().getData()) {
                    curInfo.getMessage().setData(null);
                }
                if (info.getMessage().getDataSize() > 0) {
                    curInfo.getMessage().setData(info.getMessage().getData());
                } else {
                    curInfo.getMessage().setData(null);
                }
                info.getMessage().setData(null);
            }
            curInfo.getMessage().setResult(info.getMessage().getResult());
            curInfo.setMCError(info.getMCError());
            curInfo.setState(info.getState());
            this.owner.replyReceived(curInfo);
        }
        return true;
    }

    protected boolean handleUnknown(MCMessageInfo info, MCMemStream stream) {
        info = null;
        return true;
    }

    protected void updateRemoteSAddress(MCMessageInfo info) {
        if (info.getSMessenger() != null) {
            MCRemoteAddress remAddr = new MCRemoteAddress();
            boolean trueRemote = MCInetTransport.parseRemoteAddr(info.getSMessenger(), remAddr);
            StringBuffer buf = new StringBuffer();
            buf.append(this.entry.getClientID());
            buf.append(":");
            buf.append(this.entry.getConnID());
            if (trueRemote) {
                buf.append(":");
                buf.append(remAddr.getIP());
                buf.append(":");
                buf.append(remAddr.getPort());
            }
            info.setSMessenger(buf.toString());
            this.entry.setRemoteSAddress(buf.toString());
        }
    }

    protected boolean messageReceivedCompletely2() {
        boolean res;
        block18: {
            MCInetHeader header = new MCInetHeader();
            StringBuffer s = new StringBuffer();
            StringBuffer routeTo = new StringBuffer();
            StringBuffer recvPath = new StringBuffer();
            StringBuffer dQueue = new StringBuffer();
            StringBuffer originalSMsg = new StringBuffer();
            boolean dataLen = false;
            MCMemStream aStream = new MCMemStream();
            res = false;
            this.entry.getCS().enter();
            try {
                if (!this.isMessageFetched()) break block18;
                this.entry.getIncomingStream().setPosition(0);
                IntegerHolder transactCmd = new IntegerHolder();
                if (this.readHeader(header, s, transactCmd, routeTo, recvPath, dQueue)) {
                    this.updateEntry(s, originalSMsg);
                    if (routeTo.toString().compareTo("") != 0) {
                        this.prepareRouting(s.toString(), originalSMsg.toString(), recvPath);
                    } else {
                        if (!this.isTransformerOK(header)) {
                            this.putErrorPacket(originalSMsg.toString(), s.toString(), recvPath.toString(), 0L, 26);
                        }
                        this.entry.setSealID(header.getSealID());
                        this.entry.setCompressID(header.getCompressID());
                        this.entry.setEncryptID(header.getEncryptID());
                    }
                    MCMessageInfo info = this.loadAndUnpackMessage(header, aStream, s.toString(), originalSMsg.toString(), (byte)transactCmd.getI(), recvPath.toString());
                    if (null != info) {
                        if (this.transporter.getDirection() == 1) {
                            this.updateRemoteSAddress(info);
                        }
                        byte state = info.getState();
                        try {
                            info.setConnID(this.entry.getConnID());
                            info.setClientID(this.entry.getClientID());
                            switch (info.getState()) {
                                case 6: {
                                    res = this.handleEmptyRequest(info, aStream);
                                    break;
                                }
                                case 7: {
                                    res = this.handleEmptyReply(info);
                                    break;
                                }
                                case 1: {
                                    res = this.handleDispatching(info, recvPath.toString());
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    res = this.handleReply(info, aStream);
                                    break;
                                }
                                default: {
                                    res = this.handleUnknown(info, aStream);
                                }
                            }
                            if (res) {
                                this.lastMsgRecvState = state;
                            }
                        }
                        catch (Exception e) {
                            MCGlobals.DEBUG_STACKTRACE(e);
                        }
                    }
                }
                if (null != this.entry) {
                    this.entry.setIncomingStream(null);
                    this.entry.setMsgSize(0);
                }
                this.setReceiving(false);
            }
            catch (Exception e) {
                MCGlobals.DEBUG_STACKTRACE(e);
                res = false;
            }
        }
        this.entry.getCS().leave();
        return res;
    }

    public List getOutgoingQueue() {
        return this.outgoingQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean messageSentCompletely() throws Exception {
        boolean r;
        block9: {
            r = false;
            this.entry.getCS().enter();
            try {
                MCStream stream = this.entry.getOutgoingStream();
                if (stream != null) {
                    boolean bl = r = stream.getLength() == stream.getPosition();
                }
                if (!r) break block9;
                try {
                    this.entry.setAttempt(0);
                    this.entry.getInfo().setSent(true);
                    this.lastMsgSendState = this.entry.getInfo().getOldState();
                    if (this.entry.getInfo().getOldState() == 1 && this.entry.getInfo().isSendMsg() && !this.entry.getInfo().getIntermed()) {
                        MCMessage msg = this.entry.getInfo().getMessage();
                        this.entry.setInfo(null);
                    } else {
                        MCMessageInfo pMCInfo = this.entry.getInfo();
                        this.entry.setInfo(null);
                        this.criticalSection.enter();
                        this.outgoingQueue.remove(pMCInfo);
                        this.criticalSection.leave();
                        Object var3_4 = null;
                    }
                }
                finally {
                    this.entry.setOutgoingStream(null);
                    this.setSending(false);
                }
            }
            finally {
                this.entry.getCS().leave();
            }
        }
        return r;
    }

    protected File createTempFile() throws IOException {
        File dir = null;
        File tempFile = null;
        if (this.owner.getTempFilesFolder() != null) {
            dir = new File(this.owner.getTempFilesFolder());
        }
        tempFile = File.createTempFile("mc" + Integer.toHexString(MCMessage.getUniqueID()), ".msg", dir);
        return tempFile;
    }

    protected long getInactiveTimeCount() {
        return this.inactiveTimeCount;
    }

    protected void setInactiveTimeCount(long value) {
        this.inactiveTimeCount = value;
    }

    protected void addInactiveTimeCount(long value) {
        this.inactiveTimeCount += value;
    }

    protected boolean initializeConnection() {
        this.lastMsgSendTime = this.activityTime = System.currentTimeMillis();
        this.lastMsgRecvTime = this.activityTime;
        this.blInSessionStartTime = this.activityTime;
        this.blOutSessionStartTime = this.activityTime;
        this.blInSessionTransferred = 0L;
        this.blOutSessionTransferred = 0L;
        this.blInMsgStartTime = 0L;
        this.blOutMsgStartTime = 0L;
        this.blInMsgTransferred = 0L;
        this.blOutMsgTransferred = 0L;
        this.serverRequestTime = 0;
        SocketConnectedEvent e = new SocketConnectedEvent(this.owner, this.transporter.getDirection(), this.transporter.getRemoteAddress(), this.transporter.getRemotePort(), true);
        this.wasConnected = this.owner.fireSocketConnected(e);
        return this.wasConnected;
    }

    protected void finalizeConnection() {
        if (this.wasConnected) {
            SocketDisconnectedEvent e = new SocketDisconnectedEvent(this.owner, this.transporter.getDirection(), this.transporter.getRemoteAddress(), this.transporter.getRemotePort());
            this.owner.fireSocketDisconnected(e);
        }
    }

    protected void changeLastSendTime(int state) {
        this.activityTime = this.lastMsgSendTime = System.currentTimeMillis();
    }

    protected void changeLastRecvTime(int state) {
        this.activityTime = this.lastMsgRecvTime = System.currentTimeMillis();
    }

    protected boolean isRequestNeeded() {
        return false;
    }

    public MCMutex getCS() {
        return this.criticalSection;
    }
}

