/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCSocket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eldos.MsgConnect.BooleanHolder;
import org.eldos.MsgConnect.MCDataInputStream;
import org.eldos.MsgConnect.MCFileStream;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMemStream;
import org.eldos.MsgConnect.MCRemoteAddress;
import org.eldos.MsgConnect.MCSocket.MCInetHeader;
import org.eldos.MsgConnect.MCSocket.MCInetTransport;
import org.eldos.MsgConnect.MCSocket.MCInetTransportJob;
import org.eldos.MsgConnect.MCStream;

public class MCSocketTransportJob
extends MCInetTransportJob {
    protected boolean handshakeWaitingReply = false;
    protected boolean inHandshake = false;

    protected boolean needClose() {
        return false;
    }

    public boolean getInHandshake() {
        return this.inHandshake;
    }

    public void setInHandshake(boolean handshake) {
        this.inHandshake = handshake;
    }

    @Override
    protected void setTransporterAddress() throws Exception {
        MCRemoteAddress remAddr = new MCRemoteAddress();
        MCInetTransport.parseRemoteAddr(this.entry.getRemoteAddress(), remAddr);
        this.transporter.setRemoteAddress(remAddr.getIP());
        this.transporter.setRemotePort(remAddr.getPort());
    }

    @Override
    protected void updateConnectionContext() {
    }

    @Override
    protected boolean postConnectionStep() {
        this.inHandshake = true;
        boolean res = false;
        res = this.performHandshake();
        this.inHandshake = false;
        return res;
    }

    protected boolean hsRequestReceived() throws Exception {
        MCInetHeader header = new MCInetHeader();
        boolean i = false;
        int inStream = 0;
        Object sMessenger = null;
        this.entry.getCS().enter();
        try {
            inStream = this.entry.getIncomingStream().getLength();
        }
        catch (IOException e) {
            this.entry.getCS().leave();
            throw e;
        }
        if (this.entry.getIncomingStream() != null && this.entry.getMsgSize() > 0 && inStream == this.entry.getMsgSize()) {
            try {
                this.entry.getIncomingStream().setPosition(0);
                header.readFromStream(this.entry.getIncomingStream());
                String sMsg = this.readString(this.entry.getIncomingStream());
            }
            catch (Exception e) {
                this.entry.getCS().leave();
                throw e;
            }
            this.setReceiving(false);
            if (this.entry.getIncomingStream() != null) {
                this.entry.getIncomingStream().close();
            }
            this.entry.setIncomingStream(null);
            this.entry.setMsgSize(0);
            this.prepareReplyForHandshake(header);
            this.entry.getCS().leave();
            return true;
        }
        this.entry.getCS().leave();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean performHandshake() {
        BooleanHolder result = new BooleanHolder();
        while (true) {
            if (!this.getSending() && this.transporter.getDirection() == 0 && !this.handshakeWaitingReply) {
                if (!this.prepareMessageForHandshake()) {
                    return false;
                }
                this.setSending(true);
                continue;
            }
            boolean b = false;
            try {
                b = this.transporter.available();
            }
            catch (Exception ex) {
                return false;
            }
            if (b) {
                if (!this.receiveData()) return result.b;
                if (this.transporter.getDirection() == 1) {
                    try {
                        this.hsRequestReceived();
                        continue;
                    }
                    catch (Exception E) {
                        result.setB(false);
                        return result.b;
                    }
                }
                if (this.transporter.getDirection() != 0) continue;
                try {
                    if (!this.hsReplyReceived(result)) continue;
                    return result.b;
                }
                catch (Exception ex) {
                    result.setB(false);
                }
                return result.b;
            }
            if (this.transporter.hasBufferedOutgoingData() || this.getSending() && this.sendData()) {
                if (this.transporter.postprocessOutgoingData() && this.getSending()) {
                    if (this.transporter.getDirection() == 1) {
                        if (this.hsPacketSent() && !this.transporter.hasBufferedOutgoingData()) {
                            return true;
                        }
                    } else if (this.transporter.getDirection() == 0 && this.hsPacketSent()) {
                        this.handshakeWaitingReply = true;
                        continue;
                    }
                }
            } else if (this.getSending()) {
                return false;
            }
            long time = this.owner.getInactivityTime();
            int s = -1;
            while (!this.terminated) {
                try {
                    if (this.transporter.available()) {
                        s = 1;
                        break;
                    }
                    Thread.currentThread();
                    Thread.sleep(10L);
                    if (time != 0L) {
                        time -= 10L;
                    }
                    if (this.owner.getInactivityTime() == 0L || time > 0L) continue;
                    break;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (s == -1) {
                return false;
            }
            if (s == 1) {
                try {
                    if (this.transporter.preprocessIncomingData()) {
                        BooleanHolder Success;
                        if (!this.receiveData()) return false;
                        if (this.transporter.getDirection() == 1) {
                            this.hsRequestReceived();
                            continue;
                        }
                        if (this.transporter.getDirection() == 0 && this.hsReplyReceived(Success = new BooleanHolder())) {
                            return Success.getB();
                        }
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (this.terminated) return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareReplyForHandshake(MCInetHeader rqHeader) {
        MCInetHeader header = new MCInetHeader();
        this.owner.getLinkCriticalSection().enter();
        try {
            if (this.owner.getCompressor() != null && this.owner.getCompressor().getID() == rqHeader.getCompressID()) {
                header.setCompressID(rqHeader.getCompressID());
            } else if (this.owner.getNoTransformerFallback() && this.owner.getCompressor() != null && this.owner.getCompressor().getID() != rqHeader.getCompressID()) {
                header.setCompressID(-1);
            } else {
                header.setCompressID(0);
            }
            if (this.owner.getEncryptor() != null && this.owner.getEncryptor().getID() == rqHeader.getEncryptID()) {
                header.setEncryptID(rqHeader.getEncryptID());
            } else if (this.owner.getNoTransformerFallback() && this.owner.getEncryptor() != null && this.owner.getEncryptor().getID() != rqHeader.getEncryptID()) {
                header.setEncryptID(-1);
            } else {
                header.setEncryptID(0);
            }
            if (this.owner.getSealer() != null && this.owner.getSealer().getID() == rqHeader.getSealID()) {
                header.setSealID(rqHeader.getSealID());
            } else if (this.owner.getNoTransformerFallback() && this.owner.getSealer() != null && this.owner.getSealer().getID() != rqHeader.getSealID()) {
                header.setSealID(-1);
            } else {
                header.setSealID(0);
            }
        }
        finally {
            this.owner.getLinkCriticalSection().leave();
        }
        this.entry.setCompressID(header.getCompressID());
        this.entry.setEncryptID(header.getEncryptID());
        this.entry.setSealID(header.getSealID());
        header.setDataSize(24);
        MCMemStream outStream = new MCMemStream();
        this.entry.setOutgoingStream(outStream);
        try {
            header.writeToStream(outStream);
            outStream.write(0);
            outStream.setPosition(0);
        }
        catch (Exception e) {
            return false;
        }
        this.setSending(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareMessageForHandshake() {
        MCMemStream outStream = new MCMemStream();
        boolean ret = true;
        MCInetHeader header = new MCInetHeader();
        this.owner.getLinkCriticalSection().enter();
        try {
            if (this.owner.getCompressor() != null) {
                header.setCompressID(this.owner.getCompressor().getID());
            } else {
                header.setCompressID(0);
            }
            if (this.owner.getEncryptor() != null) {
                header.setEncryptID(this.owner.getEncryptor().getID());
            } else {
                header.setEncryptID(0);
            }
            if (this.owner.getSealer() != null) {
                header.setSealID(this.owner.getSealer().getID());
            } else {
                header.setSealID(0);
            }
        }
        finally {
            this.owner.getLinkCriticalSection().leave();
        }
        outStream = new MCMemStream();
        this.entry.getCS().enter();
        try {
            String sMessenger = this.entry.getClientID() + ":" + this.transporter.getLocalAddress() + ":" + this.owner.getMessengerPort();
            header.setDataSize(24);
            this.entry.setOutgoingStream(outStream);
            try {
                header.writeToStream(outStream);
                outStream.write(0);
                ((MCStream)outStream).setPosition(0);
                this.setSending(true);
            }
            catch (Exception e) {
                ret = false;
                this.setSending(false);
                try {
                    ((MCStream)outStream).close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        finally {
            this.entry.getCS().leave();
        }
        return ret;
    }

    protected void resetTransfer() {
        this.handshakeWaitingReply = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sendData() {
        int toSend = 0;
        int sent = 0;
        if (this.getSending()) {
            this.entry.getCS().enter();
            try {
                MCStream is = this.entry.getOutgoingStream();
                try {
                    if (is.getLength() > 0) {
                        toSend = is.getLength() - is.getPosition() < this.blToSend ? is.getLength() - is.getPosition() : this.blToSend;
                        is.read(this.outgoingBuffer, 0, toSend);
                        sent = this.transporter.send(this.outgoingBuffer, 0, toSend);
                        this.transporter.flush();
                        this.blOutSessionTransferred += (long)sent;
                        this.blOutMsgTransferred += (long)sent;
                        this.blOutSecTransferred += (long)sent;
                        is.setPosition(this.entry.getOutgoingStream().getPosition() - toSend + sent);
                    }
                }
                catch (Exception e) {
                    boolean bl = false;
                    this.entry.getCS().leave();
                    return bl;
                }
            }
            finally {
                this.entry.getCS().leave();
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hsPacketSent() {
        this.entry.getCS().enter();
        try {
            if (this.entry.getOutgoingStream() != null && this.entry.getOutgoingStream().getLength() != this.entry.getOutgoingStream().getPosition()) {
                boolean bl = false;
                this.entry.getCS().leave();
                return bl;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        this.setSending(false);
        try {
            if (this.entry.getOutgoingStream() != null) {
                this.entry.getOutgoingStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entry.setOutgoingStream(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hsReplyReceived(BooleanHolder Success) throws Exception {
        boolean success;
        block7: {
            MCInetHeader header = new MCInetHeader();
            int inStream = 0;
            success = false;
            this.entry.getCS().enter();
            try {
                inStream = this.entry.getIncomingStream().getLength();
                if (this.entry.getIncomingStream() == null || this.entry.getMsgSize() <= 0 || inStream != this.entry.getMsgSize()) break block7;
                MCStream is = this.entry.getIncomingStream();
                is.setPosition(0);
                header.readFromStream(is);
                String sMessenger = this.readString(is);
                boolean bl = success = header.getEncryptID() != -1 && header.getCompressID() != -1 && header.getSealID() != -1;
                if (success) {
                    success = success && (header.getEncryptID() == 0 && (!this.owner.getNoTransformerFallback() || this.owner.getEncryptor() == null) || this.owner.getEncryptor() != null && this.owner.getEncryptor().getID() == header.getEncryptID());
                    success = success && (header.getCompressID() == 0 && (!this.owner.getNoTransformerFallback() || this.owner.getCompressor() == null) || this.owner.getCompressor() != null && this.owner.getCompressor().getID() == header.getCompressID());
                    success = success && (header.getSealID() == 0 && (!this.owner.getNoTransformerFallback() || this.owner.getSealer() == null) || this.owner.getSealer() != null && this.owner.getSealer().getID() == header.getSealID());
                }
                this.entry.setEncryptID(header.getEncryptID());
                this.entry.setCompressID(header.getCompressID());
                this.entry.setSealID(header.getSealID());
                this.entry.setMsgSize(0);
                try {
                    if (this.entry.getIncomingStream() != null) {
                        this.entry.getIncomingStream().close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.entry.setIncomingStream(null);
                this.setReceiving(false);
                Success.setB(success);
                boolean bl2 = true;
                return bl2;
            }
            finally {
                this.entry.getCS().leave();
            }
        }
        Success.setB(success);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean receiveData() {
        int received = 0;
        boolean toRecv = false;
        Object baos = null;
        try {
            if (!this.transporter.available()) {
                return true;
            }
        }
        catch (Exception e) {
            this.transporter.close(false);
            this.entry.setMsgSize(0);
            return false;
        }
        this.entry.getCS().enter();
        if (!this.getReceiving()) {
            try {
                received = this.transporter.receive(this.incomingBuffer, -this.entry.getMsgSize(), 8);
                if (received > 0) {
                    this.blInSessionTransferred += (long)received;
                    this.blInMsgTransferred += (long)received;
                    this.blInSecTransferred += (long)received;
                    this.entry.setMsgSize(this.entry.getMsgSize() - received);
                    if (received + -this.entry.getMsgSize() < 8) {
                        boolean e = true;
                        return e;
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.incomingBuffer);
                    MCDataInputStream dis = new MCDataInputStream(bais);
                    int sig = dis.readInt();
                    if (sig != 1346652485) {
                        throw new Exception();
                    }
                    this.entry.setMsgSize(dis.readInt());
                    if (this.owner.getMaxMsgSize() != 0 && this.entry.getMsgSize() > this.owner.getMaxMsgSize()) {
                        this.entry.setMsgSize(0);
                        boolean bl = false;
                        return bl;
                    }
                    dis.close();
                    bais.close();
                }
            }
            catch (Exception e) {
                this.entry.setMsgSize(0);
                boolean dis = false;
                return dis;
            }
            finally {
                this.entry.getCS().leave();
            }
            try {
                this.owner.enterCriticalSection();
                try {
                    this.entry.getCS().enter();
                    try {
                        if (this.entry.getMsgSize() < 24 || this.entry.getMsgSize() > this.owner.getMaxMsgSize()) {
                            throw new Exception();
                        }
                        this.useMem = true;
                        if (this.owner.getUseTempFilesForIncoming() && (long)this.entry.getMsgSize() > this.owner.getIncomingMemoryThreshold()) {
                            try {
                                this.entry.setIncomingStream(new MCFileStream(this.createTempFile()));
                                this.useMem = false;
                            }
                            catch (IOException e) {
                                MCGlobals.DEBUG_STACKTRACE(e);
                            }
                        }
                        if (this.useMem) {
                            this.entry.setIncomingStream(new MCMemStream());
                        }
                        this.entry.getIncomingStream().write(this.incomingBuffer, 0, received);
                        this.setReceiving(true);
                    }
                    finally {
                        this.entry.getCS().leave();
                    }
                }
                finally {
                    this.owner.leaveCriticalSection();
                }
            }
            catch (Exception e) {
                this.transporter.close(false);
                this.entry.getCS().enter();
                try {
                    this.entry.setMsgSize(0);
                    if (this.entry.getIncomingStream() != null) {
                        this.entry.getIncomingStream().close();
                        this.entry.setIncomingStream(null);
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    this.entry.getCS().leave();
                }
                return false;
            }
            return true;
        }
        try {
            int size = this.entry.getMsgSize() - this.entry.getIncomingStream().getLength();
            received = size > this.blToRecv ? this.transporter.receive(this.incomingBuffer, 0, this.blToRecv) : this.transporter.receive(this.incomingBuffer, 0, size);
            if (received > 0) {
                this.blInSessionTransferred += (long)received;
                this.blInMsgTransferred += (long)received;
                this.blInSecTransferred += (long)received;
            }
            this.entry.getIncomingStream().write(this.incomingBuffer, 0, received);
        }
        catch (Exception e) {
            this.transporter.close(false);
            this.entry.setMsgSize(0);
            boolean bl = false;
            return bl;
        }
        finally {
            this.entry.getCS().leave();
        }
        return true;
    }

    @Override
    protected boolean initializeConnection() {
        if (super.initializeConnection()) {
            this.handshakeWaitingReply = false;
            return true;
        }
        return false;
    }
}

