/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect;

import java.io.EOFException;
import java.io.IOException;

public abstract class MCStream {
    private static long[] LongBitMask = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte value) throws IOException {
        byte[] valueByte = new byte[]{value};
        this.write(valueByte, 0, 1);
    }

    public void write(short value) throws IOException {
        byte[] valueBytes = new byte[]{(byte)(value & 0xFF), (byte)(value >>> 8 & 0xFF)};
        this.write(valueBytes, 0, 2);
    }

    public void write(int value) throws IOException {
        byte[] valueBytes = new byte[]{(byte)(value & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 24 & 0xFF)};
        this.write(valueBytes, 0, 4);
    }

    public void writeLong(long value) throws IOException {
        byte[] longValue = new byte[8];
        for (int i = 0; i < 8; ++i) {
            longValue[i] = (byte)(value >>> i * 8 & 0xFFL);
        }
        this.write(longValue, 0, 8);
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public byte[] readBytes(int len) throws IOException {
        byte[] buf = new byte[len];
        int wasRead = this.read(buf, 0, len);
        if (wasRead < len) {
            throw new EOFException();
        }
        return buf;
    }

    public byte readByte() throws IOException, EOFException {
        byte[] inByte = new byte[1];
        int wasRead = this.read(inByte, 0, 1);
        if (0 == wasRead) {
            throw new EOFException();
        }
        return inByte[0];
    }

    public short readShort() throws IOException, EOFException {
        byte[] intBytes = new byte[2];
        int wasRead = this.read(intBytes, 0, 2);
        if (wasRead < 2) {
            throw new EOFException();
        }
        short result = (short)(intBytes[0] & 0xFF);
        result = (short)(result | (short)(intBytes[1] & 0xFF) << 8);
        return result;
    }

    public int readInt() throws IOException, EOFException {
        byte[] intBytes = new byte[4];
        int wasRead = this.read(intBytes, 0, 4);
        if (wasRead < 4) {
            throw new EOFException();
        }
        int result = intBytes[0] & 0xFF;
        result |= (intBytes[1] & 0xFF) << 8;
        result |= (intBytes[2] & 0xFF) << 16;
        return result |= (intBytes[3] & 0xFF) << 24;
    }

    protected char quad2hex(byte quad) {
        switch (quad) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return (char)(quad + 48);
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return '0';
    }

    protected void byte2hex(byte arg, StringBuffer buffer) {
        byte half = (byte)(arg & 0xF);
        char firstChar = this.quad2hex(half);
        half = (byte)(arg >>> 4 & 0xF);
        char secondChar = this.quad2hex(half);
        try {
            buffer.append(firstChar);
            buffer.append(secondChar);
            boolean i = false;
            if (i) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public long readLong() throws IOException, EOFException {
        byte[] longBytes = new byte[8];
        int wasRead = this.read(longBytes, 0, 8);
        if (wasRead < 8) {
            throw new EOFException();
        }
        long rez = 0L;
        long b = 0L;
        long tr = 0L;
        for (int i = 0; i < 8; ++i) {
            b = longBytes[i];
            tr = b << i * 8;
            rez |= (tr &= LongBitMask[i]);
        }
        return rez;
    }

    public double readDouble() throws IOException, EOFException {
        return Double.longBitsToDouble(this.readLong());
    }

    public abstract void setPosition(int var1) throws IOException;

    public abstract int getPosition() throws IOException;

    public abstract int getLength() throws IOException;

    public abstract void close();
}

