/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect;

import java.util.Vector;
import org.eldos.MsgConnect.MCAbstractJob;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCJobQueue;
import org.eldos.MsgConnect.MCSemaphore;
import org.eldos.MsgConnect.MCWorkerThread;

public class MCThreadPool
implements MCJobQueue {
    protected int inactivityIdle = 5;
    protected Vector jobQueue = new Vector();
    protected MCSemaphore signal = new MCSemaphore(0L);
    protected Vector threadList = new Vector();
    protected int threadSize = 0;
    protected int busyCount = 0;
    protected int jobsRan = 0;

    public void setInactivityIdle(int idle) {
        this.inactivityIdle = idle;
    }

    public int getInactivityIdle() {
        return this.inactivityIdle;
    }

    @Override
    public int getThreadSize() {
        return this.threadSize;
    }

    public void setThreadSize(int size) {
        this.threadSize = size;
    }

    @Override
    public int getActualThreadSize() {
        return this.threadList.size();
    }

    public void setJobsRan(int n) {
        this.jobsRan = 0;
    }

    public int getJobsRan() {
        return this.jobsRan;
    }

    public void showStat(String desc) {
        StringBuffer buf = new StringBuffer();
        buf.append(desc);
        buf.append(" Pool stat: size = ");
        buf.append(this.threadList.size());
        buf.append(" busy = ");
        buf.append(this.busyCount);
        buf.append(" job size = ");
        buf.append(this.jobQueue.size());
        MCGlobals.DEBUG_PRINTLN(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postJob(MCAbstractJob job) {
        Vector vector = this.threadList;
        synchronized (vector) {
            boolean noNeedThread;
            boolean bl = noNeedThread = this.threadList.size() - this.busyCount - this.jobQueue.size() > 0;
            if (!(noNeedThread || this.threadList.size() <= this.threadSize && this.threadSize != 0)) {
                MCWorkerThread thr = new MCWorkerThread(this);
                this.threadList.add(thr);
                ++this.busyCount;
                thr.start();
            }
            Vector vector2 = this.jobQueue;
            synchronized (vector2) {
                this.jobQueue.add(job);
            }
            this.signal.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MCAbstractJob getJob() {
        MCAbstractJob job = null;
        Vector vector = this.threadList;
        synchronized (vector) {
            if (this.busyCount > 0) {
                --this.busyCount;
            }
        }
        try {
            this.signal.attempt(this.inactivityIdle * 1000);
        }
        catch (InterruptedException e) {
            Vector vector2 = this.threadList;
            synchronized (vector2) {
                ++this.busyCount;
            }
            return null;
        }
        vector = this.threadList;
        synchronized (vector) {
            ++this.busyCount;
        }
        vector = this.jobQueue;
        synchronized (vector) {
            if (this.jobQueue.size() > 0) {
                job = (MCAbstractJob)this.jobQueue.elementAt(0);
                this.jobQueue.removeElementAt(0);
                ++this.jobsRan;
            }
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector vector = this.threadList;
        synchronized (vector) {
            Vector vector2 = this.jobQueue;
            synchronized (vector2) {
                this.jobQueue.removeAllElements();
            }
            for (int i = 0; i < this.threadList.size(); ++i) {
                MCWorkerThread thr = (MCWorkerThread)this.threadList.elementAt(i);
                thr.setTerminated();
                this.signal.release();
            }
        }
        while (this.threadList.size() != 0) {
            Thread.yield();
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                MCGlobals.DEBUG_STACKTRACE(e);
            }
        }
        this.busyCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThread(MCWorkerThread thr) {
        Vector vector = this.threadList;
        synchronized (vector) {
            this.threadList.removeElement(thr);
            if (this.busyCount > 0) {
                --this.busyCount;
            }
        }
    }
}

