/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCUDPSocket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCMessage;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMemStream;
import org.eldos.MsgConnect.MCRemoteAddress;
import org.eldos.MsgConnect.MCSock.MCStdSocket;
import org.eldos.MsgConnect.MCSocket.MCInetHeader;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPThread;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPTransport;

public class MCUDPReceiverThread
extends MCUDPThread {
    protected MCStdSocket recvSocket = null;
    protected DatagramPacket datagramPacket = null;
    byte[] recvBuffer = null;

    protected MCUDPReceiverThread(boolean CreateSuspended) {
    }

    @Override
    public void initialize(MCUDPTransport aOwner) throws EMCError {
        super.initialize(aOwner);
        this.recvSocket = new MCStdSocket();
        this.recvSocket.setLocalPort(this.owner.getMessengerPort());
        this.recvSocket.setLocalAddress(this.owner.getMessengerAddress());
        this.recvSocket.init((byte)2);
        try {
            if (this.owner.getReuseServerPort()) {
                this.recvSocket.reusePort();
            }
        }
        catch (SocketException e1) {
            throw new EMCError(8);
        }
        this.recvSocket.bind();
        this.datagramPacket = new DatagramPacket(new byte[512], 512);
        for (int i = 0; i < aOwner.multicastList.size(); ++i) {
            int ml;
            String val = (String)aOwner.multicastList.get(i);
            int mle = ml = 0;
            mle = val.indexOf("|", ml);
            String groupAddress = val.substring(ml, mle);
            ml = mle + 1;
            mle = val.indexOf("|", ml);
            String bindAddress = val.substring(ml, mle);
            this.recvSocket.addToMulticastSrv(groupAddress, bindAddress);
        }
    }

    @Override
    public synchronized void setTerminated() {
        String s = this.recvSocket.getLocalAddress();
        InetAddress addr = null;
        if (s != null) {
            try {
                addr = InetAddress.getByName(s);
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        if (addr == null) {
            try {
                addr = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException ex1) {
                // empty catch block
            }
        }
        DatagramPacket dt = new DatagramPacket(new byte[0], 0, addr, this.recvSocket.getLocalPort());
        super.setTerminated();
        try {
            DatagramSocket ds = new DatagramSocket();
            ds.send(dt);
        }
        catch (Exception ex2) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.getTerminated()) {
            try {
                this.ReceiveMessage();
            }
            catch (Exception ex) {
                MCGlobals.DEBUG_STACKTRACE(ex);
            }
        }
        this.recvSocket.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTransformerOK(MCInetHeader Header) {
        boolean r = true;
        this.owner.getLinkCriticalSection().enter();
        try {
            if (0 != Header.getCompressID() && (null != this.owner.getCompressor() || this.owner.getCompressor().getID() == Header.getCompressID())) {
                Header.setCompressID(0);
                r = false;
            }
            if (0 != Header.getEncryptID() && (null != this.owner.getEncryptor() || this.owner.getEncryptor().getID() == Header.getEncryptID())) {
                Header.setEncryptID(0);
                r = false;
            }
            if (0 != Header.getSealID() && (null != this.owner.getSealer() || this.owner.getSealer().getID() == Header.getSealID())) {
                Header.setSealID(0);
                r = false;
            }
        }
        finally {
            this.owner.getLinkCriticalSection().leave();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ReceiveMessage() throws IOException, EMCError {
        int msgSize;
        String remoteAddr;
        int recvres;
        MCInetHeader header = null;
        MCMessage message = null;
        String s = "";
        String s1 = "";
        String RouteTo = "";
        String RecvPath = "";
        byte TransactCmd = 0;
        String DQueue = "";
        int received = 0;
        try {
            this.recvSocket.receive(this.datagramPacket);
            recvres = 0;
            received = this.datagramPacket.getLength();
            this.recvBuffer = this.datagramPacket.getData();
            remoteAddr = this.datagramPacket.getAddress().getHostName();
            int remotePort = this.datagramPacket.getPort();
        }
        catch (EMCError e) {
            recvres = -1;
        }
        if (recvres == 0 && received > 7 && !this.getTerminated() && (msgSize = (this.recvBuffer[4] & 0xFF) + ((this.recvBuffer[5] & 0xFF) << 8) + ((this.recvBuffer[6] & 0xFF) << 16) + ((this.recvBuffer[7] & 0xFF) << 24)) == received && received < this.owner.getMaxMsgSize()) {
            MCMemStream Stream2 = new MCMemStream();
            Stream2.write(this.recvBuffer, 0, received);
            Stream2.setPosition(0);
            header = new MCInetHeader();
            header.readFromStream(Stream2);
            int i = Stream2.readInt();
            byte[] StrArray = null;
            if (i > 0) {
                StrArray = new byte[i];
                Stream2.read(StrArray, 0, i);
                for (int j = 0; j < i; ++j) {
                    if (StrArray[j] != 0) continue;
                    i = j;
                    MCMemStream PathReader = new MCMemStream();
                    PathReader.write(StrArray, j + 1, StrArray.length - j - 1);
                    PathReader.setPosition(0);
                    TransactCmd = PathReader.readByte();
                    j = PathReader.readInt();
                    RecvPath = new String(PathReader.readBytes(j), 0, j);
                    j = PathReader.readInt();
                    RouteTo = new String(PathReader.readBytes(j), 0, j);
                    j = PathReader.readInt();
                    DQueue = new String(PathReader.readBytes(j), 0, j);
                    break;
                }
                s = new String(StrArray, 0, i);
            } else {
                s = "";
            }
            MCRemoteAddress ra = new MCRemoteAddress();
            remoteAddr = MCUDPReceiverThread.parseRemoteAddr(s, ra) ? ((s1 = ra.getIP()).compareTo("0.0.0.0") != 0 ? s1 + ":" + new Integer(ra.getPort()).toString() : this.datagramPacket.getAddress().getHostName() + ":" + new Integer(ra.getPort()).toString()) : s;
            s = "";
            String SMsg = remoteAddr.substring(0);
            if (RouteTo.length() > 0) {
                RecvPath = RecvPath.length() > 0 ? this.owner.realTransportName() + ":" + s + "|" + RecvPath : this.owner.realTransportName() + ":" + s;
            }
            if (RouteTo == null && !this.isTransformerOK(header)) {
                return true;
            }
            if (RouteTo.length() > 0 && !this.owner.getRoutingAllowed()) {
                return true;
            }
            if (Stream2.getPosition() < Stream2.getLength()) {
                int DataLen = Stream2.getLength() - Stream2.getPosition();
                byte[] DataBuf = new byte[DataLen];
                if (DataBuf == null) {
                    throw new OutOfMemoryError();
                }
                Stream2.read(DataBuf, 0, DataBuf.length);
                if (RouteTo.length() > 0) {
                    MCMessageInfo info = new MCMessageInfo();
                    info.setMessage(new MCMessage());
                    info.setSMessenger(SMsg);
                    info.setDMessenger(remoteAddr);
                    info.setRouteTo(RouteTo);
                    info.setIntermed(true);
                    info.setRecvPath(RecvPath);
                    info.setEncodedMsg(DataBuf);
                    info.setEncodedLen(DataBuf.length);
                    info.setSealID(header.getSealID());
                    info.setEncryptID(header.getEncryptID());
                    info.setCompressID(header.getCompressID());
                    info.setStartTime(System.currentTimeMillis());
                    info.setTimeout((int)this.owner.getMsgTimeout());
                    info.setDQueue(DQueue);
                    info.setMsgID();
                    DataBuf = null;
                    this.owner.routeMessage(info);
                } else {
                    MCMessageDataHolder mdata = new MCMessageDataHolder(DataBuf);
                    mdata.setEncryptID(header.getEncryptID());
                    mdata.setCompressID(header.getCompressID());
                    mdata.setSealID(header.getSealID());
                    if (this.owner.unprepareDataBlock(remoteAddr, mdata)) {
                        MCMessageInfo info = new MCMessageInfo();
                        message = new MCMessage();
                        info.setMessage(message);
                        info.setSMessenger(SMsg);
                        info.setDMessenger(remoteAddr);
                        info.setTimeout((int)this.owner.getMsgTimeout());
                        info.setTransactCmd(TransactCmd);
                        info.setRecvPath(RecvPath);
                        Stream2 = new MCMemStream();
                        Stream2.write(mdata.getData());
                        Stream2.setPosition(0);
                        int rez = info.readFromStream(Stream2, this.owner.getMaxMsgSize());
                        if (rez == 2) {
                            throw new IOException();
                        }
                        if (info.getState() == 1) {
                            if (rez == 1 && info.isSendMsg() && !this.getTerminated()) {
                                info.setMCError(8);
                                info.setState((byte)5);
                                this.owner.getCriticalSection().enter();
                                try {
                                    this.owner.getOutgoingQueue().add(info);
                                }
                                finally {
                                    this.owner.getCriticalSection().leave();
                                }
                            }
                            this.owner.messageReceived(info);
                        } else {
                            MCMessageInfo curInfo = null;
                            this.owner.getCriticalSection().enter();
                            try {
                                for (i = 0; i < this.owner.getOutgoingQueue().size(); ++i) {
                                    if (((MCMessageInfo)this.owner.getOutgoingQueue().get(i)).getOrigID() != info.getOrigID()) continue;
                                    curInfo = (MCMessageInfo)this.owner.getOutgoingQueue().get(i);
                                    this.owner.getOutgoingQueue().remove(curInfo);
                                    break;
                                }
                            }
                            finally {
                                this.owner.getCriticalSection().leave();
                            }
                            if (curInfo != null) {
                                if (curInfo.getMessage().getDataType() != 0) {
                                    if (curInfo.getMessage().getData() != null) {
                                        curInfo.getMessage().setData(null);
                                    }
                                    curInfo.getMessage().setData(info.getMessage().getData());
                                    info.getMessage().setData(null);
                                }
                                curInfo.getMessage().setResult(info.getMessage().getResult());
                                curInfo.setMCError(info.getMCError());
                                curInfo.setState(info.getState());
                                this.owner.replyReceived(curInfo);
                            }
                        }
                    }
                }
            }
        }
        return true;
    }
}

