/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCUDPSocket;

import java.net.InetAddress;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCMessageDataHolder;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMemStream;
import org.eldos.MsgConnect.MCRemoteAddress;
import org.eldos.MsgConnect.MCSock.MCStdSocket;
import org.eldos.MsgConnect.MCSocket.MCInetHeader;
import org.eldos.MsgConnect.MCStream;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPMsgData;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPThread;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPTransport;

public class MCUDPSenderThread
extends MCUDPThread {
    protected long cancelID = 0L;
    protected MCStdSocket sendSocket = null;

    public MCUDPSenderThread(boolean CreateSuspended) {
    }

    @Override
    public void run() {
        while (!this.getTerminated()) {
            try {
                MCUDPMsgData md = new MCUDPMsgData();
                if (this.prepareMessage(md)) {
                    this.sendMessage(md);
                    continue;
                }
                Thread.sleep(1L);
            }
            catch (Exception ex) {
                MCGlobals.DEBUG_STACKTRACE(ex);
            }
        }
    }

    @Override
    public void initialize(MCUDPTransport aOwner) throws EMCError {
        super.initialize(aOwner);
        this.sendSocket = new MCStdSocket();
        this.sendSocket.setLocalPort(0);
        this.sendSocket.setLocalAddress(this.owner.getMessengerAddress());
        this.sendSocket.init((byte)2);
        for (int i = 0; i < aOwner.multicastList.size(); ++i) {
            int ml;
            String val = (String)aOwner.multicastList.get(i);
            int mle = ml = 0;
            mle = val.indexOf("|", ml);
            String groupAddress = val.substring(ml, mle);
            ml = mle + 1;
            mle = val.indexOf("|", ml);
            String bindAddress = val.substring(ml, mle);
            ml = mle + 1;
            mle = val.indexOf("|", ml);
            String TTLStr = val.substring(ml, mle);
            ml = mle + 1;
            byte ttl = (byte)Integer.parseInt(TTLStr);
            mle = val.length();
            String LoopStr = val.substring(ml, mle);
            boolean loop = Integer.parseInt(LoopStr) != 0;
            this.sendSocket.addToMulticastCli(bindAddress, ttl, loop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareMessage(MCUDPMsgData md) {
        MCMessageInfo info = null;
        MCMemStream outStream = null;
        byte[] dataBuf = null;
        md.setInfo(null);
        this.owner.getCriticalSection().enter();
        try {
            int i;
            for (i = 0; i < this.owner.getOutgoingQueue().size(); ++i) {
                MCMessageInfo r = (MCMessageInfo)this.owner.getOutgoingQueue().get(i);
                if (r.getState() != 4 && r.getState() != 5 && r.getState() != 1 && r.getState() != 6 && r.getState() != 7) continue;
                info = r;
                break;
            }
            if (info == null) {
                boolean r = false;
                return r;
            }
            info.setSMessenger(this.sendSocket.getLocalAddress() + ":" + this.owner.getMessengerPort());
            outStream = new MCMemStream();
            boolean im = false;
            if (info.getEncodedMsg() != null) {
                im = true;
            }
            if (!im) {
                info.writeToStream(outStream);
            }
            md.setInfo(info);
            md.setInfoState(info.getState());
            info.setState((byte)2);
            MCInetHeader header = new MCInetHeader();
            if (im) {
                header.setCompressID(info.getCompressID());
                header.setEncryptID(info.getEncryptID());
                header.setSealID(info.getSealID());
            } else {
                if (this.owner.getCompressor() != null) {
                    header.setCompressID(this.owner.getCompressor().getID());
                }
                if (this.owner.getEncryptor() != null) {
                    header.setEncryptID(this.owner.getEncryptor().getID());
                }
                if (this.owner.getSealer() != null) {
                    header.setSealID(this.owner.getSealer().getID());
                }
            }
            if (im) {
                dataBuf = info.getEncodedMsg();
                info.setEncodedMsg(null);
                info.setEncodedLen(0);
            } else {
                dataBuf = outStream.toByteArray();
                ((MCStream)outStream).close();
                outStream = null;
                MCMessageDataHolder mdh = new MCMessageDataHolder(dataBuf);
                mdh.setEncryptID(header.getEncryptID());
                mdh.setCompressID(header.getCompressID());
                mdh.setSealID(header.getSealID());
                this.owner.prepareDataBlock(this.sendSocket.getLocalAddress() + ":" + this.owner.getMessengerPort(), mdh);
                dataBuf = mdh.getData();
            }
            int headerDataSize = 24 + info.getSMessenger().length() + dataBuf.length;
            int extra = 14;
            header.setDataSize(headerDataSize + (extra += info.getRecvPath().length() + info.getRouteTo().length() + info.getDQueue().length()));
            outStream = new MCMemStream();
            header.writeToStream(outStream);
            byte[] b = info.getSMessenger().getBytes("US-ASCII");
            outStream.write(b.length + extra);
            if (b.length > 0) {
                ((MCStream)outStream).write(b, 0, b.length);
            }
            boolean wrt = false;
            byte bt = 0;
            outStream.write(bt);
            bt = info.getTransactCmd();
            outStream.write(bt);
            i = info.getRecvPath().length();
            outStream.write(i);
            if (i > 0) {
                outStream.write(info.getRecvPath().getBytes("US-ASCII"));
            }
            i = info.getRouteTo().length();
            outStream.write(i);
            if (i > 0) {
                outStream.write(info.getRouteTo().getBytes("US-ASCII"));
            }
            i = info.getDQueue().length();
            outStream.write(i);
            if (i > 0) {
                outStream.write(info.getDQueue().getBytes("US-ASCII"));
            }
            if (!(wrt = true)) {
                b = new byte[extra];
                for (i = 0; i < b.length; ++i) {
                    b[i] = 0;
                }
                ((MCStream)outStream).write(b, 0, b.length);
            }
            ((MCStream)outStream).write(dataBuf, 0, dataBuf.length);
            ((MCStream)outStream).setPosition(0);
            dataBuf = null;
            byte[] tmpb = new byte[((MCStream)outStream).getLength()];
            ((MCStream)outStream).read(tmpb, 0, tmpb.length);
            md.setData(tmpb);
        }
        catch (Exception ex) {
            MCGlobals.DEBUG_STACKTRACE(ex);
        }
        finally {
            this.owner.getCriticalSection().leave();
        }
        return true;
    }

    boolean sendMessage(MCUDPMsgData md) {
        boolean result = true;
        MCMessageInfo info = md.getInfo();
        byte[] dataBuf = md.getData();
        byte infoState = md.getInfoState();
        MCRemoteAddress ra = new MCRemoteAddress();
        if (MCUDPSenderThread.parseRemoteAddr(info.getDMessenger(), ra)) {
            try {
                this.sendSocket.sendTo(InetAddress.getByName(ra.getIP()), ra.getPort(), dataBuf, 0, dataBuf.length);
            }
            catch (Exception ex) {
                this.messageFailed(207, info, infoState);
                return false;
            }
            if (infoState != 1 || !info.isSendMsg() || info.getIntermed()) {
                this.messageFailed(0, info, infoState);
                result = false;
            }
        } else {
            this.messageFailed(204, info, infoState);
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageFailed(int reason, MCMessageInfo info, byte infoState) {
        block15: {
            this.owner.getLinkCriticalSection().enter();
            try {
                if (info.getState() == 1 && reason != 0 && !info.getIntermed()) {
                    this.owner.getCriticalSection().enter();
                    try {
                        this.owner.getOutgoingQueue().remove(info);
                    }
                    finally {
                        this.owner.getCriticalSection().leave();
                    }
                    this.owner.getMessenger().completeCriticalSection.enter();
                    try {
                        info.setState((byte)5);
                        info.setMCError(reason);
                        this.owner.getMessenger().completeQueue.add(info);
                        this.owner.getMessenger().completeEvent.signal();
                        if (info.getReplyFlag() != null) {
                            info.getReplyFlag().signal();
                        }
                        break block15;
                    }
                    finally {
                        this.owner.getMessenger().completeCriticalSection.leave();
                    }
                }
                this.owner.getCriticalSection().enter();
                try {
                    this.owner.getOutgoingQueue().remove(info);
                }
                finally {
                    this.owner.getCriticalSection().leave();
                }
            }
            finally {
                this.owner.getLinkCriticalSection().leave();
            }
        }
    }
}

