/*
 * Decompiled with CFR 0.152.
 */
package org.eldos.MsgConnect.MCUDPSocket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.eldos.MsgConnect.MCBase.EMCError;
import org.eldos.MsgConnect.MCBase.MCMessageInfo;
import org.eldos.MsgConnect.MCBase.MCSimpleTransport;
import org.eldos.MsgConnect.MCGlobals;
import org.eldos.MsgConnect.MCMutex;
import org.eldos.MsgConnect.MCSock.EMCSockError;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPReceiverThread;
import org.eldos.MsgConnect.MCUDPSocket.MCUDPSenderThread;

public class MCUDPTransport
extends MCSimpleTransport {
    public static final byte stmP2P = 0;
    public static final byte stmServer = 1;
    public static final byte stmClient = 2;
    protected boolean failOnInactive = true;
    protected String messengerAddress = "0.0.0.0";
    protected int messengerPort = 1459;
    protected byte transportMode = 0;
    protected boolean routingAllowed = true;
    protected Vector multicastList;
    protected boolean reuseServerPort = true;
    protected MCUDPReceiverThread receiverThread;
    protected MCUDPSenderThread senderThread;

    public boolean getRoutingAllowed() {
        return this.routingAllowed;
    }

    public void setRoutingAllowed(boolean value) {
        this.routingAllowed = value;
    }

    public void setFailOnInactive(boolean value) {
        this.failOnInactive = value;
    }

    public boolean getFailOnInactive() {
        return this.failOnInactive;
    }

    public void setMessengerAddress(String value) throws EMCError {
        if (!this.messengerAddress.equals(value)) {
            boolean b = this.getActive();
            this.setActive(false);
            if (!value.equals("255.255.255.255")) {
                try {
                    InetAddress ia = InetAddress.getByName(value);
                }
                catch (UnknownHostException e) {
                    throw new EMCSockError(204);
                }
            }
            this.messengerAddress = value;
            this.setActive(b);
        }
    }

    public String getMessengerAddress() {
        return this.messengerAddress;
    }

    public void setMessengerPort(int value) {
        if (this.messengerPort != value && value > 0 && value <= 65535) {
            boolean b = this.getActive();
            this.setActive(false);
            this.messengerPort = value;
            this.setActive(b);
        }
    }

    public int getMessengerPort() {
        return this.messengerPort;
    }

    public int getMessengerPortBound() {
        if (!this.getActive() || this.receiverThread == null) {
            return 0;
        }
        return this.receiverThread.recvSocket.getLocalPort();
    }

    public void setTransportMode(byte mode) {
        if (this.getActive()) {
            this.setActive(false);
            this.transportMode = mode;
            this.setActive(true);
        } else {
            this.transportMode = mode;
        }
    }

    public byte getTransportMode() {
        return this.transportMode;
    }

    public boolean getReuseServerPort() {
        return this.reuseServerPort;
    }

    public void setReuseServerPort(boolean value) {
        this.reuseServerPort = value;
    }

    protected MCMutex getCriticalSection() {
        return this.criticalSection;
    }

    @Override
    protected Vector getOutgoingQueue() {
        return this.outgoingQueue;
    }

    @Override
    protected boolean deliverMessage(String destAddress, MCMessageInfo info) {
        if (destAddress.length() > 0 && this.addressValid(destAddress)) {
            int i1 = destAddress.indexOf(124);
            if (i1 == -1) {
                return false;
            }
            String socketName = destAddress.substring(destAddress.indexOf(58) + 1, i1);
            i1 = socketName.indexOf(47);
            if (i1 != -1) {
                info.setUrlPart(socketName.substring(i1 + 1));
                socketName = socketName.substring(0, i1);
            } else {
                info.setUrlPart(null);
            }
            String queueName = destAddress.substring(destAddress.indexOf(124) + 1);
            if (queueName.length() == 0) {
                return false;
            }
            int j = queueName.lastIndexOf(124);
            if (j >= 0) {
                info.setRouteTo(queueName.substring(0, j));
                queueName = queueName.substring(j + 1);
            }
            info.setDQueue(queueName);
            info.setDMessenger(socketName);
            info.setState((byte)1);
            this.putMessageToOutgoing(socketName, info);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putMessageToOutgoing(String socketName, MCMessageInfo info) {
        block5: {
            boolean foundEntry = false;
            this.criticalSection.enter();
            try {
                if (info.isSendMsg()) {
                    for (int i = 0; i <= this.outgoingQueue.size(); ++i) {
                        if (i != this.outgoingQueue.size() && !((MCMessageInfo)this.outgoingQueue.elementAt(i)).isSendMsg()) continue;
                        this.outgoingQueue.insertElementAt(info, i);
                        break block5;
                    }
                    break block5;
                }
                this.outgoingQueue.add(info);
            }
            finally {
                this.criticalSection.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliveryFailed(MCMessageInfo info) {
        this.linkCriticalSection.enter();
        if (this.messenger != null && (info.getState() == 1 || info.getState() == 2) && info.isSendMsg() && !info.getIntermed()) {
            this.messenger.completeCriticalSection.enter();
            try {
                info.setState((byte)5);
                this.messenger.completeQueue.add(info);
                this.messenger.completeEvent.signal();
                if (info.getReplyFlag() != null) {
                    info.getReplyFlag().signal();
                }
            }
            finally {
                this.messenger.completeCriticalSection.leave();
            }
        }
        this.linkCriticalSection.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetActive() {
        if (this.getActive() && null == this.messenger) {
            return;
        }
        if (this.getActive()) {
            this.senderThread = null;
            if (this.getTransportMode() == 0 || this.getTransportMode() == 1) {
                this.receiverThread = new MCUDPReceiverThread(true);
                try {
                    this.receiverThread.initialize(this);
                    this.receiverThread.start();
                }
                catch (Exception e) {
                    this.receiverThread = null;
                    MCGlobals.DEBUG_STACKTRACE(e);
                    this.setActive(false);
                }
            }
            if (this.getTransportMode() == 0 || this.getTransportMode() == 2) {
                this.senderThread = new MCUDPSenderThread(true);
                try {
                    this.senderThread.initialize(this);
                    this.senderThread.start();
                }
                catch (Exception e) {
                    this.senderThread = null;
                    MCGlobals.DEBUG_STACKTRACE(e);
                    this.setActive(false);
                }
            }
        } else {
            if (this.senderThread != null) {
                this.senderThread.setTerminated();
                this.senderThread = null;
            }
            if (this.receiverThread != null) {
                this.receiverThread.setTerminated();
                this.receiverThread = null;
            }
            this.criticalSection.enter();
            try {
                while (this.outgoingQueue.size() > 0) {
                    this.cancelMessageByID(((MCMessageInfo)this.outgoingQueue.elementAt(0)).getMessage().getMsgID(), 51);
                }
            }
            finally {
                this.criticalSection.leave();
            }
        }
    }

    @Override
    protected void setInfoSMessenger(MCMessageInfo info) {
        if (this.senderThread != null) {
            info.setSMessenger(this.senderThread.sendSocket.getLocalAddress() + ":" + Integer.toString(this.getMessengerPort()));
        } else {
            info.setSMessenger("");
        }
    }

    public MCUDPTransport() {
        this.defaultTransportName = "UDP";
        this.multicastList = new Vector();
        this.setActive(false);
    }

    @Override
    public void destroy() {
        this.setActive(false);
    }

    @Override
    protected void cancelMessageInSender(MCMessageInfo info) {
        if (this.senderThread != null) {
            this.senderThread.cancelID = info.getMessage().getMsgID();
        }
    }

    @Override
    protected void messageReceived(MCMessageInfo info) {
        super.messageReceived(info);
    }

    @Override
    protected void replyReceived(MCMessageInfo info) {
        super.replyReceived(info);
    }

    protected int findMulticastAddress(String value) {
        String val = null;
        int result = -1;
        for (int i = 0; i < this.multicastList.size(); ++i) {
            val = ((String)this.multicastList.get(i)).substring(0, value.length());
            if (value.compareTo(val) != 0) continue;
            result = i;
            break;
        }
        return result;
    }

    public void joinMulticastGroup(String groupAddress, String bindAddress, int ttl, boolean loop) {
        boolean oa;
        if (groupAddress == null) {
            return;
        }
        int ma = this.findMulticastAddress(groupAddress);
        if (ma != -1) {
            this.multicastList.remove(ma);
        }
        if (oa = this.getActive()) {
            this.setActive(false);
        }
        String ba = "0.0.0.0";
        if (bindAddress != null && bindAddress.length() > 0) {
            ba = bindAddress;
        }
        StringBuffer b = new StringBuffer();
        try {
            b.append(groupAddress);
            b.append('|');
            b.append(ba);
            b.append('|');
            b.append(ttl);
            b.append('|');
            b.append(loop ? 1 : 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        String buf = b.toString();
        this.multicastList.add(buf);
        if (oa) {
            this.setActive(true);
        }
    }

    public void leaveMulticastGroup(String groupAddress) {
        int ma = this.findMulticastAddress(groupAddress);
        if (ma != -1) {
            boolean oa = this.getActive();
            if (oa) {
                this.setActive(false);
            }
            this.multicastList.remove(ma);
            if (oa) {
                this.setActive(true);
            }
        }
    }
}

